/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.utils.io.charsets.EncodingKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.StringsKt;
import io.ktor.websocket.CloseReason;
import io.ktor.websocket.Frame;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.b.a;
import kotlinx.b.q;
import kotlinx.b.t;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0013\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/ktor/websocket/Frame$Text;", "", "readText", "(Lio/ktor/websocket/Frame$Text;)Ljava/lang/String;", "Lio/ktor/websocket/Frame;", "", "readBytes", "(Lio/ktor/websocket/Frame;)[B", "Lio/ktor/websocket/Frame$Close;", "Lio/ktor/websocket/CloseReason;", "readReason", "(Lio/ktor/websocket/Frame$Close;)Lio/ktor/websocket/CloseReason;", "ktor-websockets"})
public final class FrameCommonKt {
    public static final String readText(Frame.Text text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"");
        if (!text.getFin()) {
            String string = "Text could be only extracted from non-fragmented frame";
            throw new IllegalArgumentException(string.toString());
        }
        CharsetDecoder charsetDecoder = Charsets.UTF_8.newDecoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder, (String)"");
        a a2 = new a();
        q q2 = (q)a2;
        CharsetDecoder charsetDecoder2 = charsetDecoder;
        BytePacketBuilderKt.writeFully$default((q)q2, (byte[])text.getData(), (int)0, (int)0, (int)6, null);
        return EncodingKt.decode$default((CharsetDecoder)charsetDecoder2, (t)((t)a2), (int)0, (int)2, null);
    }

    public static final byte[] readBytes(Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"");
        byte[] byArray = frame.getData();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"");
        return byArray2;
    }

    public static final CloseReason readReason(Frame.Close close2) {
        Intrinsics.checkNotNullParameter((Object)close2, (String)"");
        if (close2.getData().length < 2) {
            return null;
        }
        Object object = new a();
        q q2 = (q)object;
        BytePacketBuilderKt.writeFully$default((q)q2, (byte[])close2.getData(), (int)0, (int)0, (int)6, null);
        close2 = (t)object;
        short s2 = close2.g();
        object = StringsKt.readText$default((t)close2, null, (int)0, (int)3, null);
        return new CloseReason(s2, (String)object);
    }
}

