/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.UnsafeUtil;
import com.jogamp.common.util.ValueConv;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.security.PrivilegedAction;
import jogamp.common.Debug;
import jogamp.common.os.PlatformPropsImpl;

public class Buffers {
    static final boolean DEBUG = Debug.debug("Buffers");
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    protected Buffers() {
    }

    public static ByteBuffer newDirectByteBuffer(int n) {
        return Buffers.nativeOrder(ByteBuffer.allocateDirect(n));
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n, int n2) {
        return (ByteBuffer)Buffers.newDirectByteBuffer(n2).put(byArray, n, n2).rewind();
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n) {
        return Buffers.newDirectByteBuffer(byArray, n, byArray.length - n);
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray) {
        return Buffers.newDirectByteBuffer(byArray, 0);
    }

    public static DoubleBuffer newDirectDoubleBuffer(int n) {
        return Buffers.newDirectByteBuffer(n << 3).asDoubleBuffer();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n, int n2) {
        return (DoubleBuffer)Buffers.newDirectDoubleBuffer(n2).put(dArray, n, n2).rewind();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n) {
        return Buffers.newDirectDoubleBuffer(dArray, n, dArray.length - n);
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray) {
        return Buffers.newDirectDoubleBuffer(dArray, 0);
    }

    public static FloatBuffer newDirectFloatBuffer(int n) {
        return Buffers.newDirectByteBuffer(n << 2).asFloatBuffer();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n, int n2) {
        return (FloatBuffer)Buffers.newDirectFloatBuffer(n2).put(fArray, n, n2).rewind();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n) {
        return Buffers.newDirectFloatBuffer(fArray, n, fArray.length - n);
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray) {
        return Buffers.newDirectFloatBuffer(fArray, 0);
    }

    public static IntBuffer newDirectIntBuffer(int n) {
        return Buffers.newDirectByteBuffer(n << 2).asIntBuffer();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n, int n2) {
        return (IntBuffer)Buffers.newDirectIntBuffer(n2).put(nArray, n, n2).rewind();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n) {
        return Buffers.newDirectIntBuffer(nArray, n, nArray.length - n);
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray) {
        return Buffers.newDirectIntBuffer(nArray, 0);
    }

    public static LongBuffer newDirectLongBuffer(int n) {
        return Buffers.newDirectByteBuffer(n << 3).asLongBuffer();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n, int n2) {
        return (LongBuffer)Buffers.newDirectLongBuffer(n2).put(lArray, n, n2).rewind();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n) {
        return Buffers.newDirectLongBuffer(lArray, n, lArray.length - n);
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray) {
        return Buffers.newDirectLongBuffer(lArray, 0);
    }

    public static ShortBuffer newDirectShortBuffer(int n) {
        return Buffers.newDirectByteBuffer(n << 1).asShortBuffer();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n, int n2) {
        return (ShortBuffer)Buffers.newDirectShortBuffer(n2).put(sArray, n, n2).rewind();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n) {
        return Buffers.newDirectShortBuffer(sArray, n, sArray.length - n);
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray) {
        return Buffers.newDirectShortBuffer(sArray, 0);
    }

    public static CharBuffer newDirectCharBuffer(int n) {
        return Buffers.newDirectByteBuffer(n << 1).asCharBuffer();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n, int n2) {
        return (CharBuffer)Buffers.newDirectCharBuffer(n2).put(cArray, n, n2).rewind();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n) {
        return Buffers.newDirectCharBuffer(cArray, n, cArray.length - n);
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray) {
        return Buffers.newDirectCharBuffer(cArray, 0);
    }

    public static ByteBuffer nativeOrder(ByteBuffer byteBuffer) {
        return byteBuffer.order(ByteOrder.nativeOrder());
    }

    public static Class<? extends Buffer> typeNameToBufferClass(String string) {
        if (string == null) {
            return null;
        }
        if ("byte".equals(string)) {
            return ByteBuffer.class;
        }
        if ("short".equals(string)) {
            return ShortBuffer.class;
        }
        if ("char".equals(string)) {
            return CharBuffer.class;
        }
        if ("int".equals(string)) {
            return IntBuffer.class;
        }
        if ("float".equals(string)) {
            return FloatBuffer.class;
        }
        if ("long".equals(string)) {
            return LongBuffer.class;
        }
        if ("double".equals(string)) {
            return DoubleBuffer.class;
        }
        return null;
    }

    public static int sizeOfBufferElem(Class<? extends Buffer> clazz) {
        if (clazz == null) {
            return 0;
        }
        if (ByteBuffer.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (ShortBuffer.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (CharBuffer.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (IntBuffer.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (FloatBuffer.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (LongBuffer.class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (DoubleBuffer.class.isAssignableFrom(clazz)) {
            return 8;
        }
        throw new RuntimeException("Unexpected buffer type " + clazz.getName());
    }

    public static int sizeOfBufferElem(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof ByteBuffer) {
            return 1;
        }
        if (object instanceof IntBuffer) {
            return 4;
        }
        if (object instanceof ShortBuffer) {
            return 2;
        }
        if (object instanceof FloatBuffer) {
            return 4;
        }
        if (object instanceof DoubleBuffer) {
            return 8;
        }
        if (object instanceof LongBuffer) {
            return 8;
        }
        if (object instanceof CharBuffer) {
            return 2;
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).elementSize();
        }
        throw new RuntimeException("Unexpected buffer type " + object.getClass().getName());
    }

    public static int remainingElem(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).remaining();
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).remaining();
        }
        throw new IllegalArgumentException("Unsupported anonymous buffer type: " + object.getClass().getCanonicalName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int remainingBytes(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).remaining();
            if (object instanceof ByteBuffer) {
                return n;
            }
            if (object instanceof FloatBuffer) {
                return n << 2;
            }
            if (object instanceof IntBuffer) {
                return n << 2;
            }
            if (object instanceof ShortBuffer) {
                return n << 1;
            }
            if (object instanceof DoubleBuffer) {
                return n << 3;
            }
            if (object instanceof LongBuffer) {
                return n << 3;
            }
            if (!(object instanceof CharBuffer)) throw new InternalError("Unsupported Buffer type: " + object.getClass().getCanonicalName());
            return n << 1;
        }
        if (!(object instanceof NativeBuffer)) throw new IllegalArgumentException("Unsupported anonymous buffer type: " + object.getClass().getCanonicalName());
        NativeBuffer nativeBuffer = (NativeBuffer)object;
        return nativeBuffer.remaining() * nativeBuffer.elementSize();
    }

    public static boolean isDirect(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).isDirect();
        }
        if (object instanceof PointerBuffer) {
            return ((PointerBuffer)object).isDirect();
        }
        throw new IllegalArgumentException("Unexpected buffer type " + object.getClass().getName());
    }

    public static int getDirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return n;
            }
            if (object instanceof FloatBuffer) {
                return n << 2;
            }
            if (object instanceof IntBuffer) {
                return n << 2;
            }
            if (object instanceof ShortBuffer) {
                return n << 1;
            }
            if (object instanceof DoubleBuffer) {
                return n << 3;
            }
            if (object instanceof LongBuffer) {
                return n << 3;
            }
            if (object instanceof CharBuffer) {
                return n << 1;
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.position() * nativeBuffer.elementSize();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static Object getArray(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).array();
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).array();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static int getIndirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return ((ByteBuffer)object).arrayOffset() + n;
            }
            if (object instanceof FloatBuffer) {
                return 4 * (((FloatBuffer)object).arrayOffset() + n);
            }
            if (object instanceof IntBuffer) {
                return 4 * (((IntBuffer)object).arrayOffset() + n);
            }
            if (object instanceof ShortBuffer) {
                return 2 * (((ShortBuffer)object).arrayOffset() + n);
            }
            if (object instanceof DoubleBuffer) {
                return 8 * (((DoubleBuffer)object).arrayOffset() + n);
            }
            if (object instanceof LongBuffer) {
                return 8 * (((LongBuffer)object).arrayOffset() + n);
            }
            if (object instanceof CharBuffer) {
                return 2 * (((CharBuffer)object).arrayOffset() + n);
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.elementSize() * (nativeBuffer.arrayOffset() + nativeBuffer.position());
        }
        throw new IllegalArgumentException("Unknown buffer type " + object.getClass().getName());
    }

    public static <B extends Buffer> B slice(B object) {
        if (object instanceof ByteBuffer) {
            object = (ByteBuffer)object;
            return (B)((ByteBuffer)object).slice().order(((ByteBuffer)object).order());
        }
        if (object instanceof IntBuffer) {
            return (B)((IntBuffer)object).slice();
        }
        if (object instanceof ShortBuffer) {
            return (B)((ShortBuffer)object).slice();
        }
        if (object instanceof FloatBuffer) {
            return (B)((FloatBuffer)object).slice();
        }
        if (object instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)object).slice();
        }
        if (object instanceof LongBuffer) {
            return (B)((LongBuffer)object).slice();
        }
        if (object instanceof CharBuffer) {
            return (B)((CharBuffer)object).slice();
        }
        throw new IllegalArgumentException("unexpected buffer type: " + object.getClass());
    }

    public static <B extends Buffer> B slice(B b, int n, int n2) {
        B b2;
        int n3 = b.position();
        int n4 = b.limit();
        try {
            b.position(n).limit(n + n2);
            b2 = Buffers.slice(b);
        }
        finally {
            b.position(n3).limit(n4);
        }
        return b2;
    }

    public static final FloatBuffer slice2Float(Buffer buffer, int n, int n2) {
        FloatBuffer floatBuffer;
        block6: {
            if (buffer == null) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n << 2);
                    byteBuffer.limit(n + n2 << 2);
                    floatBuffer = byteBuffer.slice().order(byteBuffer.order()).asFloatBuffer();
                    break block6;
                }
                if (buffer instanceof FloatBuffer) {
                    FloatBuffer floatBuffer2 = (FloatBuffer)buffer;
                    floatBuffer2.position(n);
                    floatBuffer2.limit(n + n2);
                    floatBuffer = floatBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor FloarBuffer, nor backing array given");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        floatBuffer.mark();
        return floatBuffer;
    }

    public static final FloatBuffer slice2Float(float[] fArray, int n, int n2) {
        return (FloatBuffer)FloatBuffer.wrap(fArray, n, n2).mark();
    }

    public static final ShortBuffer slice2Short(Buffer buffer, int n, int n2) {
        ShortBuffer shortBuffer;
        block6: {
            if (buffer == null) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n << 1);
                    byteBuffer.limit(n + n2 << 1);
                    shortBuffer = byteBuffer.slice().order(byteBuffer.order()).asShortBuffer();
                    break block6;
                }
                if (buffer instanceof ShortBuffer) {
                    ShortBuffer shortBuffer2 = (ShortBuffer)buffer;
                    shortBuffer2.position(n);
                    shortBuffer2.limit(n + n2);
                    shortBuffer = shortBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor ShortBuffer");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        shortBuffer.mark();
        return shortBuffer;
    }

    public static final ShortBuffer slice2Short(short[] sArray, int n, int n2) {
        return (ShortBuffer)ShortBuffer.wrap(sArray, n, n2).mark();
    }

    public static final CharBuffer slice2Char(Buffer buffer, int n, int n2) {
        CharBuffer charBuffer;
        block6: {
            if (buffer == null) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n << 1);
                    byteBuffer.limit(n + n2 << 1);
                    charBuffer = byteBuffer.slice().order(byteBuffer.order()).asCharBuffer();
                    break block6;
                }
                if (buffer instanceof CharBuffer) {
                    CharBuffer charBuffer2 = (CharBuffer)buffer;
                    charBuffer2.position(n);
                    charBuffer2.limit(n + n2);
                    charBuffer = charBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor CharBuffer");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        charBuffer.mark();
        return charBuffer;
    }

    public static final CharBuffer slice2Char(char[] cArray, int n, int n2) {
        return (CharBuffer)CharBuffer.wrap(cArray, n, n2).mark();
    }

    public static final IntBuffer slice2Int(Buffer buffer, int n, int n2) {
        IntBuffer intBuffer;
        block6: {
            if (buffer == null) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n << 2);
                    byteBuffer.limit(n + n2 << 2);
                    intBuffer = byteBuffer.slice().order(byteBuffer.order()).asIntBuffer();
                    break block6;
                }
                if (buffer instanceof IntBuffer) {
                    IntBuffer intBuffer2 = (IntBuffer)buffer;
                    intBuffer2.position(n);
                    intBuffer2.limit(n + n2);
                    intBuffer = intBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor IntBuffer");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        intBuffer.mark();
        return intBuffer;
    }

    public static final IntBuffer slice2Int(int[] nArray, int n, int n2) {
        return (IntBuffer)IntBuffer.wrap(nArray, n, n2).mark();
    }

    public static final LongBuffer slice2Long(Buffer buffer, int n, int n2) {
        LongBuffer longBuffer;
        block6: {
            if (buffer == null) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n << 3);
                    byteBuffer.limit(n + n2 << 3);
                    longBuffer = byteBuffer.slice().order(byteBuffer.order()).asLongBuffer();
                    break block6;
                }
                if (buffer instanceof LongBuffer) {
                    LongBuffer longBuffer2 = (LongBuffer)buffer;
                    longBuffer2.position(n);
                    longBuffer2.limit(n + n2);
                    longBuffer = longBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor LongBuffer");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        longBuffer.mark();
        return longBuffer;
    }

    public static final LongBuffer slice2Long(long[] lArray, int n, int n2) {
        return (LongBuffer)LongBuffer.wrap(lArray, n, n2).mark();
    }

    public static final DoubleBuffer slice2Double(Buffer buffer, int n, int n2) {
        DoubleBuffer doubleBuffer;
        block6: {
            if (buffer == null) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n << 3);
                    byteBuffer.limit(n + n2 << 3);
                    doubleBuffer = byteBuffer.slice().order(byteBuffer.order()).asDoubleBuffer();
                    break block6;
                }
                if (buffer instanceof DoubleBuffer) {
                    DoubleBuffer doubleBuffer2 = (DoubleBuffer)buffer;
                    doubleBuffer2.position(n);
                    doubleBuffer2.limit(n + n2);
                    doubleBuffer = doubleBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor DoubleBuffer");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        doubleBuffer.mark();
        return doubleBuffer;
    }

    public static final DoubleBuffer slice2Double(double[] dArray, int n, int n2) {
        return (DoubleBuffer)DoubleBuffer.wrap(dArray, n, n2).mark();
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        byteBuffer2.rewind();
        byteBuffer.position(n);
        return byteBuffer2;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer floatBuffer) {
        return Buffers.copyFloatBufferAsByteBuffer(floatBuffer).asFloatBuffer();
    }

    public static IntBuffer copyIntBuffer(IntBuffer intBuffer) {
        return Buffers.copyIntBufferAsByteBuffer(intBuffer).asIntBuffer();
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer shortBuffer) {
        return Buffers.copyShortBufferAsByteBuffer(shortBuffer).asShortBuffer();
    }

    public static ByteBuffer copyFloatBufferAsByteBuffer(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(floatBuffer.remaining() << 2);
        byteBuffer.asFloatBuffer().put(floatBuffer);
        byteBuffer.rewind();
        floatBuffer.position(n);
        return byteBuffer;
    }

    public static ByteBuffer copyIntBufferAsByteBuffer(IntBuffer intBuffer) {
        int n = intBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(intBuffer.remaining() << 2);
        byteBuffer.asIntBuffer().put(intBuffer);
        byteBuffer.rewind();
        intBuffer.position(n);
        return byteBuffer;
    }

    public static ByteBuffer copyShortBufferAsByteBuffer(ShortBuffer shortBuffer) {
        int n = shortBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(shortBuffer.remaining() << 1);
        byteBuffer.asShortBuffer().put(shortBuffer);
        byteBuffer.rewind();
        shortBuffer.position(n);
        return byteBuffer;
    }

    public static float[] getFloatArray(double[] dArray, int n, float[] fArray, int n2, int n3) {
        if (n3 < 0) {
            n3 = dArray.length - n;
        }
        if (n3 > dArray.length - n) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining source bytes [len " + dArray.length + ", offset " + n + "]");
        }
        if (fArray == null) {
            fArray = new float[n3];
            n2 = 0;
        }
        if (n3 > fArray.length - n2) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining dest bytes [len " + fArray.length + ", offset " + n2 + "]");
        }
        for (int i = 0; i < n3; ++i) {
            fArray[n2 + i] = (float)dArray[n + i];
        }
        return fArray;
    }

    public static FloatBuffer getFloatBuffer(DoubleBuffer doubleBuffer, FloatBuffer floatBuffer) {
        if (floatBuffer == null) {
            floatBuffer = Buffers.newDirectFloatBuffer(doubleBuffer.remaining());
        }
        if (floatBuffer.remaining() < doubleBuffer.remaining()) {
            throw new IllegalArgumentException("payload (" + doubleBuffer.remaining() + ") is greater than remaining dest bytes: " + floatBuffer.remaining());
        }
        while (doubleBuffer.hasRemaining()) {
            floatBuffer.put((float)doubleBuffer.get());
        }
        return floatBuffer;
    }

    public static double[] getDoubleArray(float[] fArray, int n, double[] dArray, int n2, int n3) {
        if (n3 < 0) {
            n3 = fArray.length - n;
        }
        if (n3 > fArray.length - n) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining source bytes [len " + fArray.length + ", offset " + n + "]");
        }
        if (dArray == null) {
            dArray = new double[n3];
            n2 = 0;
        }
        if (n3 > dArray.length - n2) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining dest bytes [len " + dArray.length + ", offset " + n2 + "]");
        }
        for (int i = 0; i < n3; ++i) {
            dArray[n2 + i] = fArray[n + i];
        }
        return dArray;
    }

    public static DoubleBuffer getDoubleBuffer(FloatBuffer floatBuffer, DoubleBuffer doubleBuffer) {
        if (doubleBuffer == null) {
            doubleBuffer = Buffers.newDirectDoubleBuffer(floatBuffer.remaining());
        }
        if (doubleBuffer.remaining() < floatBuffer.remaining()) {
            throw new IllegalArgumentException("payload (" + floatBuffer.remaining() + ") is greater than remaining dest bytes: " + doubleBuffer.remaining());
        }
        while (floatBuffer.hasRemaining()) {
            doubleBuffer.put(floatBuffer.get());
        }
        return doubleBuffer;
    }

    public static <B extends Buffer> B put(B b, Buffer buffer) {
        if (b instanceof ByteBuffer && buffer instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put((ByteBuffer)buffer);
        }
        if (b instanceof ShortBuffer && buffer instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put((ShortBuffer)buffer);
        }
        if (b instanceof IntBuffer && buffer instanceof IntBuffer) {
            return (B)((IntBuffer)b).put((IntBuffer)buffer);
        }
        if (b instanceof FloatBuffer && buffer instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put((FloatBuffer)buffer);
        }
        if (b instanceof LongBuffer && buffer instanceof LongBuffer) {
            return (B)((LongBuffer)b).put((LongBuffer)buffer);
        }
        if (b instanceof DoubleBuffer && buffer instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put((DoubleBuffer)buffer);
        }
        if (b instanceof CharBuffer && buffer instanceof CharBuffer) {
            return (B)((CharBuffer)b).put((CharBuffer)buffer);
        }
        throw new IllegalArgumentException("Incompatible Buffer classes: dest = " + b.getClass().getName() + ", src = " + buffer.getClass().getName());
    }

    public static <B extends Buffer> B putb(B b, byte by) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(by);
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(by);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(by);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(by);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(by);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(by);
        }
        if (b instanceof CharBuffer) {
            return (B)((CharBuffer)b).put((char)by);
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put3b(B object, byte by, byte by2, byte by3) {
        if (object instanceof ByteBuffer) {
            object = (ByteBuffer)object;
            ((ByteBuffer)object).put(by);
            ((ByteBuffer)object).put(by2);
            ((ByteBuffer)object).put(by3);
            return (B)object;
        }
        if (object instanceof ShortBuffer) {
            object = (ShortBuffer)object;
            ((ShortBuffer)object).put(by);
            ((ShortBuffer)object).put(by2);
            ((ShortBuffer)object).put(by3);
            return (B)object;
        }
        if (object instanceof IntBuffer) {
            object = (IntBuffer)object;
            ((IntBuffer)object).put(by);
            ((IntBuffer)object).put(by2);
            ((IntBuffer)object).put(by3);
            return (B)object;
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            ((FloatBuffer)object).put(by);
            ((FloatBuffer)object).put(by2);
            ((FloatBuffer)object).put(by3);
            return (B)object;
        }
        if (object instanceof LongBuffer) {
            object = (LongBuffer)object;
            ((LongBuffer)object).put(by);
            ((LongBuffer)object).put(by2);
            ((LongBuffer)object).put(by3);
            return (B)object;
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            ((DoubleBuffer)object).put(by);
            ((DoubleBuffer)object).put(by2);
            ((DoubleBuffer)object).put(by3);
            return (B)object;
        }
        if (object instanceof CharBuffer) {
            object = (CharBuffer)object;
            ((CharBuffer)object).put((char)by);
            ((CharBuffer)object).put((char)by2);
            ((CharBuffer)object).put((char)by3);
            return (B)object;
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B put4b(B object, byte by, byte by2, byte by3, byte by4) {
        if (object instanceof ByteBuffer) {
            object = (ByteBuffer)object;
            ((ByteBuffer)object).put(by);
            ((ByteBuffer)object).put(by2);
            ((ByteBuffer)object).put(by3);
            ((ByteBuffer)object).put(by4);
            return (B)object;
        }
        if (object instanceof ShortBuffer) {
            object = (ShortBuffer)object;
            ((ShortBuffer)object).put(by);
            ((ShortBuffer)object).put(by2);
            ((ShortBuffer)object).put(by3);
            ((ShortBuffer)object).put(by4);
            return (B)object;
        }
        if (object instanceof IntBuffer) {
            object = (IntBuffer)object;
            ((IntBuffer)object).put(by);
            ((IntBuffer)object).put(by2);
            ((IntBuffer)object).put(by3);
            ((IntBuffer)object).put(by4);
            return (B)object;
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            ((FloatBuffer)object).put(by);
            ((FloatBuffer)object).put(by2);
            ((FloatBuffer)object).put(by3);
            ((FloatBuffer)object).put(by4);
            return (B)object;
        }
        if (object instanceof LongBuffer) {
            object = (LongBuffer)object;
            ((LongBuffer)object).put(by);
            ((LongBuffer)object).put(by2);
            ((LongBuffer)object).put(by3);
            ((LongBuffer)object).put(by4);
            return (B)object;
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            ((DoubleBuffer)object).put(by);
            ((DoubleBuffer)object).put(by2);
            ((DoubleBuffer)object).put(by3);
            ((DoubleBuffer)object).put(by4);
            return (B)object;
        }
        if (object instanceof CharBuffer) {
            object = (CharBuffer)object;
            ((CharBuffer)object).put((char)by);
            ((CharBuffer)object).put((char)by2);
            ((CharBuffer)object).put((char)by3);
            ((CharBuffer)object).put((char)by4);
            return (B)object;
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B putb(B object, byte[] byArray, int n, int n2) {
        if (object instanceof ByteBuffer) {
            return (B)((ByteBuffer)object).put(byArray, n, n2);
        }
        if (object instanceof ShortBuffer) {
            object = (ShortBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((ShortBuffer)object).put(byArray[n + i]);
            }
            return (B)object;
        }
        if (object instanceof IntBuffer) {
            object = (IntBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((IntBuffer)object).put(byArray[n + i]);
            }
            return (B)object;
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((FloatBuffer)object).put(byArray[n + i]);
            }
            return (B)object;
        }
        if (object instanceof LongBuffer) {
            object = (LongBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((LongBuffer)object).put(byArray[n + i]);
            }
            return (B)object;
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((DoubleBuffer)object).put(byArray[n + i]);
            }
            return (B)object;
        }
        if (object instanceof CharBuffer) {
            object = (CharBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((CharBuffer)object).put((char)byArray[n + i]);
            }
            return (B)object;
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B puts(B b, short s) {
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(s);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(s);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(s);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(s);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(s);
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put3s(B object, short s, short s2, short s3) {
        if (object instanceof ShortBuffer) {
            object = (ShortBuffer)object;
            ((ShortBuffer)object).put(s);
            ((ShortBuffer)object).put(s2);
            ((ShortBuffer)object).put(s3);
            return (B)object;
        }
        if (object instanceof IntBuffer) {
            object = (IntBuffer)object;
            ((IntBuffer)object).put(s);
            ((IntBuffer)object).put(s2);
            ((IntBuffer)object).put(s3);
            return (B)object;
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            ((FloatBuffer)object).put(s);
            ((FloatBuffer)object).put(s2);
            ((FloatBuffer)object).put(s3);
            return (B)object;
        }
        if (object instanceof LongBuffer) {
            object = (LongBuffer)object;
            ((LongBuffer)object).put(s);
            ((LongBuffer)object).put(s2);
            ((LongBuffer)object).put(s3);
            return (B)object;
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            ((DoubleBuffer)object).put(s);
            ((DoubleBuffer)object).put(s2);
            ((DoubleBuffer)object).put(s3);
            return (B)object;
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B put4s(B object, short s, short s2, short s3, short s4) {
        if (object instanceof ShortBuffer) {
            object = (ShortBuffer)object;
            ((ShortBuffer)object).put(s);
            ((ShortBuffer)object).put(s2);
            ((ShortBuffer)object).put(s3);
            ((ShortBuffer)object).put(s4);
            return (B)object;
        }
        if (object instanceof IntBuffer) {
            object = (IntBuffer)object;
            ((IntBuffer)object).put(s);
            ((IntBuffer)object).put(s2);
            ((IntBuffer)object).put(s3);
            ((IntBuffer)object).put(s4);
            return (B)object;
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            ((FloatBuffer)object).put(s);
            ((FloatBuffer)object).put(s2);
            ((FloatBuffer)object).put(s3);
            ((FloatBuffer)object).put(s4);
            return (B)object;
        }
        if (object instanceof LongBuffer) {
            object = (LongBuffer)object;
            ((LongBuffer)object).put(s);
            ((LongBuffer)object).put(s2);
            ((LongBuffer)object).put(s3);
            ((LongBuffer)object).put(s4);
            return (B)object;
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            ((DoubleBuffer)object).put(s);
            ((DoubleBuffer)object).put(s2);
            ((DoubleBuffer)object).put(s3);
            ((DoubleBuffer)object).put(s4);
            return (B)object;
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B puts(B object, short[] sArray, int n, int n2) {
        if (object instanceof ShortBuffer) {
            return (B)((ShortBuffer)object).put(sArray, n, n2);
        }
        if (object instanceof IntBuffer) {
            object = (IntBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((IntBuffer)object).put(sArray[n + i]);
            }
            return (B)object;
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((FloatBuffer)object).put(sArray[n + i]);
            }
            return (B)object;
        }
        if (object instanceof LongBuffer) {
            object = (LongBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((LongBuffer)object).put(sArray[n + i]);
            }
            return (B)object;
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((DoubleBuffer)object).put(sArray[n + i]);
            }
            return (B)object;
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B puti(B b, int n) {
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(n);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(n);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(n);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(n);
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put3i(B object, int n, int n2, int n3) {
        if (object instanceof IntBuffer) {
            object = (IntBuffer)object;
            ((IntBuffer)object).put(n);
            ((IntBuffer)object).put(n2);
            ((IntBuffer)object).put(n3);
            return (B)object;
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            ((FloatBuffer)object).put(n);
            ((FloatBuffer)object).put(n2);
            ((FloatBuffer)object).put(n3);
            return (B)object;
        }
        if (object instanceof LongBuffer) {
            object = (LongBuffer)object;
            ((LongBuffer)object).put(n);
            ((LongBuffer)object).put(n2);
            ((LongBuffer)object).put(n3);
            return (B)object;
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            ((DoubleBuffer)object).put(n);
            ((DoubleBuffer)object).put(n2);
            ((DoubleBuffer)object).put(n3);
            return (B)object;
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B put4i(B object, int n, int n2, int n3, int n4) {
        if (object instanceof IntBuffer) {
            object = (IntBuffer)object;
            ((IntBuffer)object).put(n);
            ((IntBuffer)object).put(n2);
            ((IntBuffer)object).put(n3);
            ((IntBuffer)object).put(n4);
            return (B)object;
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            ((FloatBuffer)object).put(n);
            ((FloatBuffer)object).put(n2);
            ((FloatBuffer)object).put(n3);
            ((FloatBuffer)object).put(n4);
            return (B)object;
        }
        if (object instanceof LongBuffer) {
            object = (LongBuffer)object;
            ((LongBuffer)object).put(n);
            ((LongBuffer)object).put(n2);
            ((LongBuffer)object).put(n3);
            ((LongBuffer)object).put(n4);
            return (B)object;
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            ((DoubleBuffer)object).put(n);
            ((DoubleBuffer)object).put(n2);
            ((DoubleBuffer)object).put(n3);
            ((DoubleBuffer)object).put(n4);
            return (B)object;
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B puti(B object, int[] nArray, int n, int n2) {
        if (object instanceof IntBuffer) {
            return (B)((IntBuffer)object).put(nArray, n, n2);
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((FloatBuffer)object).put(nArray[n + i]);
            }
            return (B)object;
        }
        if (object instanceof LongBuffer) {
            object = (LongBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((LongBuffer)object).put(nArray[n + i]);
            }
            return (B)object;
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((DoubleBuffer)object).put(nArray[n + i]);
            }
            return (B)object;
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B putf(B b, float f) {
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(f);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(f);
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put3f(B object, float f, float f2, float f3) {
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            ((FloatBuffer)object).put(f);
            ((FloatBuffer)object).put(f2);
            ((FloatBuffer)object).put(f3);
            return (B)object;
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            ((DoubleBuffer)object).put(f);
            ((DoubleBuffer)object).put(f2);
            ((DoubleBuffer)object).put(f3);
            return (B)object;
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B put4f(B object, float f, float f2, float f3, float f4) {
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            ((FloatBuffer)object).put(f);
            ((FloatBuffer)object).put(f2);
            ((FloatBuffer)object).put(f3);
            ((FloatBuffer)object).put(f4);
            return (B)object;
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            ((DoubleBuffer)object).put(f);
            ((DoubleBuffer)object).put(f2);
            ((DoubleBuffer)object).put(f3);
            ((DoubleBuffer)object).put(f4);
            return (B)object;
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B putf(B object, float[] fArray, int n, int n2) {
        if (object instanceof FloatBuffer) {
            return (B)((FloatBuffer)object).put(fArray, n, n2);
        }
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((DoubleBuffer)object).put(fArray[n + i]);
            }
            return (B)object;
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B putd(B b, double d) {
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(d);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put((float)d);
        }
        throw new IllegalArgumentException("Double doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put3d(B object, double d, double d2, double d3) {
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            ((DoubleBuffer)object).put(d);
            ((DoubleBuffer)object).put(d2);
            ((DoubleBuffer)object).put(d3);
            return (B)object;
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            ((FloatBuffer)object).put((float)d);
            ((FloatBuffer)object).put((float)d2);
            ((FloatBuffer)object).put((float)d3);
            return (B)object;
        }
        throw new IllegalArgumentException("Double doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B put4d(B object, double d, double d2, double d3, double d4) {
        if (object instanceof DoubleBuffer) {
            object = (DoubleBuffer)object;
            ((DoubleBuffer)object).put(d);
            ((DoubleBuffer)object).put(d2);
            ((DoubleBuffer)object).put(d3);
            ((DoubleBuffer)object).put(d4);
            return (B)object;
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            ((FloatBuffer)object).put((float)d);
            ((FloatBuffer)object).put((float)d2);
            ((FloatBuffer)object).put((float)d3);
            ((FloatBuffer)object).put((float)d4);
            return (B)object;
        }
        throw new IllegalArgumentException("Double doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B putd(B object, double[] dArray, int n, int n2) {
        if (object instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)object).put(dArray, n, n2);
        }
        if (object instanceof FloatBuffer) {
            object = (FloatBuffer)object;
            for (int i = 0; i < n2; ++i) {
                ((FloatBuffer)object).put((float)dArray[n + i]);
            }
            return (B)object;
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + object);
    }

    public static <B extends Buffer> B putNb(B b, boolean bl, byte by, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(by);
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.byte_to_short(by, bl2, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.byte_to_int(by, bl2, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.byte_to_float(by, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putNs(B b, boolean bl, short s, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.short_to_byte(s, bl2, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(s);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.short_to_int(s, bl2, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.short_to_float(s, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putNi(B b, boolean bl, int n, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.int_to_byte(n, bl2, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.int_to_short(n, bl2, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(n);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.int_to_float(n, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putNf(B b, boolean bl, float f) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.float_to_byte(f, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.float_to_short(f, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.float_to_int(f, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(f);
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static void rangeCheck(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return;
        }
        if (byArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (byArray.length - n));
        }
    }

    public static void rangeCheck(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return;
        }
        if (cArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (cArray.length - n));
        }
    }

    public static void rangeCheck(short[] sArray, int n, int n2) {
        if (sArray == null) {
            return;
        }
        if (sArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (sArray.length - n));
        }
    }

    public static void rangeCheck(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return;
        }
        if (nArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (nArray.length - n));
        }
    }

    public static void rangeCheck(long[] lArray, int n, int n2) {
        if (lArray == null) {
            return;
        }
        if (lArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (lArray.length - n));
        }
    }

    public static void rangeCheck(float[] fArray, int n, int n2) {
        if (fArray == null) {
            return;
        }
        if (fArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (fArray.length - n));
        }
    }

    public static void rangeCheck(double[] dArray, int n, int n2) {
        if (dArray == null) {
            return;
        }
        if (dArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (dArray.length - n));
        }
    }

    public static void rangeCheck(Buffer buffer, int n) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining elements in buffer, only had " + buffer.remaining());
        }
    }

    public static void rangeCheckBytes(Object object, int n) {
        if (object == null) {
            return;
        }
        int n2 = Buffers.remainingBytes(object);
        if (n2 < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining bytes in buffer, only had " + n2);
        }
    }

    public static StringBuilder toString(StringBuilder stringBuilder, String string, Buffer buffer) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(buffer.getClass().getSimpleName());
        stringBuilder.append("[pos ").append(buffer.position()).append(", lim ").append(buffer.limit()).append(", cap ").append(buffer.capacity());
        stringBuilder.append(", remaining ").append(buffer.remaining());
        stringBuilder.append("; array ").append(buffer.hasArray()).append(", direct ").append(buffer.isDirect());
        stringBuilder.append(", r/w ").append(!buffer.isReadOnly()).append(": ");
        if (buffer instanceof ByteBuffer) {
            buffer = (ByteBuffer)buffer;
            for (int i = 0; i < buffer.limit(); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (string == null) {
                    stringBuilder.append(((ByteBuffer)buffer).get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, ((ByteBuffer)buffer).get(i)));
            }
        } else if (buffer instanceof FloatBuffer) {
            buffer = (FloatBuffer)buffer;
            for (int i = 0; i < buffer.limit(); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (string == null) {
                    stringBuilder.append(((FloatBuffer)buffer).get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, Float.valueOf(((FloatBuffer)buffer).get(i))));
            }
        } else if (buffer instanceof IntBuffer) {
            buffer = (IntBuffer)buffer;
            for (int i = 0; i < buffer.limit(); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (string == null) {
                    stringBuilder.append(((IntBuffer)buffer).get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, ((IntBuffer)buffer).get(i)));
            }
        } else if (buffer instanceof ShortBuffer) {
            buffer = (ShortBuffer)buffer;
            for (int i = 0; i < buffer.limit(); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (string == null) {
                    stringBuilder.append(((ShortBuffer)buffer).get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, ((ShortBuffer)buffer).get(i)));
            }
        } else if (buffer instanceof DoubleBuffer) {
            buffer = (DoubleBuffer)buffer;
            for (int i = 0; i < buffer.limit(); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (string == null) {
                    stringBuilder.append(((DoubleBuffer)buffer).get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, ((DoubleBuffer)buffer).get(i)));
            }
        } else if (buffer instanceof LongBuffer) {
            buffer = (LongBuffer)buffer;
            for (int i = 0; i < buffer.limit(); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (string == null) {
                    stringBuilder.append(((LongBuffer)buffer).get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, ((LongBuffer)buffer).get(i)));
            }
        } else if (buffer instanceof CharBuffer) {
            buffer = (CharBuffer)buffer;
            for (int i = 0; i < buffer.limit(); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (string == null) {
                    stringBuilder.append(((CharBuffer)buffer).get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, Character.valueOf(((CharBuffer)buffer).get(i))));
            }
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public static ByteBuffer copyNativeToDirectByteBuffer(long l, long l2) {
        if (Integer.MAX_VALUE < l2) {
            throw new IllegalArgumentException("length " + l2 + " > MAX_INT");
        }
        int n = (int)l2;
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(n);
        if (byteBuffer == null) {
            throw new RuntimeException("New direct ByteBuffer is NULL");
        }
        if (n > 0) {
            long l3 = Buffers.getDirectBufferAddressImpl(byteBuffer);
            Buffers.memcpyImpl(l3, l, n);
        }
        return byteBuffer;
    }

    static ByteBuffer getDirectByteBuffer(long l, int n) {
        ByteBuffer byteBuffer = Buffers.getDirectByteBufferImpl(l, n);
        if (byteBuffer != null) {
            return Buffers.nativeOrder(byteBuffer);
        }
        return null;
    }

    static void storeDirectAddress(long l, ByteBuffer byteBuffer, int n, int n2) {
        switch (n2) {
            case 4: {
                byteBuffer.putInt(n, (int)l);
                return;
            }
            case 8: {
                byteBuffer.putLong(n, l);
                return;
            }
        }
        throw new InternalError("invalid nativeSizeInBytes " + n2);
    }

    public static int strnlen(long l, int n) {
        return Buffers.strnlenImpl(l, n);
    }

    static native long getDirectBufferAddressImpl(Object var0);

    private static native ByteBuffer getDirectByteBufferImpl(long var0, int var2);

    private static native int strnlenImpl(long var0, int var2);

    private static native long memcpyImpl(long var0, long var2, long var4);

    public static class Cleaner {
        private static final Method mbbCleaner;
        private static final Method cClean;
        private static volatile boolean cleanerError;

        public static boolean clean(ByteBuffer byteBuffer) {
            if (cleanerError || !byteBuffer.isDirect()) {
                return false;
            }
            try {
                if (PlatformPropsImpl.JAVA_9) {
                    UnsafeUtil.invokeCleaner(byteBuffer);
                } else {
                    cClean.invoke(mbbCleaner.invoke((Object)byteBuffer, new Object[0]), new Object[0]);
                }
                return true;
            }
            catch (Throwable throwable) {
                cleanerError = true;
                if (DEBUG) {
                    ExceptionUtils.dumpThrowable("Buffers", throwable);
                }
                return false;
            }
        }

        static {
            boolean bl;
            final Method[] methodArray = new Method[]{null};
            final Method[] methodArray2 = new Method[]{null};
            if (SecurityUtil.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        if (PlatformPropsImpl.JAVA_9) {
                            return UnsafeUtil.hasInvokeCleaner();
                        }
                        methodArray[0] = ReflectionUtil.getMethod("sun.nio.ch.DirectBuffer", "cleaner", null, Buffers.class.getClassLoader());
                        methodArray[0].setAccessible(true);
                        Class<?> clazz = methodArray[0].getReturnType();
                        methodArray2[0] = clazz.getMethod("clean", new Class[0]);
                        methodArray2[0].setAccessible(true);
                        return Boolean.TRUE;
                    }
                    catch (Throwable throwable) {
                        if (DEBUG) {
                            ExceptionUtils.dumpThrowable("Buffers", throwable);
                        }
                        return Boolean.FALSE;
                    }
                }
            }).booleanValue()) {
                mbbCleaner = methodArray[0];
                cClean = methodArray2[0];
                bl = PlatformPropsImpl.JAVA_9 || mbbCleaner != null && cClean != null;
            } else {
                mbbCleaner = null;
                cClean = null;
                bl = false;
            }
            boolean bl2 = cleanerError = !bl;
            if (DEBUG) {
                System.err.print("Buffers.Cleaner.init: hasCleaner: " + bl + ", cleanerError " + cleanerError);
                if (mbbCleaner != null) {
                    System.err.print(", using Cleaner class: " + mbbCleaner.getReturnType().getName());
                }
                System.err.println();
            }
        }
    }
}

