/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.Function;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.TaskBase;
import java.io.PrintStream;

public class FunctionTask<R, A>
extends TaskBase
implements Function<R, A> {
    protected Function<R, A> runnable;
    protected R result;
    protected A[] args;

    public static <U, V> FunctionTask<U, V> invokeOnCurrentThread(Function<U, V> function, V ... VArray) {
        function = new FunctionTask<U, V>(function, null, false, null);
        v0.args = VArray;
        ((TaskBase)((Object)function)).run();
        return function;
    }

    public static <U, V> FunctionTask<U, V> invokeOnNewThread(ThreadGroup object, String object2, boolean bl, Function<U, V> function, V ... VArray) {
        FunctionTask<U, V> functionTask;
        if (!bl) {
            functionTask = new FunctionTask<U, V>(function, null, true, System.err);
            InterruptSource.Thread thread = InterruptSource.Thread.create((ThreadGroup)object, functionTask, (String)object2);
            functionTask.args = VArray;
            thread.start();
        } else {
            Object object3 = new Object();
            functionTask = new FunctionTask<U, V>(function, object3, true, null);
            object = InterruptSource.Thread.create((ThreadGroup)object, functionTask, (String)object2);
            object2 = object3;
            synchronized (object2) {
                functionTask.args = VArray;
                ((Thread)object).start();
                while (functionTask.isInQueue()) {
                    try {
                        object3.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedRuntimeException(interruptedException);
                    }
                    object = functionTask.getThrowable();
                    if (object == null) continue;
                    throw new JogampRuntimeException((Throwable)object);
                }
            }
        }
        return functionTask;
    }

    public FunctionTask(Function<R, A> function, Object object, boolean bl, PrintStream printStream) {
        super(object, bl, printStream);
        this.runnable = function;
        this.result = null;
        this.args = null;
    }

    public final Function<R, A> getRunnable() {
        return this.runnable;
    }

    public final void setArgs(A ... AArray) {
        this.args = AArray;
    }

    public final R getResult() {
        R r = this.result;
        this.result = null;
        return r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void run() {
        this.execThread = Thread.currentThread();
        A[] AArray = this.args;
        this.args = null;
        this.result = null;
        this.runnableException = null;
        this.tStarted = System.currentTimeMillis();
        if (null == this.syncObject) {
            try {
                this.result = this.runnable.eval(AArray);
                return;
            }
            catch (Throwable throwable) {
                this.runnableException = throwable;
                if (null != this.exceptionOut) {
                    this.exceptionOut.println("FunctionTask.run(): " + this.getExceptionOutIntro() + " exception occured on thread " + Thread.currentThread().getName() + ": " + this.toString());
                    this.printSourceTrace();
                    throwable.printStackTrace(this.exceptionOut);
                }
                if (this.catchExceptions) return;
                throw new RuntimeException(this.runnableException);
            }
            finally {
                this.tExecuted = System.currentTimeMillis();
                this.isExecuted = true;
            }
        }
        Object object = this.syncObject;
        synchronized (object) {
            try {
                this.result = this.runnable.eval(AArray);
            }
            catch (Throwable throwable) {
                this.runnableException = throwable;
                if (null != this.exceptionOut) {
                    this.exceptionOut.println("FunctionTask.run(): " + this.getExceptionOutIntro() + " exception occured on thread " + Thread.currentThread().getName() + ": " + this.toString());
                    this.printSourceTrace();
                    throwable.printStackTrace(this.exceptionOut);
                }
                if (this.catchExceptions) return;
                throw new RuntimeException(this.runnableException);
            }
            finally {
                this.tExecuted = System.currentTimeMillis();
                this.isExecuted = true;
                this.syncObject.notifyAll();
            }
            return;
        }
    }

    @Override
    public final R eval(A ... object) {
        this.args = object;
        ((TaskBase)this).run();
        object = this.result;
        this.result = null;
        return (R)object;
    }
}

