/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jogamp.common.os.PlatformPropsImpl;

public class VersionUtil {
    public static final String SEPERATOR = "-----------------------------------------------------------------------------------------------------";

    public static StringBuilder getPlatformInfo(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(SEPERATOR).append(Platform.getNewline());
        stringBuilder.append("Platform: ").append((Object)Platform.getOSType()).append(" / ").append(Platform.getOSName()).append(' ').append(Platform.getOSVersion()).append(" (").append(Platform.getOSVersionNumber()).append("), ");
        stringBuilder.append(Platform.getArchName()).append(" (").append((Object)Platform.getCPUType()).append(", ").append((Object)Platform.getABIType()).append("), ");
        stringBuilder.append(Runtime.getRuntime().availableProcessors()).append(" cores, littleEndian ").append(PlatformPropsImpl.LITTLE_ENDIAN);
        stringBuilder.append(Platform.getNewline());
        if (Platform.OSType.ANDROID == PlatformPropsImpl.OS_TYPE) {
            stringBuilder.append("Platform: Android Version: ").append(AndroidVersion.CODENAME).append(", ");
            stringBuilder.append(AndroidVersion.RELEASE).append(" [").append(AndroidVersion.RELEASE).append("], SDK: ").append(AndroidVersion.SDK_INT).append(", ").append(AndroidVersion.SDK_NAME);
            stringBuilder.append(Platform.getNewline());
        }
        Platform.getMachineDataInfo().toString(stringBuilder).append(Platform.getNewline());
        stringBuilder.append("Platform: Java Version: ").append(Platform.getJavaVersion()).append(" (").append(Platform.getJavaVersionNumber()).append("u").append(PlatformPropsImpl.JAVA_VERSION_UPDATE).append("), VM: ").append(Platform.getJavaVMName());
        stringBuilder.append(", Runtime: ").append(Platform.getJavaRuntimeName()).append(Platform.getNewline());
        stringBuilder.append("Platform: Java Vendor: ").append(Platform.getJavaVendor()).append(", ").append(Platform.getJavaVendorURL());
        if (PlatformPropsImpl.JAVA_21) {
            stringBuilder.append(", Java21");
        } else if (PlatformPropsImpl.JAVA_17) {
            stringBuilder.append(", Java17");
        } else if (PlatformPropsImpl.JAVA_9) {
            stringBuilder.append(", Java9");
        } else if (PlatformPropsImpl.JAVA_6) {
            stringBuilder.append(", Java6");
        } else if (PlatformPropsImpl.JAVA_SE) {
            stringBuilder.append(", JavaSE");
        }
        stringBuilder.append(", dynamicLib: ").append(PlatformPropsImpl.useDynamicLibraries);
        stringBuilder.append(", AWT enabled: ").append(Platform.AWT_AVAILABLE);
        stringBuilder.append(Platform.getNewline()).append(SEPERATOR);
        return stringBuilder;
    }

    public static String getPlatformInfo() {
        return VersionUtil.getPlatformInfo(null).toString();
    }

    public static Manifest getManifest(ClassLoader classLoader, String string) {
        return VersionUtil.getManifest(classLoader, new String[]{string});
    }

    public static Manifest getManifest(ClassLoader object, String[] stringArray) {
        Manifest[] manifestArray = new Manifest[stringArray.length];
        try {
            object = ((ClassLoader)object).getResources("META-INF/MANIFEST.MF");
            while (object.hasMoreElements()) {
                Manifest manifest;
                InputStream inputStream = ((URL)object.nextElement()).openStream();
                try {
                    manifest = new Manifest(inputStream);
                }
                finally {
                    IOUtil.close(inputStream, false);
                }
                Attributes attributes = manifest.getMainAttributes();
                if (attributes == null) continue;
                for (int i = 0; i < stringArray.length && null == manifestArray[i]; ++i) {
                    String string = stringArray[i];
                    if (!string.equals(attributes.getValue(Attributes.Name.EXTENSION_NAME))) continue;
                    if (i == 0) {
                        return manifest;
                    }
                    manifestArray[i] = manifest;
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to read manifest.", iOException);
        }
        for (int i = 1; i < manifestArray.length; ++i) {
            if (null == manifestArray[i]) continue;
            return manifestArray[i];
        }
        return null;
    }

    public static StringBuilder getFullManifestInfo(Manifest cloneable, StringBuilder stringBuilder) {
        if (cloneable == null) {
            return stringBuilder;
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        cloneable = ((Manifest)cloneable).getMainAttributes();
        Object object = ((Attributes)cloneable).keySet();
        object = object.iterator();
        while (object.hasNext()) {
            Attributes.Name name = (Attributes.Name)object.next();
            String string = ((Attributes)cloneable).getValue(name);
            stringBuilder.append(" ");
            stringBuilder.append(name);
            stringBuilder.append(" = ");
            stringBuilder.append(string);
            stringBuilder.append(Platform.getNewline());
        }
        return stringBuilder;
    }
}

