/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.os.Platform;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import jogamp.common.os.elf.Ehdr_p2;
import jogamp.common.os.elf.ElfHeaderPart1;
import jogamp.common.os.elf.IOUtils;
import jogamp.common.os.elf.Section;
import jogamp.common.os.elf.SectionArmAttributes;
import jogamp.common.os.elf.SectionHeader;

public class ElfHeaderPart2 {
    public static final int EF_ARM_ABIMASK = -16777216;
    public static final int EF_ARM_ABISHIFT = 24;
    public static final int EF_ARM_ABI5 = 0x5000000;
    public static final int EF_ARM_BE8 = 0x800000;
    public static final int EF_ARM_GCCMASK = 0x400FFF;
    public static final int EF_ARM_ABI_FLOAT_HARD = 1024;
    public static final int EF_ARM_ABI_FLOAT_SOFT = 512;
    public final ElfHeaderPart1 eh1;
    public final Ehdr_p2 raw;
    public final String cpuName;
    public final Platform.CPUType cpuType;
    public final Platform.ABIType abiType;
    public final SectionHeader[] sht;

    public static ElfHeaderPart2 read(ElfHeaderPart1 elfHeaderPart1, RandomAccessFile randomAccessFile) {
        return new ElfHeaderPart2(elfHeaderPart1, randomAccessFile);
    }

    ElfHeaderPart2(ElfHeaderPart1 elfHeaderPart1, RandomAccessFile object) {
        this.eh1 = elfHeaderPart1;
        Object object2 = new byte[Ehdr_p2.size(elfHeaderPart1.machDesc.ordinal())];
        IOUtils.readBytes((RandomAccessFile)object, object2, 0, ((byte[])object2).length);
        Object object3 = ByteBuffer.wrap(object2, 0, ((byte[])object2).length);
        this.raw = Ehdr_p2.create(elfHeaderPart1.machDesc.ordinal(), (ByteBuffer)object3);
        this.sht = this.readSectionHeaderTable((RandomAccessFile)object);
        if (Platform.CPUFamily.ARM == elfHeaderPart1.cpuType.family && elfHeaderPart1.cpuType.is32Bit) {
            object2 = null;
            object3 = null;
            boolean bl = false;
            Object object4 = this.getSectionHeader(0x70000003);
            if (ElfHeaderPart1.DEBUG) {
                System.err.println("ELF-2: Got ARM Attribs Section Header: " + object4);
            }
            if (object4 != null) {
                object = (SectionArmAttributes)object4.readSection((RandomAccessFile)object);
                if (ElfHeaderPart1.DEBUG) {
                    System.err.println("ELF-2: Got ARM Attribs Section Block : " + object);
                }
                if ((object4 = ((SectionArmAttributes)object).get(SectionArmAttributes.Tag.CPU_name)) != null && ((SectionArmAttributes.Attribute)object4).isNTBS()) {
                    object2 = ((SectionArmAttributes.Attribute)object4).getNTBS();
                }
                if ((object4 = ((SectionArmAttributes)object).get(SectionArmAttributes.Tag.CPU_raw_name)) != null && ((SectionArmAttributes.Attribute)object4).isNTBS()) {
                    object3 = ((SectionArmAttributes.Attribute)object4).getNTBS();
                }
                if ((object = ((SectionArmAttributes)object).get(SectionArmAttributes.Tag.ABI_VFP_args)) != null) {
                    bl = SectionArmAttributes.abiVFPArgsAcceptsVFPVariant(((SectionArmAttributes.Attribute)object).getULEB128());
                }
            }
            object = object2 != null && object2.length() > 0 ? object2.toLowerCase().replace(' ', '-') : (object3 != null && ((String)object3).length() > 0 ? ((String)object3).toLowerCase().replace(' ', '-') : elfHeaderPart1.cpuName);
            object4 = ElfHeaderPart2.queryCPUTypeSafe((String)object);
            if (object4 == null && (object4 = ElfHeaderPart2.queryCPUTypeSafe((String)(object = "arm-" + (String)object))) == null && (object4 = ElfHeaderPart2.queryCPUTypeSafe((String)(object = elfHeaderPart1.cpuName))) == null) {
                throw new InternalError("XXX: " + (String)object + ", " + elfHeaderPart1);
            }
            this.cpuName = object;
            this.cpuType = object4;
            if (ElfHeaderPart1.DEBUG) {
                System.err.println("ELF-2: abiARM cpuName " + (String)object + "[armCpuName " + (String)object2 + ", armCpuRawName " + (String)object3 + "] -> " + this.cpuName + " -> " + (Object)((Object)this.cpuType) + ", abiVFPArgsAcceptsVFPVariant " + bl);
            }
            this.abiType = this.cpuType.is32Bit ? (bl ? Platform.ABIType.EABI_GNU_ARMHF : Platform.ABIType.EABI_GNU_ARMEL) : elfHeaderPart1.abiType;
        } else {
            this.cpuName = elfHeaderPart1.cpuName;
            this.cpuType = elfHeaderPart1.cpuType;
            this.abiType = elfHeaderPart1.abiType;
        }
        if (ElfHeaderPart1.DEBUG) {
            System.err.println("ELF-2: cpuName " + this.cpuName + " -> " + (Object)((Object)this.cpuType) + ", " + (Object)((Object)this.abiType));
        }
    }

    private static Platform.CPUType queryCPUTypeSafe(String string) {
        Platform.CPUType cPUType;
        block2: {
            cPUType = null;
            try {
                cPUType = Platform.CPUType.query(string);
            }
            catch (Throwable throwable) {
                if (!ElfHeaderPart1.DEBUG) break block2;
                System.err.println("ELF-2: queryCPUTypeSafe(" + string + "): " + throwable.getMessage());
            }
        }
        return cPUType;
    }

    public final short getSize() {
        return this.raw.getE_ehsize();
    }

    public final int getFlags() {
        return this.raw.getE_flags();
    }

    public byte getArmABI() {
        return (byte)((0xFF000000 & this.raw.getE_flags()) >>> 24);
    }

    public int getArmLegacyGCCFlags() {
        int n = this.raw.getE_flags();
        if (0 != (0xFF000000 & n)) {
            return 0x400FFF & n;
        }
        return 0;
    }

    public byte getArmFloatMode() {
        int n = this.raw.getE_flags();
        if (0 != (0xFF000000 & n)) {
            if ((0x400 & n) != 0) {
                return 2;
            }
            if ((0x200 & n) != 0) {
                return 1;
            }
        }
        return 0;
    }

    public final SectionHeader getSectionHeader(int n) {
        for (int i = 0; i < this.sht.length; ++i) {
            SectionHeader sectionHeader = this.sht[i];
            if (sectionHeader.getType() != n) continue;
            return sectionHeader;
        }
        return null;
    }

    public final SectionHeader getSectionHeader(String string) {
        for (int i = 0; i < this.sht.length; ++i) {
            SectionHeader sectionHeader = this.sht[i];
            if (!sectionHeader.getName().equals(string)) continue;
            return sectionHeader;
        }
        return null;
    }

    public final String toString() {
        byte by = this.getArmABI();
        String string = by != 0 ? ", arm[abi " + by + ", lGCC " + this.getArmLegacyGCCFlags() + ", float " + this.getArmFloatMode() + "]" : "";
        return "ELF-2[" + (Object)((Object)this.cpuType) + ", " + (Object)((Object)this.abiType) + ", flags[" + IOUtils.toHexString(this.getFlags()) + string + "], sh-num " + this.sht.length + "]";
    }

    final SectionHeader[] readSectionHeaderTable(RandomAccessFile randomAccessFile) {
        int n;
        SectionHeader[] sectionHeaderArray;
        int n2;
        Object object;
        long l = this.raw.getE_shoff();
        if (0L == l) {
            return new SectionHeader[0];
        }
        IOUtils.seek(randomAccessFile, l);
        short s = this.raw.getE_shstrndx();
        short s2 = this.raw.getE_shentsize();
        if (0 == this.raw.getE_shnum()) {
            object = new byte[s2];
            IOUtils.readBytes(randomAccessFile, (byte[])object, 0, s2);
            SectionHeader sectionHeader = new SectionHeader(this, (byte[])object, 0, s2, 0);
            object = sectionHeader;
            n2 = (int)sectionHeader.raw.getSh_size();
            if (n2 <= 0) {
                throw new IllegalArgumentException("EHdr sh_num == 0 and 1st SHdr size == 0");
            }
            SectionHeader[] sectionHeaderArray2 = new SectionHeader[n2];
            sectionHeaderArray = sectionHeaderArray2;
            sectionHeaderArray2[0] = object;
            n = 1;
        } else {
            n2 = this.raw.getE_shnum();
            sectionHeaderArray = new SectionHeader[n2];
            n = 0;
        }
        while (n < n2) {
            object = new byte[s2];
            IOUtils.readBytes(randomAccessFile, (byte[])object, 0, s2);
            sectionHeaderArray[n] = new SectionHeader(this, (byte[])object, 0, s2, n);
            ++n;
        }
        if (s != 0) {
            if (IOUtils.shortToInt((short)-256) <= s) {
                throw new InternalError("TODO strndx: -256 < " + s);
            }
            object = sectionHeaderArray[s];
            if (3 != ((SectionHeader)object).getType()) {
                throw new IllegalArgumentException("Ref. string Shdr[" + s + "] is of type " + ((SectionHeader)object).raw.getSh_type());
            }
            object = ((SectionHeader)object).readSection(randomAccessFile);
            for (n = 0; n < n2; ++n) {
                sectionHeaderArray[n].initName((Section)object, sectionHeaderArray[n].raw.getSh_name());
            }
        }
        return sectionHeaderArray;
    }
}

