/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.locks.SingletonInstance;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public class SingletonInstanceFileLock
extends SingletonInstance {
    static final String temp_file_path;
    private final File file;
    private RandomAccessFile randomAccessFile = null;
    private FileLock fileLock = null;

    public static String getCanonicalTempPath() {
        return temp_file_path;
    }

    public static String getCanonicalTempLockFilePath(String string) {
        return SingletonInstanceFileLock.getCanonicalTempPath() + File.separator + string;
    }

    public SingletonInstanceFileLock(long l, String string) {
        super(l);
        this.file = new File(SingletonInstanceFileLock.getCanonicalTempLockFilePath(string));
        this.setupFileCleanup();
    }

    public SingletonInstanceFileLock(long l, File file) {
        super(l);
        this.file = file;
        this.setupFileCleanup();
    }

    @Override
    public final String getName() {
        return this.file.getPath();
    }

    private void setupFileCleanup() {
        this.file.deleteOnExit();
        Runtime.getRuntime().addShutdownHook(new InterruptSource.Thread(){

            @Override
            public void run() {
                if (SingletonInstanceFileLock.this.isLocked()) {
                    System.err.println(SingletonInstanceFileLock.this.infoPrefix() + " XXX " + ((SingletonInstance)SingletonInstanceFileLock.this).getName() + " - Unlock @ JVM Shutdown");
                }
                SingletonInstanceFileLock.this.unlock();
            }
        });
    }

    @Override
    protected boolean tryLockImpl() {
        try {
            this.randomAccessFile = new RandomAccessFile(this.file, "rw");
            this.fileLock = this.randomAccessFile.getChannel().tryLock();
            if (this.fileLock != null) {
                return true;
            }
        }
        catch (Exception exception) {
            System.err.println(this.infoPrefix() + " III " + ((SingletonInstance)this).getName() + " - Unable to create and/or lock file");
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    protected boolean unlockImpl() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
                this.fileLock = null;
            }
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
                this.randomAccessFile = null;
            }
            if (this.file != null) {
                this.file.delete();
            }
            return true;
        }
        catch (Exception exception) {
            System.err.println(this.infoPrefix() + " EEE " + ((SingletonInstance)this).getName() + " - Unable to remove lock file");
            exception.printStackTrace();
        }
        finally {
            this.fileLock = null;
            this.randomAccessFile = null;
        }
        return false;
    }

    static {
        String string = null;
        try {
            File file = File.createTempFile("TEST", "tst");
            String string2 = file.getCanonicalPath();
            file.delete();
            string = string2.substring(0, string2.lastIndexOf(File.separator));
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        temp_file_path = string;
    }
}

