/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lio/ktor/network/sockets/SocketOptionsPlatformCapabilities;", "", "<init>", "()V", "Ljava/nio/channels/SocketChannel;", "channel", "", "setReusePort", "(Ljava/nio/channels/SocketChannel;)V", "Ljava/nio/channels/ServerSocketChannel;", "(Ljava/nio/channels/ServerSocketChannel;)V", "Ljava/nio/channels/DatagramChannel;", "(Ljava/nio/channels/DatagramChannel;)V", "", "name", "socketOption", "(Ljava/lang/String;)Ljava/lang/Object;", "", "Ljava/lang/reflect/Field;", "standardSocketOptions", "Ljava/util/Map;", "Ljava/lang/reflect/Method;", "channelSetOption", "Ljava/lang/reflect/Method;", "serverChannelSetOption", "datagramSetOption", "ktor-network"})
public final class SocketOptionsPlatformCapabilities {
    public static final SocketOptionsPlatformCapabilities INSTANCE;
    private static final Map<String, Field> standardSocketOptions;
    private static final Method channelSetOption;
    private static final Method serverChannelSetOption;
    private static final Method datagramSetOption;

    private SocketOptionsPlatformCapabilities() {
    }

    public final void setReusePort(SocketChannel objectArray) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        Object object = this.socketOption("SO_REUSEPORT");
        Method method = channelSetOption;
        Intrinsics.checkNotNull((Object)method);
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[2];
        objectArray = objectArray3;
        objectArray3[0] = object;
        objectArray[1] = Boolean.TRUE;
        method.invoke((Object)objectArray2, objectArray);
    }

    public final void setReusePort(ServerSocketChannel objectArray) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        Object object = this.socketOption("SO_REUSEPORT");
        Method method = serverChannelSetOption;
        Intrinsics.checkNotNull((Object)method);
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[2];
        objectArray = objectArray3;
        objectArray3[0] = object;
        objectArray[1] = Boolean.TRUE;
        method.invoke((Object)objectArray2, objectArray);
    }

    public final void setReusePort(DatagramChannel objectArray) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        Object object = this.socketOption("SO_REUSEPORT");
        Method method = datagramSetOption;
        Intrinsics.checkNotNull((Object)method);
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[2];
        objectArray = objectArray3;
        objectArray3[0] = object;
        objectArray[1] = Boolean.TRUE;
        method.invoke((Object)objectArray2, objectArray);
    }

    private final Object socketOption(String string) {
        Object object = standardSocketOptions.get(string);
        if (object == null || (object = ((Field)object).get(null)) == null) {
            throw new IOException("Socket option " + string + " is not supported");
        }
        return object;
    }

    static {
        Object object;
        int n2;
        Object object3;
        INSTANCE = new SocketOptionsPlatformCapabilities();
        try {
            Object object2;
            Field[] object22;
            object3 = Class.forName("java.net.StandardSocketOptions");
            if (object3 != null && (object22 = object3.getFields()) != null) {
                object3 = object22;
                Field[] fieldArray = object22;
                Collection collection = new ArrayList();
                n2 = fieldArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Field field;
                    Field field2 = field = fieldArray[i2];
                    int n3 = field.getModifiers();
                    if (!(Modifier.isStatic(n3) && Modifier.isFinal(n3) && Modifier.isPublic(n3))) continue;
                    collection.add(field);
                }
                Object object4 = (List)collection;
                int n4 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10)), (int)16);
                object = object4;
                object3 = new LinkedHashMap(n4);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t2 = iterator.next();
                    object4 = (Field)t2;
                    fieldArray = object3;
                    String string = ((Field)object4).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    fieldArray.put(string, t2);
                }
                object2 = object3;
            } else {
                object2 = MapsKt.emptyMap();
            }
            object3 = object2;
        }
        catch (Throwable throwable) {
            object3 = MapsKt.emptyMap();
        }
        standardSocketOptions = object3;
        try {
            Object object5;
            block15: {
                object3 = Class.forName("java.net.SocketOption");
                Class<?> clazz = Class.forName("java.nio.channels.SocketChannel");
                Method[] methodArray = clazz.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"");
                for (Object object6 : (Object[])methodArray) {
                    object = (Method)object6;
                    n2 = ((Method)object).getModifiers();
                    if (!(Modifier.isPublic(n2) && !Modifier.isStatic(n2) && Intrinsics.areEqual((Object)((Method)object).getName(), (Object)"setOption") && ((Method)object).getParameterTypes().length == 2 && Intrinsics.areEqual(((Method)object).getReturnType(), clazz) && Intrinsics.areEqual(((Method)object).getParameterTypes()[0], (Object)object3) && Intrinsics.areEqual(((Method)object).getParameterTypes()[1], Object.class))) continue;
                    object5 = object6;
                    break block15;
                }
                object5 = null;
            }
            object3 = (Method)object5;
        }
        catch (Throwable throwable) {
            object3 = null;
        }
        channelSetOption = object3;
        try {
            Object object7;
            block16: {
                object3 = Class.forName("java.net.SocketOption");
                Class<?> clazz = Class.forName("java.nio.channels.ServerSocketChannel");
                Method[] methodArray = clazz.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"");
                for (Object object8 : (Object[])methodArray) {
                    object = (Method)object8;
                    n2 = ((Method)object).getModifiers();
                    if (!(Modifier.isPublic(n2) && !Modifier.isStatic(n2) && Intrinsics.areEqual((Object)((Method)object).getName(), (Object)"setOption") && ((Method)object).getParameterTypes().length == 2 && Intrinsics.areEqual(((Method)object).getReturnType(), clazz) && Intrinsics.areEqual(((Method)object).getParameterTypes()[0], (Object)object3) && Intrinsics.areEqual(((Method)object).getParameterTypes()[1], Object.class))) continue;
                    object7 = object8;
                    break block16;
                }
                object7 = null;
            }
            object3 = (Method)object7;
        }
        catch (Throwable throwable) {
            object3 = null;
        }
        serverChannelSetOption = object3;
        try {
            Object object9;
            block17: {
                object3 = Class.forName("java.net.SocketOption");
                Class<?> clazz = Class.forName("java.nio.channels.DatagramChannel");
                Method[] methodArray = clazz.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"");
                for (Object object10 : (Object[])methodArray) {
                    object = (Method)object10;
                    n2 = ((Method)object).getModifiers();
                    if (!(Modifier.isPublic(n2) && !Modifier.isStatic(n2) && Intrinsics.areEqual((Object)((Method)object).getName(), (Object)"setOption") && ((Method)object).getParameterTypes().length == 2 && Intrinsics.areEqual(((Method)object).getReturnType(), clazz) && Intrinsics.areEqual(((Method)object).getParameterTypes()[0], (Object)object3) && Intrinsics.areEqual(((Method)object).getParameterTypes()[1], Object.class))) continue;
                    object9 = object10;
                    break block17;
                }
                object9 = null;
            }
            object3 = (Method)object9;
        }
        catch (Throwable throwable) {
            object3 = null;
        }
        datagramSetOption = object3;
    }
}

