/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.SegmentedDatagramPacket;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.RecyclableArrayList;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;

public final class EpollDatagramChannel
extends AbstractEpollChannel
implements DatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private final EpollDatagramChannelConfig config = new EpollDatagramChannelConfig(this);
    private volatile boolean connected;

    public static boolean isSegmentedDatagramPacketSupported() {
        return Epoll.isAvailable() && Native.IS_SUPPORTING_SENDMMSG && Native.IS_SUPPORTING_UDP_SEGMENT;
    }

    public EpollDatagramChannel() {
        this((InternetProtocolFamily)null);
    }

    public EpollDatagramChannel(InternetProtocolFamily internetProtocolFamily) {
        this(LinuxSocket.newSocketDgram(internetProtocolFamily), false);
    }

    public EpollDatagramChannel(int n) {
        this(new LinuxSocket(n), true);
    }

    private EpollDatagramChannel(LinuxSocket linuxSocket, boolean bl) {
        super(null, linuxSocket, bl);
    }

    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public final boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public final ChannelFuture joinGroup(InetAddress inetAddress) {
        return this.joinGroup(inetAddress, this.newPromise());
    }

    public final ChannelFuture joinGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            NetworkInterface networkInterface = this.config().getNetworkInterface();
            if (networkInterface == null) {
                networkInterface = NetworkInterface.getByInetAddress(this.localAddress().getAddress());
            }
            return this.joinGroup(inetAddress, networkInterface, null, channelPromise);
        }
        catch (IOException iOException) {
            channelPromise.setFailure((Throwable)iOException);
            return channelPromise;
        }
    }

    public final ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.joinGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    public final ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.joinGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    public final ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.joinGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    public final ChannelFuture joinGroup(final InetAddress inetAddress, final NetworkInterface networkInterface, final InetAddress inetAddress2, final ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)inetAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        if (this.eventLoop().inEventLoop()) {
            this.joinGroup0(inetAddress, networkInterface, inetAddress2, channelPromise);
        } else {
            this.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    EpollDatagramChannel.this.joinGroup0(inetAddress, networkInterface, inetAddress2, channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void joinGroup0(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        assert (this.eventLoop().inEventLoop());
        try {
            this.socket.joinGroup(inetAddress, networkInterface, inetAddress2);
            channelPromise.setSuccess();
            return;
        }
        catch (IOException iOException) {
            channelPromise.setFailure((Throwable)iOException);
            return;
        }
    }

    public final ChannelFuture leaveGroup(InetAddress inetAddress) {
        return this.leaveGroup(inetAddress, this.newPromise());
    }

    public final ChannelFuture leaveGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            return this.leaveGroup(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, channelPromise);
        }
        catch (IOException iOException) {
            channelPromise.setFailure((Throwable)iOException);
            return channelPromise;
        }
    }

    public final ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.leaveGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    public final ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.leaveGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    public final ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.leaveGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    public final ChannelFuture leaveGroup(final InetAddress inetAddress, final NetworkInterface networkInterface, final InetAddress inetAddress2, final ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)inetAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        if (this.eventLoop().inEventLoop()) {
            this.leaveGroup0(inetAddress, networkInterface, inetAddress2, channelPromise);
        } else {
            this.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    EpollDatagramChannel.this.leaveGroup0(inetAddress, networkInterface, inetAddress2, channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void leaveGroup0(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        assert (this.eventLoop().inEventLoop());
        try {
            this.socket.leaveGroup(inetAddress, networkInterface, inetAddress2);
            channelPromise.setSuccess();
            return;
        }
        catch (IOException iOException) {
            channelPromise.setFailure((Throwable)iOException);
            return;
        }
    }

    public final ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.block(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    public final ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)inetAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)inetAddress2, (String)"sourceToBlock");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        channelPromise.setFailure((Throwable)new UnsupportedOperationException("Multicast block not supported"));
        return channelPromise;
    }

    public final ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2) {
        return this.block(inetAddress, inetAddress2, this.newPromise());
    }

    public final ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2, ChannelPromise channelPromise) {
        try {
            return this.block(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), inetAddress2, channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    protected final AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollDatagramChannelUnsafe();
    }

    @Override
    protected final void doBind(SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress;
        if (socketAddress instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)socketAddress).getAddress().isAnyLocalAddress() && inetSocketAddress.getAddress() instanceof Inet4Address && this.socket.family() == InternetProtocolFamily.IPv6) {
            socketAddress = new InetSocketAddress(Native.INET6_ANY, inetSocketAddress.getPort());
        }
        super.doBind(socketAddress);
        this.active = true;
    }

    protected final void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        NativeDatagramPacketArray.NativeDatagramPacket[] nativeDatagramPacketArray;
        int n = this.maxMessagesPerWrite();
        while (n > 0 && (nativeDatagramPacketArray = channelOutboundBuffer.current()) != null) {
            try {
                int n2;
                if (Native.IS_SUPPORTING_SENDMMSG && channelOutboundBuffer.size() > 1 || channelOutboundBuffer.current() instanceof SegmentedDatagramPacket) {
                    NativeDatagramPacketArray nativeDatagramPacketArray2 = this.cleanDatagramPacketArray();
                    nativeDatagramPacketArray2.add(channelOutboundBuffer, this.isConnected(), n);
                    n2 = nativeDatagramPacketArray2.count();
                    if (n2 > 0) {
                        nativeDatagramPacketArray = nativeDatagramPacketArray2.packets();
                        int n3 = this.socket.sendmmsg(nativeDatagramPacketArray, 0, n2);
                        if (n3 == 0) break;
                        for (int i = 0; i < n3; ++i) {
                            channelOutboundBuffer.remove();
                        }
                        n -= n3;
                        continue;
                    }
                }
                boolean bl = false;
                for (n2 = this.config().getWriteSpinCount(); n2 > 0; --n2) {
                    if (!this.doWriteMessage(nativeDatagramPacketArray)) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
                channelOutboundBuffer.remove();
                --n;
            }
            catch (IOException iOException) {
                --n;
                channelOutboundBuffer.remove((Throwable)iOException);
            }
        }
        if (channelOutboundBuffer.isEmpty()) {
            this.clearFlag(Native.EPOLLOUT);
            return;
        }
        this.setFlag(Native.EPOLLOUT);
    }

    private boolean doWriteMessage(Object object) {
        InetSocketAddress inetSocketAddress;
        if (object instanceof AddressedEnvelope) {
            AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
            object = (ByteBuf)addressedEnvelope.content();
            inetSocketAddress = (InetSocketAddress)addressedEnvelope.recipient();
        } else {
            object = (ByteBuf)object;
            inetSocketAddress = null;
        }
        int n = object.readableBytes();
        if (n == 0) {
            return true;
        }
        return this.doWriteOrSendBytes((ByteBuf)object, inetSocketAddress, false) > 0L;
    }

    private static void checkUnresolved(AddressedEnvelope<?, ?> addressedEnvelope) {
        if (addressedEnvelope.recipient() instanceof InetSocketAddress && ((InetSocketAddress)addressedEnvelope.recipient()).isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final Object filterOutboundMessage(Object object) {
        if (object instanceof SegmentedDatagramPacket) {
            if (!Native.IS_SUPPORTING_UDP_SEGMENT) {
                throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)object) + EXPECTED_TYPES);
            }
            SegmentedDatagramPacket segmentedDatagramPacket = (SegmentedDatagramPacket)object;
            EpollDatagramChannel.checkUnresolved(segmentedDatagramPacket);
            ByteBuf byteBuf = (ByteBuf)segmentedDatagramPacket.content();
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf)) {
                return segmentedDatagramPacket.replace(this.newDirectBuffer(segmentedDatagramPacket, byteBuf));
            }
            return object;
        }
        if (object instanceof DatagramPacket) {
            DatagramPacket datagramPacket = (DatagramPacket)object;
            EpollDatagramChannel.checkUnresolved(datagramPacket);
            ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf)) {
                return new DatagramPacket(this.newDirectBuffer(datagramPacket, byteBuf), (InetSocketAddress)datagramPacket.recipient());
            }
            return object;
        }
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf)) {
                return this.newDirectBuffer(byteBuf);
            }
            return byteBuf;
        }
        if (object instanceof AddressedEnvelope) {
            AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
            EpollDatagramChannel.checkUnresolved(addressedEnvelope);
            if (addressedEnvelope.content() instanceof ByteBuf && (addressedEnvelope.recipient() == null || addressedEnvelope.recipient() instanceof InetSocketAddress)) {
                ByteBuf byteBuf = (ByteBuf)addressedEnvelope.content();
                if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf)) {
                    return new DefaultAddressedEnvelope((Object)this.newDirectBuffer(addressedEnvelope, byteBuf), (SocketAddress)((InetSocketAddress)addressedEnvelope.recipient()));
                }
                return addressedEnvelope;
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)object) + EXPECTED_TYPES);
    }

    @Override
    public final EpollDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected final void doDisconnect() {
        this.socket.disconnect();
        EpollDatagramChannel epollDatagramChannel = this;
        epollDatagramChannel.active = false;
        epollDatagramChannel.connected = false;
        this.resetCachedAddresses();
    }

    @Override
    protected final boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (super.doConnect(socketAddress, socketAddress2)) {
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected final void doClose() {
        super.doClose();
        this.connected = false;
    }

    private boolean connectedRead(EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle, ByteBuf byteBuf, int n) {
        try {
            int n2;
            int n3 = n != 0 ? Math.min(byteBuf.writableBytes(), n) : byteBuf.writableBytes();
            epollRecvByteAllocatorHandle.attemptedBytesRead(n3);
            int n4 = byteBuf.writerIndex();
            if (byteBuf.hasMemoryAddress()) {
                int n5 = n4;
                n2 = this.socket.recvAddress(byteBuf.memoryAddress(), n5, n5 + n3);
            } else {
                ByteBuffer byteBuffer;
                ByteBuffer byteBuffer2 = byteBuffer = byteBuf.internalNioBuffer(n4, n3);
                n2 = this.socket.recv(byteBuffer2, byteBuffer2.position(), byteBuffer.limit());
            }
            if (n2 <= 0) {
                epollRecvByteAllocatorHandle.lastBytesRead(n2);
                return false;
            }
            byteBuf.writerIndex(n4 + n2);
            epollRecvByteAllocatorHandle.lastBytesRead(n <= 0 ? n2 : n3);
            DatagramPacket datagramPacket = new DatagramPacket(byteBuf, this.localAddress(), this.remoteAddress());
            epollRecvByteAllocatorHandle.incMessagesRead(1);
            this.pipeline().fireChannelRead((Object)datagramPacket);
            byteBuf = null;
            return true;
        }
        finally {
            if (byteBuf != null) {
                byteBuf.release();
            }
        }
    }

    private IOException translateForConnected(Errors.NativeIoException nativeIoException) {
        if (nativeIoException.expectedErr() == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            PortUnreachableException portUnreachableException = new PortUnreachableException(nativeIoException.getMessage());
            portUnreachableException.initCause(nativeIoException);
            return portUnreachableException;
        }
        return nativeIoException;
    }

    private static void addDatagramPacketToOut(DatagramPacket datagramPacket, RecyclableArrayList recyclableArrayList) {
        if (datagramPacket instanceof SegmentedDatagramPacket) {
            datagramPacket = (SegmentedDatagramPacket)datagramPacket;
            ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
            InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramPacket.recipient();
            InetSocketAddress inetSocketAddress2 = (InetSocketAddress)datagramPacket.sender();
            int n = datagramPacket.segmentSize();
            do {
                ByteBuf byteBuf2 = byteBuf;
                recyclableArrayList.add((Object)new DatagramPacket(byteBuf2.readRetainedSlice(Math.min(byteBuf2.readableBytes(), n)), inetSocketAddress, inetSocketAddress2));
            } while (byteBuf.isReadable());
            datagramPacket.release();
            return;
        }
        recyclableArrayList.add((Object)datagramPacket);
    }

    private static void releaseAndRecycle(ByteBuf byteBuf, RecyclableArrayList recyclableArrayList) {
        if (byteBuf != null) {
            byteBuf.release();
        }
        if (recyclableArrayList != null) {
            for (int i = 0; i < recyclableArrayList.size(); ++i) {
                ReferenceCountUtil.release((Object)recyclableArrayList.get(i));
            }
            recyclableArrayList.recycle();
        }
    }

    private static void processPacket(ChannelPipeline channelPipeline, EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle, int n, DatagramPacket datagramPacket) {
        epollRecvByteAllocatorHandle.lastBytesRead(Math.max(1, n));
        epollRecvByteAllocatorHandle.incMessagesRead(1);
        channelPipeline.fireChannelRead((Object)datagramPacket);
    }

    private static void processPacketList(ChannelPipeline channelPipeline, EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle, int n, RecyclableArrayList recyclableArrayList) {
        int n2 = recyclableArrayList.size();
        epollRecvByteAllocatorHandle.lastBytesRead(Math.max(1, n));
        epollRecvByteAllocatorHandle.incMessagesRead(n2);
        for (int i = 0; i < n2; ++i) {
            channelPipeline.fireChannelRead(recyclableArrayList.set(i, (Object)Unpooled.EMPTY_BUFFER));
        }
    }

    private boolean recvmsg(EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle, NativeDatagramPacketArray object, ByteBuf byteBuf) {
        block6: {
            int n;
            RecyclableArrayList recyclableArrayList;
            block5: {
                recyclableArrayList = null;
                try {
                    n = byteBuf.writableBytes();
                    ByteBuf byteBuf2 = byteBuf;
                    boolean bl = ((NativeDatagramPacketArray)object).addWritable(byteBuf2, byteBuf2.writerIndex(), n);
                    assert (bl);
                    epollRecvByteAllocatorHandle.attemptedBytesRead(n);
                    object = ((NativeDatagramPacketArray)object).packets()[0];
                    n = this.socket.recvmsg((NativeDatagramPacketArray.NativeDatagramPacket)object);
                    if (((NativeDatagramPacketArray.NativeDatagramPacket)object).hasSender()) break block5;
                    epollRecvByteAllocatorHandle.lastBytesRead(-1);
                }
                catch (Throwable throwable) {
                    EpollDatagramChannel.releaseAndRecycle(byteBuf, recyclableArrayList);
                    throw throwable;
                }
                EpollDatagramChannel.releaseAndRecycle(byteBuf, null);
                return false;
            }
            byteBuf.writerIndex(n);
            InetSocketAddress inetSocketAddress = this.localAddress();
            object = ((NativeDatagramPacketArray.NativeDatagramPacket)object).newDatagramPacket(byteBuf, inetSocketAddress);
            if (!(object instanceof SegmentedDatagramPacket)) {
                EpollDatagramChannel.processPacket(this.pipeline(), epollRecvByteAllocatorHandle, n, (DatagramPacket)object);
                break block6;
            }
            recyclableArrayList = RecyclableArrayList.newInstance();
            EpollDatagramChannel.addDatagramPacketToOut((DatagramPacket)object, recyclableArrayList);
            EpollDatagramChannel.processPacketList(this.pipeline(), epollRecvByteAllocatorHandle, n, recyclableArrayList);
            recyclableArrayList.recycle();
            recyclableArrayList = null;
        }
        EpollDatagramChannel.releaseAndRecycle(byteBuf, null);
        return true;
    }

    private boolean scatteringRead(EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle, NativeDatagramPacketArray nativeDatagramPacketArray, ByteBuf byteBuf, int n, int n2) {
        InetSocketAddress inetSocketAddress;
        int n3;
        NativeDatagramPacketArray.NativeDatagramPacket[] nativeDatagramPacketArray2;
        int n4;
        RecyclableArrayList recyclableArrayList;
        block7: {
            DatagramPacket datagramPacket;
            block6: {
                recyclableArrayList = null;
                n4 = byteBuf.writerIndex();
                int n5 = 0;
                while (n5 < n2 && nativeDatagramPacketArray.addWritable(byteBuf, n4, n)) {
                    ++n5;
                    n4 += n;
                }
                epollRecvByteAllocatorHandle.attemptedBytesRead(n4 - byteBuf.writerIndex());
                nativeDatagramPacketArray2 = nativeDatagramPacketArray.packets();
                n3 = this.socket.recvmmsg(nativeDatagramPacketArray2, 0, nativeDatagramPacketArray.count());
                if (n3 != 0) break block6;
                epollRecvByteAllocatorHandle.lastBytesRead(-1);
                EpollDatagramChannel.releaseAndRecycle(byteBuf, null);
                return false;
            }
            inetSocketAddress = this.localAddress();
            n4 = n3 * n;
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.writerIndex(byteBuf2.writerIndex() + n4);
            if (n3 != 1 || (datagramPacket = nativeDatagramPacketArray2[0].newDatagramPacket(byteBuf, inetSocketAddress)) instanceof SegmentedDatagramPacket) break block7;
            EpollDatagramChannel.processPacket(this.pipeline(), epollRecvByteAllocatorHandle, n, datagramPacket);
            EpollDatagramChannel.releaseAndRecycle(byteBuf, null);
            return true;
        }
        try {
            recyclableArrayList = RecyclableArrayList.newInstance();
            for (int i = 0; i < n3; ++i) {
                DatagramPacket datagramPacket = nativeDatagramPacketArray2[i].newDatagramPacket(byteBuf, inetSocketAddress);
                byteBuf.skipBytes(n);
                EpollDatagramChannel.addDatagramPacketToOut(datagramPacket, recyclableArrayList);
            }
            byteBuf.release();
            byteBuf = null;
            EpollDatagramChannel.processPacketList(this.pipeline(), epollRecvByteAllocatorHandle, n4, recyclableArrayList);
            recyclableArrayList.recycle();
            recyclableArrayList = null;
        }
        catch (Throwable throwable) {
            EpollDatagramChannel.releaseAndRecycle(byteBuf, recyclableArrayList);
            throw throwable;
        }
        EpollDatagramChannel.releaseAndRecycle(null, null);
        return true;
    }

    private NativeDatagramPacketArray cleanDatagramPacketArray() {
        return ((EpollEventLoop)this.eventLoop()).cleanDatagramPacketArray();
    }

    static /* synthetic */ NativeDatagramPacketArray access$200(EpollDatagramChannel epollDatagramChannel) {
        return epollDatagramChannel.cleanDatagramPacketArray();
    }

    static /* synthetic */ boolean access$300(EpollDatagramChannel epollDatagramChannel, EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle, NativeDatagramPacketArray nativeDatagramPacketArray, ByteBuf byteBuf) {
        return epollDatagramChannel.recvmsg(epollRecvByteAllocatorHandle, nativeDatagramPacketArray, byteBuf);
    }

    static /* synthetic */ boolean access$400(EpollDatagramChannel epollDatagramChannel, EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle, ByteBuf byteBuf, int n) {
        return epollDatagramChannel.connectedRead(epollRecvByteAllocatorHandle, byteBuf, n);
    }

    static /* synthetic */ boolean access$500(EpollDatagramChannel epollDatagramChannel, EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle, NativeDatagramPacketArray nativeDatagramPacketArray, ByteBuf byteBuf, int n, int n2) {
        return epollDatagramChannel.scatteringRead(epollRecvByteAllocatorHandle, nativeDatagramPacketArray, byteBuf, n, n2);
    }

    static /* synthetic */ IOException access$600(EpollDatagramChannel epollDatagramChannel, Errors.NativeIoException nativeIoException) {
        return epollDatagramChannel.translateForConnected(nativeIoException);
    }

    final class EpollDatagramChannelUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        EpollDatagramChannelUnsafe() {
        }

        /*
         * Exception decompiling
         */
        @Override
        final void epollInReady() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 12[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

