/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.DefaultFileRegion;
import io.netty.channel.epoll.EpollEventArray;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.channel.epoll.NativeStaticallyReferencedJniMethods;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.Socket;
import io.netty.channel.unix.Unix;
import io.netty.util.internal.ClassInitializerUtil;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.Selector;

public final class Native {
    private static final InternalLogger logger;
    static final InetAddress INET6_ANY;
    static final InetAddress INET_ANY;
    public static final int EPOLLIN;
    public static final int EPOLLOUT;
    public static final int EPOLLRDHUP;
    public static final int EPOLLET;
    public static final int EPOLLERR;
    public static final boolean IS_SUPPORTING_SENDMMSG;
    static final boolean IS_SUPPORTING_RECVMMSG;
    static final boolean IS_SUPPORTING_UDP_SEGMENT;
    private static final int TFO_ENABLED_CLIENT_MASK = 1;
    private static final int TFO_ENABLED_SERVER_MASK = 2;
    private static final int TCP_FASTOPEN_MODE;
    static final boolean IS_SUPPORTING_TCP_FASTOPEN_CLIENT;
    static final boolean IS_SUPPORTING_TCP_FASTOPEN_SERVER;
    @Deprecated
    public static final boolean IS_SUPPORTING_TCP_FASTOPEN;
    public static final int TCP_MD5SIG_MAXKEYLEN;
    public static final String KERNEL_VERSION;

    private static native int registerUnix();

    public static FileDescriptor newEventFd() {
        return new FileDescriptor(Native.eventFd());
    }

    public static FileDescriptor newTimerFd() {
        return new FileDescriptor(Native.timerFd());
    }

    private static native boolean isSupportingUdpSegment();

    private static native int eventFd();

    private static native int timerFd();

    public static native void eventFdWrite(int var0, long var1);

    public static native void eventFdRead(int var0);

    public static FileDescriptor newEpollCreate() {
        return new FileDescriptor(Native.epollCreate());
    }

    private static native int epollCreate();

    @Deprecated
    public static int epollWait(FileDescriptor fileDescriptor, EpollEventArray epollEventArray, FileDescriptor fileDescriptor2, int n, int n2) {
        long l = Native.epollWait(fileDescriptor, epollEventArray, fileDescriptor2, n, n2, -1L);
        return Native.epollReady(l);
    }

    static long epollWait(FileDescriptor fileDescriptor, EpollEventArray epollEventArray, FileDescriptor fileDescriptor2, int n, int n2, long l) {
        long l2;
        int n3;
        if (n == 0 && n2 == 0) {
            return (long)Native.epollWait(fileDescriptor, epollEventArray, 0) << 32;
        }
        if (n == Integer.MAX_VALUE) {
            n = 0;
            n2 = 0;
        }
        if ((n3 = Native.epollReady(l2 = Native.epollWait0(fileDescriptor.intValue(), epollEventArray.memoryAddress(), epollEventArray.length(), fileDescriptor2.intValue(), n, n2, l))) < 0) {
            throw Errors.newIOException((String)"epoll_wait", (int)n3);
        }
        return l2;
    }

    static int epollReady(long l) {
        return (int)(l >> 32);
    }

    static boolean epollTimerWasUsed(long l) {
        return (l & 0xFFL) != 0L;
    }

    static int epollWait(FileDescriptor fileDescriptor, EpollEventArray epollEventArray, boolean bl) {
        return Native.epollWait(fileDescriptor, epollEventArray, bl ? 0 : -1);
    }

    static int epollWait(FileDescriptor fileDescriptor, EpollEventArray epollEventArray, int n) {
        int n2 = Native.epollWait(fileDescriptor.intValue(), epollEventArray.memoryAddress(), epollEventArray.length(), n);
        if (n2 < 0) {
            throw Errors.newIOException((String)"epoll_wait", (int)n2);
        }
        return n2;
    }

    public static int epollBusyWait(FileDescriptor fileDescriptor, EpollEventArray epollEventArray) {
        int n = Native.epollBusyWait0(fileDescriptor.intValue(), epollEventArray.memoryAddress(), epollEventArray.length());
        if (n < 0) {
            throw Errors.newIOException((String)"epoll_wait", (int)n);
        }
        return n;
    }

    private static native long epollWait0(int var0, long var1, int var3, int var4, int var5, int var6, long var7);

    private static native int epollWait(int var0, long var1, int var3, int var4);

    private static native int epollBusyWait0(int var0, long var1, int var3);

    public static void epollCtlAdd(int n, int n2, int n3) {
        if ((n = Native.epollCtlAdd0(n, n2, n3)) < 0) {
            throw Errors.newIOException((String)"epoll_ctl", (int)n);
        }
    }

    private static native int epollCtlAdd0(int var0, int var1, int var2);

    public static void epollCtlMod(int n, int n2, int n3) {
        if ((n = Native.epollCtlMod0(n, n2, n3)) < 0) {
            throw Errors.newIOException((String)"epoll_ctl", (int)n);
        }
    }

    private static native int epollCtlMod0(int var0, int var1, int var2);

    public static void epollCtlDel(int n, int n2) {
        if ((n = Native.epollCtlDel0(n, n2)) < 0) {
            throw Errors.newIOException((String)"epoll_ctl", (int)n);
        }
    }

    private static native int epollCtlDel0(int var0, int var1);

    public static int splice(int n, long l, int n2, long l2, long l3) {
        if ((n = Native.splice0(n, l, n2, l2, l3)) >= 0) {
            return n;
        }
        return Errors.ioResult((String)"splice", (int)n);
    }

    private static native int splice0(int var0, long var1, int var3, long var4, long var6);

    @Deprecated
    public static int sendmmsg(int n, NativeDatagramPacketArray.NativeDatagramPacket[] nativeDatagramPacketArray, int n2, int n3) {
        return Native.sendmmsg(n, Socket.isIPv6Preferred(), nativeDatagramPacketArray, n2, n3);
    }

    static int sendmmsg(int n, boolean bl, NativeDatagramPacketArray.NativeDatagramPacket[] nativeDatagramPacketArray, int n2, int n3) {
        if ((n = Native.sendmmsg0(n, bl, nativeDatagramPacketArray, n2, n3)) >= 0) {
            return n;
        }
        return Errors.ioResult((String)"sendmmsg", (int)n);
    }

    private static native int sendmmsg0(int var0, boolean var1, NativeDatagramPacketArray.NativeDatagramPacket[] var2, int var3, int var4);

    static int recvmmsg(int n, boolean bl, NativeDatagramPacketArray.NativeDatagramPacket[] nativeDatagramPacketArray, int n2, int n3) {
        if ((n = Native.recvmmsg0(n, bl, nativeDatagramPacketArray, n2, n3)) >= 0) {
            return n;
        }
        return Errors.ioResult((String)"recvmmsg", (int)n);
    }

    private static native int recvmmsg0(int var0, boolean var1, NativeDatagramPacketArray.NativeDatagramPacket[] var2, int var3, int var4);

    static int recvmsg(int n, boolean bl, NativeDatagramPacketArray.NativeDatagramPacket nativeDatagramPacket) {
        if ((n = Native.recvmsg0(n, bl, nativeDatagramPacket)) >= 0) {
            return n;
        }
        return Errors.ioResult((String)"recvmsg", (int)n);
    }

    private static native int recvmsg0(int var0, boolean var1, NativeDatagramPacketArray.NativeDatagramPacket var2);

    public static native int sizeofEpollEvent();

    public static native int offsetofEpollData();

    private static void loadNativeLibrary() {
        String string = PlatformDependent.normalizedOs();
        if (!"linux".equals(string)) {
            throw new IllegalStateException("Only supported on Linux");
        }
        string = "netty_transport_native_epoll";
        String string2 = string + '_' + PlatformDependent.normalizedArch();
        ClassLoader classLoader = PlatformDependent.getClassLoader(Native.class);
        try {
            NativeLibraryLoader.load((String)string2, (ClassLoader)classLoader);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                NativeLibraryLoader.load((String)string, (ClassLoader)classLoader);
                logger.debug("Failed to load {}", (Object)string2, (Object)unsatisfiedLinkError);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                ThrowableUtil.addSuppressed((Throwable)unsatisfiedLinkError, (Throwable)unsatisfiedLinkError2);
                throw unsatisfiedLinkError;
            }
        }
    }

    private Native() {
    }

    /*
     * Loose catch block
     */
    static {
        block17: {
            logger = InternalLoggerFactory.getInstance(Native.class);
            Selector selector = null;
            try {
                selector = Selector.open();
            }
            catch (IOException iOException) {}
            try {
                INET_ANY = InetAddress.getByName("0.0.0.0");
                INET6_ANY = InetAddress.getByName("::");
            }
            catch (UnknownHostException unknownHostException) {
                throw new ExceptionInInitializerError(unknownHostException);
            }
            ClassInitializerUtil.tryLoadClasses(Native.class, (Class[])new Class[]{PeerCredentials.class, DefaultFileRegion.class, FileChannel.class, java.io.FileDescriptor.class, NativeDatagramPacketArray.NativeDatagramPacket.class});
            Native.offsetofEpollData();
            try {
                if (selector != null) {
                    selector.close();
                }
                break block17;
            }
            catch (IOException iOException) {}
            break block17;
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    Native.loadNativeLibrary();
                }
                catch (Throwable throwable) {
                    try {
                        if (selector != null) {
                            selector.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        Unix.registerInternal((Runnable)new Runnable(){

            @Override
            public final void run() {
                Native.registerUnix();
            }
        });
        EPOLLIN = NativeStaticallyReferencedJniMethods.epollin();
        EPOLLOUT = NativeStaticallyReferencedJniMethods.epollout();
        EPOLLRDHUP = NativeStaticallyReferencedJniMethods.epollrdhup();
        EPOLLET = NativeStaticallyReferencedJniMethods.epollet();
        EPOLLERR = NativeStaticallyReferencedJniMethods.epollerr();
        IS_SUPPORTING_SENDMMSG = NativeStaticallyReferencedJniMethods.isSupportingSendmmsg();
        IS_SUPPORTING_RECVMMSG = NativeStaticallyReferencedJniMethods.isSupportingRecvmmsg();
        IS_SUPPORTING_UDP_SEGMENT = Native.isSupportingUdpSegment();
        TCP_FASTOPEN_MODE = NativeStaticallyReferencedJniMethods.tcpFastopenMode();
        IS_SUPPORTING_TCP_FASTOPEN_CLIENT = (TCP_FASTOPEN_MODE & 1) == 1;
        IS_SUPPORTING_TCP_FASTOPEN_SERVER = (TCP_FASTOPEN_MODE & 2) == 2;
        IS_SUPPORTING_TCP_FASTOPEN = IS_SUPPORTING_TCP_FASTOPEN_CLIENT || IS_SUPPORTING_TCP_FASTOPEN_SERVER;
        TCP_MD5SIG_MAXKEYLEN = NativeStaticallyReferencedJniMethods.tcpMd5SigMaxKeyLen();
        KERNEL_VERSION = NativeStaticallyReferencedJniMethods.kernelVersion();
    }
}

