/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceFile;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.IncompatibleVersionErrorData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.text.StringsKt;

public final class JvmPackagePartSource
implements DeserializedContainerSource {
    private final JvmClassName className;
    private final JvmClassName facadeClassName;
    private final IncompatibleVersionErrorData<JvmMetadataVersion> incompatibility;
    private final boolean isPreReleaseInvisible;
    private final DeserializedContainerAbiStability abiStability;
    private final KotlinJvmBinaryClass knownJvmBinaryClass;
    private final String moduleName;

    public JvmPackagePartSource(JvmClassName jvmClassName, JvmClassName object, ProtoBuf.Package package_, NameResolver nameResolver, IncompatibleVersionErrorData<JvmMetadataVersion> incompatibleVersionErrorData, boolean bl, DeserializedContainerAbiStability deserializedContainerAbiStability, KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Object object2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)jvmClassName, (String)"");
                Intrinsics.checkNotNullParameter((Object)package_, (String)"");
                Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
                Intrinsics.checkNotNullParameter((Object)((Object)deserializedContainerAbiStability), (String)"");
                this.className = jvmClassName;
                this.facadeClassName = object;
                this.incompatibility = incompatibleVersionErrorData;
                this.isPreReleaseInvisible = bl;
                this.abiStability = deserializedContainerAbiStability;
                this.knownJvmBinaryClass = kotlinJvmBinaryClass;
                Object object3 = this;
                GeneratedMessageLite.ExtendableMessage extendableMessage = package_;
                GeneratedMessageLite.GeneratedExtension<ProtoBuf.Package, Integer> generatedExtension = JvmProtoBuf.packageModuleName;
                Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"");
                object2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
                if (object2 == null) break block2;
                int n = ((Number)object2).intValue();
                object = object3;
                String string = nameResolver.getString(n);
                object3 = object;
                object2 = string;
                if (string != null) break block3;
            }
            object2 = "main";
        }
        ((JvmPackagePartSource)object3).moduleName = object2;
    }

    public final JvmClassName getClassName() {
        return this.className;
    }

    public final JvmClassName getFacadeClassName() {
        return this.facadeClassName;
    }

    public final KotlinJvmBinaryClass getKnownJvmBinaryClass() {
        return this.knownJvmBinaryClass;
    }

    public JvmPackagePartSource(KotlinJvmBinaryClass kotlinJvmBinaryClass, ProtoBuf.Package package_, NameResolver nameResolver, IncompatibleVersionErrorData<JvmMetadataVersion> incompatibleVersionErrorData, boolean bl, DeserializedContainerAbiStability deserializedContainerAbiStability) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass, (String)"");
        Intrinsics.checkNotNullParameter((Object)package_, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)deserializedContainerAbiStability), (String)"");
        JvmPackagePartSource jvmPackagePartSource = this;
        JvmClassName jvmClassName = JvmClassName.byClassId(kotlinJvmBinaryClass.getClassId());
        JvmClassName jvmClassName2 = jvmClassName;
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"");
        String string = kotlinJvmBinaryClass.getClassHeader().getMultifileClassName();
        if (string != null) {
            Object object2 = string;
            JvmClassName jvmClassName3 = jvmClassName2;
            JvmPackagePartSource jvmPackagePartSource2 = jvmPackagePartSource;
            object2 = ((CharSequence)object2).length() > 0 ? JvmClassName.byInternalName((String)object2) : null;
            jvmPackagePartSource = jvmPackagePartSource2;
            jvmClassName2 = jvmClassName3;
            object = object2;
        } else {
            object = null;
        }
        jvmPackagePartSource(jvmClassName2, (JvmClassName)object, package_, nameResolver, incompatibleVersionErrorData, bl, deserializedContainerAbiStability, kotlinJvmBinaryClass);
    }

    @Override
    public final String getPresentableString() {
        return "Class '" + this.getClassId().asSingleFqName().asString() + '\'';
    }

    public final Name getSimpleName() {
        String string = this.getClassName().getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        Name name = Name.identifier(StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        return name;
    }

    public final ClassId getClassId() {
        FqName fqName = this.getClassName().getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"");
        return new ClassId(fqName, this.getSimpleName());
    }

    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.getClassName();
    }

    @Override
    public final SourceFile getContainingFile() {
        SourceFile sourceFile = SourceFile.NO_SOURCE_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)sourceFile, (String)"");
        return sourceFile;
    }
}

