/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.calls.inference;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorImpl;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;

public final class CapturedType
extends SimpleType
implements CapturedTypeMarker {
    private final TypeProjection typeProjection;
    private final CapturedTypeConstructor constructor;
    private final boolean isMarkedNullable;
    private final TypeAttributes attributes;

    public CapturedType(TypeProjection typeProjection, CapturedTypeConstructor capturedTypeConstructor, boolean bl, TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeProjection, (String)"");
        Intrinsics.checkNotNullParameter((Object)capturedTypeConstructor, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        this.typeProjection = typeProjection;
        this.constructor = capturedTypeConstructor;
        this.isMarkedNullable = bl;
        this.attributes = typeAttributes;
    }

    public /* synthetic */ CapturedType(TypeProjection typeProjection, CapturedTypeConstructor capturedTypeConstructor, boolean bl, TypeAttributes typeAttributes, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            capturedTypeConstructor = new CapturedTypeConstructorImpl(typeProjection);
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            typeAttributes = TypeAttributes.Companion.getEmpty();
        }
        this(typeProjection, capturedTypeConstructor, bl, typeAttributes);
    }

    @Override
    public final CapturedTypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    public final boolean isMarkedNullable() {
        return this.isMarkedNullable;
    }

    @Override
    public final TypeAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public final List<TypeProjection> getArguments() {
        return CollectionsKt.emptyList();
    }

    @Override
    public final MemberScope getMemberScope() {
        return ErrorUtils.createErrorScope(ErrorScopeKind.CAPTURED_TYPE_SCOPE, true, new String[0]);
    }

    @Override
    public final String toString() {
        return "Captured(" + this.typeProjection + ')' + (((KotlinType)this).isMarkedNullable() ? "?" : "");
    }

    @Override
    public final CapturedType makeNullableAsSpecified(boolean bl) {
        if (bl == ((KotlinType)this).isMarkedNullable()) {
            return this;
        }
        return new CapturedType(this.typeProjection, this.getConstructor(), bl, ((KotlinType)this).getAttributes());
    }

    @Override
    public final SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return new CapturedType(this.typeProjection, this.getConstructor(), ((KotlinType)this).isMarkedNullable(), typeAttributes);
    }

    @Override
    public final CapturedType refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        TypeProjection typeProjection = this.typeProjection.refine(kotlinTypeRefiner);
        Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"");
        return new CapturedType(typeProjection, this.getConstructor(), ((KotlinType)this).isMarkedNullable(), ((KotlinType)this).getAttributes());
    }
}

