/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.InlineClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MultiFieldValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$$Lambda$3;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefinerKt;
import kotlin.reflect.jvm.internal.impl.types.checker.Ref;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeRefinementSupport;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

public final class DescriptorUtilsKt {
    private static final Name RETENTION_PARAMETER_NAME;

    public static final FqNameUnsafe getFqNameUnsafe(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(declarationDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"");
        return fqNameUnsafe;
    }

    public static final FqName getFqNameSafe(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        FqName fqName = DescriptorUtils.getFqNameSafe(declarationDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"");
        return fqName;
    }

    public static final ModuleDescriptor getModule(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(declarationDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"");
        return moduleDescriptor;
    }

    public static final ClassDescriptor resolveTopLevelClass(ModuleDescriptor object, FqName fqName, LookupLocation lookupLocation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        boolean bl2 = bl = !fqName.isRoot();
        if (_Assertions.ENABLED && !bl) {
            object = "Assertion failed";
            throw new AssertionError(object);
        }
        ClassifierDescriptor classifierDescriptor = object.getPackage(fqName.parent()).getMemberScope().getContributedClassifier(fqName.shortName(), lookupLocation);
        if (classifierDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)classifierDescriptor;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ClassId getClassId(ClassifierDescriptor classifierDescriptor) {
        ClassId classId;
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        DeclarationDescriptor declarationDescriptor = classifierDescriptor2;
        if (classifierDescriptor2 == null) return null;
        DeclarationDescriptor declarationDescriptor = declarationDescriptor.getContainingDeclaration();
        declarationDescriptor = declarationDescriptor;
        if (declarationDescriptor2 == null) return null;
        DeclarationDescriptor declarationDescriptor3 = declarationDescriptor;
        DeclarationDescriptor declarationDescriptor4 = declarationDescriptor;
        if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            FqName fqName = ((PackageFragmentDescriptor)declarationDescriptor3).getFqName();
            Name name = classifierDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            classId = new ClassId(fqName, name);
            return classId;
        } else {
            if (!(declarationDescriptor4 instanceof ClassifierDescriptorWithTypeParameters)) return null;
            ClassId classId2 = DescriptorUtilsKt.getClassId(declarationDescriptor3);
            if (classId2 == null) return null;
            Name name = classifierDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            classId = classId2.createNestedClassId(name);
        }
        return classId;
    }

    public static final ClassDescriptor getSuperClassNotAny(ClassDescriptor object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        for (Annotated annotated : object.getDefaultType().getConstructor().getSupertypes()) {
            if (KotlinBuiltIns.isAnyOrNullableAny(annotated) || !DescriptorUtils.isClassOrEnumClass((DeclarationDescriptor)(annotated = annotated.getConstructor().getDeclarationDescriptor()))) continue;
            Intrinsics.checkNotNull((Object)annotated);
            return (ClassDescriptor)annotated;
        }
        return null;
    }

    public static final KotlinBuiltIns getBuiltIns(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return DescriptorUtilsKt.getModule(declarationDescriptor).getBuiltIns();
    }

    public static final boolean declaresOrInheritsDefaultValue(ValueParameterDescriptor valueParameterDescriptor) {
        Intrinsics.checkNotNullParameter((Object)valueParameterDescriptor, (String)"");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)valueParameterDescriptor), DescriptorUtilsKt$$Lambda$0.INSTANCE, declaresOrInheritsDefaultValue.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"");
        return bl;
    }

    public static final Sequence<DeclarationDescriptor> getParentsWithSelf(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return SequencesKt.generateSequence((Object)declarationDescriptor, (Function1)DescriptorUtilsKt$$Lambda$1.INSTANCE);
    }

    public static final Sequence<DeclarationDescriptor> getParents(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return SequencesKt.drop(DescriptorUtilsKt.getParentsWithSelf(declarationDescriptor), (int)1);
    }

    public static final CallableMemberDescriptor getPropertyIfAccessor(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        if (callableMemberDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)callableMemberDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"");
            return propertyDescriptor;
        }
        return callableMemberDescriptor;
    }

    public static final FqName fqNameOrNull(DeclarationDescriptor object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)object);
        FqNameUnsafe fqNameUnsafe = object;
        Object object2 = ((FqNameUnsafe)object).isSafe() ? object : null;
        if (object2 != null) {
            return ((FqNameUnsafe)object2).toSafe();
        }
        return null;
    }

    public static final CallableMemberDescriptor firstOverridden(CallableMemberDescriptor callableMemberDescriptor, boolean bl, Function1<? super CallableMemberDescriptor, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        return (CallableMemberDescriptor)DFS.dfs(CollectionsKt.listOf((Object)callableMemberDescriptor), new DescriptorUtilsKt$$Lambda$2(bl), new DFS.AbstractNodeHandler<CallableMemberDescriptor, CallableMemberDescriptor>((Ref.ObjectRef<CallableMemberDescriptor>)objectRef, function1){
            final /* synthetic */ Ref.ObjectRef<CallableMemberDescriptor> $result;
            final /* synthetic */ Function1<CallableMemberDescriptor, Boolean> $predicate;
            {
                this.$result = objectRef;
                this.$predicate = function1;
            }

            public final boolean beforeChildren(CallableMemberDescriptor callableMemberDescriptor) {
                Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
                return this.$result.element == null;
            }

            public final void afterChildren(CallableMemberDescriptor callableMemberDescriptor) {
                Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
                if (this.$result.element == null && ((Boolean)this.$predicate.invoke((Object)callableMemberDescriptor)).booleanValue()) {
                    this.$result.element = callableMemberDescriptor;
                }
            }

            public final CallableMemberDescriptor result() {
                return (CallableMemberDescriptor)this.$result.element;
            }
        });
    }

    public static /* synthetic */ CallableMemberDescriptor firstOverridden$default(CallableMemberDescriptor callableMemberDescriptor, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return DescriptorUtilsKt.firstOverridden(callableMemberDescriptor, bl, (Function1<? super CallableMemberDescriptor, Boolean>)function1);
    }

    public static final Sequence<CallableMemberDescriptor> overriddenTreeAsSequence(CallableMemberDescriptor callableMemberDescriptor, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        callableMemberDescriptor = bl ? callableMemberDescriptor.getOriginal() : callableMemberDescriptor;
        Object[] objectArray = new CallableMemberDescriptor[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = callableMemberDescriptor;
        Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray2);
        Collection<? extends CallableMemberDescriptor> collection = callableMemberDescriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        return SequencesKt.plus((Sequence)sequence, (Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)new DescriptorUtilsKt$$Lambda$3(bl)));
    }

    public static final ClassDescriptor getAnnotationClass(AnnotationDescriptor object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = object.getType().getConstructor().getDeclarationDescriptor();
        if (object instanceof ClassDescriptor) {
            return (ClassDescriptor)object;
        }
        return null;
    }

    public static final KotlinTypeRefiner getKotlinTypeRefiner(ModuleDescriptor object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Ref<TypeRefinementSupport> ref = object.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
        object = ref != null ? ref.getValue() : null;
        if (object instanceof TypeRefinementSupport.Enabled) {
            return ((TypeRefinementSupport.Enabled)object).getTypeRefiner();
        }
        return KotlinTypeRefiner.Default.INSTANCE;
    }

    public static final boolean isTypeRefinementEnabled(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Ref<TypeRefinementSupport> ref = moduleDescriptor.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
        if (ref != null && (ref = ref.getValue()) != null) {
            return ((TypeRefinementSupport)((Object)ref)).isEnabled();
        }
        return false;
    }

    public static final InlineClassRepresentation<SimpleType> getInlineClassRepresentation(ClassDescriptor valueClassRepresentation) {
        ClassDescriptor classDescriptor = valueClassRepresentation;
        valueClassRepresentation = classDescriptor != null ? classDescriptor.getValueClassRepresentation() : null;
        if (valueClassRepresentation instanceof InlineClassRepresentation) {
            return (InlineClassRepresentation)valueClassRepresentation;
        }
        return null;
    }

    public static final MultiFieldValueClassRepresentation<SimpleType> getMultiFieldValueClassRepresentation(ClassDescriptor valueClassRepresentation) {
        ClassDescriptor classDescriptor = valueClassRepresentation;
        valueClassRepresentation = classDescriptor != null ? classDescriptor.getValueClassRepresentation() : null;
        if (valueClassRepresentation instanceof MultiFieldValueClassRepresentation) {
            return (MultiFieldValueClassRepresentation)valueClassRepresentation;
        }
        return null;
    }

    private static final Iterable declaresOrInheritsDefaultValue$lambda$5(ValueParameterDescriptor object) {
        Object object2 = object = (Iterable)object.getOverriddenDescriptors();
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (ValueParameterDescriptor)object3;
            Object object4 = object;
            object4.add(object3.getOriginal());
        }
        return (List)object;
    }

    private static final DeclarationDescriptor _get_parentsWithSelf_$lambda$8(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return declarationDescriptor.getContainingDeclaration();
    }

    private static final Iterable firstOverridden$lambda$10(boolean bl, CallableMemberDescriptor callableMemberDescriptor) {
        CallableMemberDescriptor callableMemberDescriptor2;
        if (bl) {
            CallableMemberDescriptor callableMemberDescriptor3 = callableMemberDescriptor;
            callableMemberDescriptor2 = callableMemberDescriptor3 != null ? callableMemberDescriptor3.getOriginal() : null;
        } else {
            callableMemberDescriptor2 = callableMemberDescriptor;
        }
        CallableMemberDescriptor callableMemberDescriptor4 = callableMemberDescriptor2;
        Object object = callableMemberDescriptor2;
        if (callableMemberDescriptor2 != null && (object = object.getOverriddenDescriptors()) != null) {
            return (Iterable)object;
        }
        return CollectionsKt.emptyList();
    }

    private static final Sequence overriddenTreeAsSequence$lambda$12$lambda$11(boolean bl, CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNull((Object)callableMemberDescriptor);
        return DescriptorUtilsKt.overriddenTreeAsSequence(callableMemberDescriptor, bl);
    }

    static {
        Name name = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        RETENTION_PARAMETER_NAME = name;
    }

    static /* synthetic */ Iterable accessor$DescriptorUtilsKt$lambda0(ValueParameterDescriptor valueParameterDescriptor) {
        return DescriptorUtilsKt.declaresOrInheritsDefaultValue$lambda$5(valueParameterDescriptor);
    }

    static /* synthetic */ DeclarationDescriptor accessor$DescriptorUtilsKt$lambda1(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtilsKt._get_parentsWithSelf_$lambda$8(declarationDescriptor);
    }

    static /* synthetic */ Iterable accessor$DescriptorUtilsKt$lambda2(boolean bl, CallableMemberDescriptor callableMemberDescriptor) {
        return DescriptorUtilsKt.firstOverridden$lambda$10(bl, callableMemberDescriptor);
    }

    static /* synthetic */ Sequence accessor$DescriptorUtilsKt$lambda3(boolean bl, CallableMemberDescriptor callableMemberDescriptor) {
        return DescriptorUtilsKt.overriddenTreeAsSequence$lambda$12$lambda$11(bl, callableMemberDescriptor);
    }
}

