/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScopeKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ResolutionScope;
import kotlin.reflect.jvm.internal.impl.util.collectionUtils.ScopeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.SmartList;

public final class ChainedMemberScope
implements MemberScope {
    public static final Companion Companion = new Companion(null);
    private final String debugName;
    private final MemberScope[] scopes;

    private ChainedMemberScope(String string, MemberScope[] memberScopeArray) {
        this.debugName = string;
        this.scopes = memberScopeArray;
    }

    @Override
    public final ClassifierDescriptor getContributedClassifier(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        Object object = null;
        for (MemberScope memberScope : memberScopeArray) {
            Object object2 = memberScope;
            object2 = memberScope;
            object2 = ((ResolutionScope)memberScope).getContributedClassifier(name, lookupLocation);
            if (object2 == null) continue;
            if (object2 instanceof ClassifierDescriptorWithTypeParameters && ((MemberDescriptor)object2).isExpect()) {
                if (object != null) continue;
                object = object2;
                continue;
            }
            return object2;
        }
        return object;
    }

    public final Collection<PropertyDescriptor> getContributedVariables(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        switch (this.scopes.length) {
            case 0: {
                return CollectionsKt.emptyList();
            }
            case 1: {
                MemberScope memberScope = memberScopeArray[0];
                return memberScope.getContributedVariables(name, lookupLocation);
            }
        }
        Collection<? extends PropertyDescriptor> collection = null;
        for (MemberScope memberScope : memberScopeArray) {
            collection = ScopeUtilsKt.concat(collection, memberScope.getContributedVariables(name, lookupLocation));
        }
        Collection<? extends PropertyDescriptor> collection2 = collection;
        if (collection2 == null) {
            collection2 = SetsKt.emptySet();
        }
        return collection2;
    }

    public final Collection<SimpleFunctionDescriptor> getContributedFunctions(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        switch (this.scopes.length) {
            case 0: {
                return CollectionsKt.emptyList();
            }
            case 1: {
                MemberScope memberScope = memberScopeArray[0];
                return memberScope.getContributedFunctions(name, lookupLocation);
            }
        }
        Collection<? extends SimpleFunctionDescriptor> collection = null;
        for (MemberScope memberScope : memberScopeArray) {
            collection = ScopeUtilsKt.concat(collection, memberScope.getContributedFunctions(name, lookupLocation));
        }
        Collection<? extends SimpleFunctionDescriptor> collection2 = collection;
        if (collection2 == null) {
            collection2 = SetsKt.emptySet();
        }
        return collection2;
    }

    @Override
    public final Collection<DeclarationDescriptor> getContributedDescriptors(DescriptorKindFilter descriptorKindFilter, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)descriptorKindFilter, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        switch (this.scopes.length) {
            case 0: {
                return CollectionsKt.emptyList();
            }
            case 1: {
                MemberScope memberScope = memberScopeArray[0];
                return ((ResolutionScope)memberScope).getContributedDescriptors(descriptorKindFilter, function1);
            }
        }
        Collection<DeclarationDescriptor> collection = null;
        for (MemberScope memberScope : memberScopeArray) {
            collection = ScopeUtilsKt.concat(collection, ((ResolutionScope)memberScope).getContributedDescriptors(descriptorKindFilter, function1));
        }
        Collection<DeclarationDescriptor> collection2 = collection;
        if (collection2 == null) {
            collection2 = SetsKt.emptySet();
        }
        return collection2;
    }

    @Override
    public final Set<Name> getFunctionNames() {
        MemberScope[] memberScopeArray = this.scopes;
        Collection collection = new LinkedHashSet();
        for (MemberScope memberScope : memberScopeArray) {
            Object object = memberScope;
            object = memberScope;
            object = memberScope.getFunctionNames();
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        return (Set)collection;
    }

    @Override
    public final Set<Name> getVariableNames() {
        MemberScope[] memberScopeArray = this.scopes;
        Collection collection = new LinkedHashSet();
        for (MemberScope memberScope : memberScopeArray) {
            Object object = memberScope;
            object = memberScope;
            object = memberScope.getVariableNames();
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        return (Set)collection;
    }

    @Override
    public final Set<Name> getClassifierNames() {
        return MemberScopeKt.flatMapClassifierNamesOrNull(ArraysKt.asIterable((Object[])this.scopes));
    }

    @Override
    public final void recordLookup(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        for (MemberScope memberScope : this.scopes) {
            MemberScope memberScope2 = memberScope;
            memberScope2 = memberScope;
            memberScope.recordLookup(name, lookupLocation);
        }
    }

    public final String toString() {
        return this.debugName;
    }

    public /* synthetic */ ChainedMemberScope(String string, MemberScope[] memberScopeArray, DefaultConstructorMarker defaultConstructorMarker) {
        this(string, memberScopeArray);
    }

    public static final class Companion {
        private Companion() {
        }

        public final MemberScope create(String string, Iterable<? extends MemberScope> object) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Intrinsics.checkNotNullParameter(object, (String)"");
            SmartList<MemberScope> smartList = new SmartList<MemberScope>();
            object = object.iterator();
            while (object.hasNext()) {
                MemberScope memberScope = (MemberScope)object.next();
                if (memberScope == MemberScope.Empty.INSTANCE) continue;
                if (memberScope instanceof ChainedMemberScope) {
                    CollectionsKt.addAll((Collection)smartList, (Object[])((ChainedMemberScope)memberScope).scopes);
                    continue;
                }
                smartList.add(memberScope);
            }
            return this.createOrSingle$descriptors(string, (List<? extends MemberScope>)smartList);
        }

        public final MemberScope createOrSingle$descriptors(String object, List<? extends MemberScope> list) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            Intrinsics.checkNotNullParameter(list, (String)"");
            switch (list.size()) {
                case 0: {
                    return MemberScope.Empty.INSTANCE;
                }
                case 1: {
                    return list.get(0);
                }
            }
            String string = object;
            Collection collection = list;
            object = collection;
            object = collection;
            return new ChainedMemberScope(string, collection.toArray(new MemberScope[0]), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

