/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public final class AnnotationDeserializer {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;

    public AnnotationDeserializer(ModuleDescriptor moduleDescriptor, NotFoundClasses notFoundClasses) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"");
        this.module = moduleDescriptor;
        this.notFoundClasses = notFoundClasses;
    }

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    public final AnnotationDescriptor deserializeAnnotation(ProtoBuf.Annotation object, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        ClassDescriptor classDescriptor = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, object.getId()));
        Map map = MapsKt.emptyMap();
        if (object.getArgumentCount() != 0 && !ErrorUtils.isError(classDescriptor) && DescriptorUtils.isAnnotationClass(classDescriptor)) {
            Collection<ClassConstructorDescriptor> collection = classDescriptor.getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"");
            Object object2 = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (object2 != null) {
                List<ValueParameterDescriptor> list = object2.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                object2 = list;
                int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10)), (int)16);
                map = new LinkedHashMap(n);
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Object t = object2.next();
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)t;
                    Map map2 = map;
                    map2.put(valueParameterDescriptor.getName(), t);
                }
                List<ProtoBuf.Annotation.Argument> list2 = object.getArgumentList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"");
                Object object3 = object2 = (Iterable)list2;
                object2 = new ArrayList();
                object = object3;
                for (ValueParameterDescriptor valueParameterDescriptor : object) {
                    object = valueParameterDescriptor;
                    object = (ProtoBuf.Annotation.Argument)((Object)valueParameterDescriptor);
                    Intrinsics.checkNotNull(object);
                    Pair<Name, ConstantValue<?>> pair = this.resolveArgument((ProtoBuf.Annotation.Argument)object, map, nameResolver);
                    if (pair == null) continue;
                    object = pair;
                    object2.add(object);
                }
                map = MapsKt.toMap((Iterable)((List)object2));
            }
        }
        return new AnnotationDescriptorImpl(classDescriptor.getDefaultType(), map, SourceElement.NO_SOURCE);
    }

    private final Pair<Name, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument argument, Map<Name, ? extends ValueParameterDescriptor> object, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = object.get(NameResolverUtilKt.getName(nameResolver, argument.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        object = valueParameterDescriptor;
        Name name = NameResolverUtilKt.getName(nameResolver, argument.getNameId());
        KotlinType kotlinType = object.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        ProtoBuf.Annotation.Argument.Value value = argument.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"");
        return new Pair((Object)name, this.resolveValueAndCheckExpectedType(kotlinType, value, nameResolver));
    }

    private final ConstantValue<?> resolveValueAndCheckExpectedType(KotlinType kotlinType, ProtoBuf.Annotation.Argument.Value value, NameResolver object) {
        Object object2 = object = this.resolveValue(kotlinType, value, (NameResolver)object);
        Object object3 = this.doesValueConformToExpectedType((ConstantValue<?>)object2, kotlinType, value) ? object : null;
        if (object3 == null) {
            object3 = ErrorValue.Companion.create("Unexpected argument value: actual type " + value.getType() + " != expected type " + kotlinType);
        }
        return object3;
    }

    public final ConstantValue<?> resolveValue(KotlinType kotlinType, ProtoBuf.Annotation.Argument.Value iterator2, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Boolean bl = Flags.IS_UNSIGNED.get(((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"");
        boolean bl2 = bl;
        ProtoBuf.Annotation.Argument.Value.Type type = ((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                byte by = (byte)((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getIntValue();
                return bl2 ? new UByteValue(by) : new ByteValue(by);
            }
            case 2: {
                return new CharValue((char)((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getIntValue());
            }
            case 3: {
                short s = (short)((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getIntValue();
                return bl2 ? new UShortValue(s) : new ShortValue(s);
            }
            case 4: {
                int n = (int)((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getIntValue();
                return bl2 ? new UIntValue(n) : new IntValue(n);
            }
            case 5: {
                long l = ((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getIntValue();
                return bl2 ? new ULongValue(l) : new LongValue(l);
            }
            case 6: {
                return new FloatValue(((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getFloatValue());
            }
            case 7: {
                return new DoubleValue(((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getDoubleValue());
            }
            case 8: {
                return new BooleanValue(((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getIntValue() != 0L);
            }
            case 9: {
                return new StringValue(nameResolver.getString(((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getStringValue()));
            }
            case 10: {
                return new KClassValue(NameResolverUtilKt.getClassId(nameResolver, ((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getClassId()), ((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getArrayDimensionCount());
            }
            case 11: {
                return new EnumValue(NameResolverUtilKt.getClassId(nameResolver, ((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getClassId()), NameResolverUtilKt.getName(nameResolver, ((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getEnumValueId()));
            }
            case 12: {
                ProtoBuf.Annotation annotation = ((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getAnnotation();
                Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"");
                return new AnnotationValue(this.deserializeAnnotation(annotation, nameResolver));
            }
            case 13: {
                List<ProtoBuf.Annotation.Argument.Value> list = ((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getArrayElementList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                iterator2 = list;
                ConstantValueFactory constantValueFactory = ConstantValueFactory.INSTANCE;
                Iterator iterator3 = iterator2;
                iterator2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), (int)10));
                iterator3 = iterator3.iterator();
                while (iterator3.hasNext()) {
                    Object object = iterator3.next();
                    object = (ProtoBuf.Annotation.Argument.Value)object;
                    Iterator iterator4 = iterator2;
                    AnnotationDeserializer annotationDeserializer = this;
                    SimpleType simpleType = annotationDeserializer.getBuiltIns().getAnyType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                    KotlinType kotlinType2 = simpleType;
                    Intrinsics.checkNotNull(object);
                    iterator4.add(annotationDeserializer.resolveValue(kotlinType2, (ProtoBuf.Annotation.Argument.Value)object, nameResolver));
                }
                return constantValueFactory.createArrayValue((List)((Object)iterator2), kotlinType);
            }
        }
        throw new IllegalStateException(("Unsupported annotation argument type: " + ((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getType() + " (expected " + kotlinType + ')').toString());
    }

    private final boolean doesValueConformToExpectedType(ConstantValue<?> constantValue, KotlinType annotated, ProtoBuf.Annotation.Argument.Value value) {
        ProtoBuf.Annotation.Argument.Value.Type type = value.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 10: {
                ClassifierDescriptor classifierDescriptor = annotated.getConstructor().getDeclarationDescriptor();
                annotated = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                return annotated == null || KotlinBuiltIns.isKClass((ClassDescriptor)annotated);
            }
            case 13: {
                if (!(constantValue instanceof ArrayValue && ((List)((ArrayValue)constantValue).getValue()).size() == value.getArrayElementList().size())) {
                    String string = "Deserialized ArrayValue should have the same number of elements as the original array value: " + constantValue;
                    throw new IllegalStateException(string.toString());
                }
                KotlinType kotlinType = this.getBuiltIns().getArrayElementTypeOrNull((KotlinType)annotated);
                if (kotlinType == null) {
                    return false;
                }
                annotated = kotlinType;
                Object object = (Iterable)CollectionsKt.getIndices((Collection)((Collection)((ArrayValue)constantValue).getValue()));
                if (object instanceof Collection && ((Collection)object).isEmpty()) {
                    return true;
                }
                object = object.iterator();
                while (object.hasNext()) {
                    int n = ((IntIterator)object).nextInt();
                    ConstantValue constantValue2 = (ConstantValue)((List)((ArrayValue)constantValue).getValue()).get(n);
                    ProtoBuf.Annotation.Argument.Value value2 = value.getArrayElement(n);
                    Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"");
                    if (this.doesValueConformToExpectedType(constantValue2, (KotlinType)annotated, value2)) continue;
                    return false;
                }
                return true;
            }
        }
        return Intrinsics.areEqual((Object)constantValue.getType(this.module), (Object)annotated);
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.Annotation.Argument.Value.Type.values().length];
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.SHORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.STRING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.CLASS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ENUM.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ARRAY.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

