/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.storage;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.storage.DefaultSimpleLock;

public final class CancellableSimpleLock
extends DefaultSimpleLock {
    private final Runnable checkCancelled;
    private final Function1<InterruptedException, Unit> interruptedExceptionHandler;

    public CancellableSimpleLock(Lock lock, Runnable runnable, Function1<? super InterruptedException, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        super(lock);
        this.checkCancelled = runnable;
        this.interruptedExceptionHandler = function1;
    }

    public CancellableSimpleLock(Runnable runnable, Function1<? super InterruptedException, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        ReentrantLock reentrantLock = new ReentrantLock();
        this((Lock)reentrantLock, runnable, function1);
    }

    @Override
    public final void lock() {
        try {
            while (!this.getLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
                this.checkCancelled.run();
            }
        }
        catch (InterruptedException interruptedException) {
            this.interruptedExceptionHandler.invoke((Object)interruptedException);
        }
    }
}

