/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelConfig;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.kqueue.KQueueChannelConfig;
import io.netty.channel.unix.PreferredDirectByteBufAllocator;
import io.netty.util.UncheckedBooleanSupplier;

final class KQueueRecvByteAllocatorHandle
extends RecvByteBufAllocator.DelegatingHandle
implements RecvByteBufAllocator.ExtendedHandle {
    private final PreferredDirectByteBufAllocator preferredDirectByteBufAllocator = new PreferredDirectByteBufAllocator();
    private final UncheckedBooleanSupplier defaultMaybeMoreDataSupplier = new UncheckedBooleanSupplier(){

        public boolean get() {
            return KQueueRecvByteAllocatorHandle.this.maybeMoreDataToRead();
        }
    };
    private boolean overrideGuess;
    private boolean readEOF;
    private long numberBytesPending;

    KQueueRecvByteAllocatorHandle(RecvByteBufAllocator.ExtendedHandle extendedHandle) {
        super((RecvByteBufAllocator.Handle)extendedHandle);
    }

    public final int guess() {
        if (this.overrideGuess) {
            return this.guess0();
        }
        return this.delegate().guess();
    }

    public final void reset(ChannelConfig channelConfig) {
        this.overrideGuess = ((KQueueChannelConfig)channelConfig).getRcvAllocTransportProvidesGuess();
        this.delegate().reset(channelConfig);
    }

    public final ByteBuf allocate(ByteBufAllocator byteBufAllocator) {
        this.preferredDirectByteBufAllocator.updateAllocator(byteBufAllocator);
        if (this.overrideGuess) {
            return this.preferredDirectByteBufAllocator.ioBuffer(this.guess0());
        }
        return this.delegate().allocate((ByteBufAllocator)this.preferredDirectByteBufAllocator);
    }

    public final void lastBytesRead(int n) {
        this.numberBytesPending = n < 0 ? 0L : Math.max(0L, this.numberBytesPending - (long)n);
        this.delegate().lastBytesRead(n);
    }

    public final boolean continueReading(UncheckedBooleanSupplier uncheckedBooleanSupplier) {
        return ((RecvByteBufAllocator.ExtendedHandle)this.delegate()).continueReading(uncheckedBooleanSupplier);
    }

    public final boolean continueReading() {
        KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle = this;
        return kQueueRecvByteAllocatorHandle.continueReading(kQueueRecvByteAllocatorHandle.defaultMaybeMoreDataSupplier);
    }

    final void readEOF() {
        this.readEOF = true;
    }

    final boolean isReadEOF() {
        return this.readEOF;
    }

    final void numberBytesPending(long l) {
        this.numberBytesPending = l;
    }

    final boolean maybeMoreDataToRead() {
        return this.numberBytesPending != 0L;
    }

    private int guess0() {
        return (int)Math.min(this.numberBytesPending, Integer.MAX_VALUE);
    }
}

