/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.ArcSplineKt;
import androidx.compose.animation.core.internal.ArraysKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005R\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/animation/core/ArcSpline;", "", "arcModes", "", "timePoints", "", "y", "", "<init>", "([I[F[[F)V", "arcs", "Landroidx/compose/animation/core/ArcSpline$Arc;", "[[Landroidx/compose/animation/core/ArcSpline$Arc;", "isExtrapolate", "", "getPos", "", "time", "", "v", "getSlope", "Arc", "animation-core"})
public final class ArcSpline {
    private final Arc[][] arcs;
    private final boolean isExtrapolate;
    public static final int $stable = 8;

    public ArcSpline(int[] nArray, float[] fArray, float[][] fArray2) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray2, (String)"");
        this.isExtrapolate = true;
        int n = 1;
        int n2 = 1;
        int n3 = fArray.length - 1;
        Arc[][] arcArrayArray = new Arc[n3][];
        ArcSpline arcSpline = this;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            switch (nArray[n4]) {
                case 1: {
                    n = 1;
                    n2 = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    n2 = 2;
                    break;
                }
                case 3: {
                    n = n2 == 1 ? 2 : 1;
                    n2 = n;
                    break;
                }
                case 0: {
                    n = 3;
                    break;
                }
                case 5: {
                    n = 5;
                    break;
                }
                case 4: {
                    n = 4;
                }
            }
            float[] fArray3 = fArray2[n4];
            float[] fArray4 = fArray2[n4 + 1];
            float f = fArray[n4];
            float f2 = fArray[n4 + 1];
            int n5 = fArray3.length / 2 + fArray3.length % 2;
            Arc[] arcArray = new Arc[n5];
            int n6 = n4;
            Arc[][] arcArrayArray2 = arcArrayArray;
            for (int i3 = 0; i3 < n5; ++i3) {
                int n7;
                int n8 = n7 = i3;
                n7 = n8 << 1;
                arcArray[n8] = new Arc(n, f, f2, fArray3[n7], fArray3[n7 + 1], fArray4[n7], fArray4[n7 + 1]);
            }
            arcArrayArray2[n6] = arcArray;
        }
        arcSpline.arcs = arcArrayArray;
    }

    public final void getPos(float f, float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        float f2 = f;
        Arc[][] arcArray = this.arcs;
        int n = ((Object[])this.arcs).length - 1;
        float f3 = arcArray[0][0].getTime1();
        float f4 = arcArray[n][0].getTime2();
        int n2 = fArray.length;
        if (this.isExtrapolate) {
            if (f < f3 || f > f4) {
                if (f > f4) {
                    f3 = f4;
                } else {
                    n = 0;
                }
                f -= f3;
                int n3 = 0;
                int n4 = 0;
                while (n3 < n2 - 1) {
                    Arc arc;
                    Arc arc2 = arcArray[n][n4];
                    if (arc2.isLinear) {
                        arc = arc2;
                        fArray[n3] = arc2.getLinearX(f3) + f * arc.ellipseCenterX;
                        arc = arc2;
                        fArray[n3 + 1] = arc2.getLinearY(f3) + f * arc.ellipseCenterY;
                    } else {
                        arc2.setPoint(f3);
                        arc = arc2;
                        fArray[n3] = arc.ellipseCenterX + arc.ellipseA * arc.tmpSinAngle + f * arc2.calcDX();
                        arc = arc2;
                        fArray[n3 + 1] = arc.ellipseCenterY + arc.ellipseB * arc.tmpCosAngle + f * arc2.calcDY();
                    }
                    n3 += 2;
                    ++n4;
                }
                return;
            }
        } else {
            f2 = Math.max(f, f3);
            f2 = Math.min(f2, f4);
        }
        n = 0;
        int n5 = ((Object[])arcArray).length;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2 - 1) {
                Arc arc = arcArray[i2][n6];
                if (f2 <= arc.getTime2()) {
                    if (arc.isLinear) {
                        fArray[n7] = arc.getLinearX(f2);
                        fArray[n7 + 1] = arc.getLinearY(f2);
                    } else {
                        arc.setPoint(f2);
                        Arc arc3 = arc;
                        fArray[n7] = arc3.ellipseCenterX + arc3.ellipseA * arc3.tmpSinAngle;
                        arc3 = arc;
                        fArray[n7 + 1] = arc3.ellipseCenterY + arc3.ellipseB * arc3.tmpCosAngle;
                    }
                    n = 1;
                }
                n7 += 2;
                ++n6;
            }
            if (n == 0) continue;
            return;
        }
    }

    public final void getSlope(float f, float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Arc[][] arcArray = this.arcs;
        float f2 = f;
        float f3 = arcArray[0][0].getTime1();
        float f4 = arcArray[((Object[])arcArray).length - 1][0].getTime2();
        float f5 = f2 < f3 ? f3 : f2;
        f = f5 > f4 ? f4 : f5;
        int n = fArray.length;
        boolean bl = false;
        int n2 = ((Object[])arcArray).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = 0;
            int n4 = 0;
            while (n3 < n - 1) {
                Arc arc = arcArray[i2][n4];
                if (f <= arc.getTime2()) {
                    if (arc.isLinear) {
                        Arc arc2 = arc;
                        fArray[n3] = arc2.ellipseCenterX;
                        arc2 = arc;
                        fArray[n3 + 1] = arc2.ellipseCenterY;
                    } else {
                        arc.setPoint(f);
                        fArray[n3] = arc.calcDX();
                        fArray[n3 + 1] = arc.calcDY();
                    }
                    bl = true;
                }
                n3 += 2;
                ++n4;
            }
            if (!bl) continue;
            return;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001BA\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005J\u0011\u0010%\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0082\bJ\t\u0010&\u001a\u00020\u0005H\u0086\bJ\t\u0010'\u001a\u00020\u0005H\u0086\bJ\u0006\u0010(\u001a\u00020\u0005J\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005H\u0002J-\u0010.\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b/R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001e\u001a\u00020\u00058\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000eR\u0015\u0010 \u001a\u00020\u00058\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000e\u00a8\u00060"}, d2={"Landroidx/compose/animation/core/ArcSpline$Arc;", "", "mode", "", "time1", "", "time2", "x1", "y1", "x2", "y2", "<init>", "(IFFFFFF)V", "getTime1", "()F", "getTime2", "arcDistance", "tmpSinAngle", "tmpCosAngle", "lut", "", "oneOverDeltaTime", "arcVelocity", "vertical", "ellipseA", "ellipseB", "isLinear", "", "ellipseCenterX", "ellipseCenterY", "linearDX", "getLinearDX$animation_core", "linearDY", "getLinearDY$animation_core", "setPoint", "", "time", "calcAngle", "calcX", "calcY", "calcDX", "calcDY", "getLinearX", "getLinearY", "lookup", "v", "buildTable", "buildTable$animation_core", "animation-core"})
    public static final class Arc {
        private final float time1;
        private final float time2;
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;
        private float arcDistance;
        private float tmpSinAngle;
        private float tmpCosAngle;
        private final float[] lut;
        private final float oneOverDeltaTime;
        private final float arcVelocity;
        private final float vertical;
        public final float ellipseA;
        public final float ellipseB;
        public final boolean isLinear;
        public final float ellipseCenterX;
        public final float ellipseCenterY;
        public static final int $stable = 8;

        public Arc(int n, float f, float f2, float f3, float f4, float f5, float f6) {
            boolean bl;
            this.time1 = f;
            this.time2 = f2;
            this.x1 = f3;
            this.y1 = f4;
            this.x2 = f5;
            this.y2 = f6;
            f = this.x2 - this.x1;
            f2 = this.y2 - this.y1;
            switch (n) {
                case 1: {
                    bl = true;
                    break;
                }
                case 5: {
                    if (f2 < 0.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    if (f2 > 0.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            boolean bl2 = bl;
            this.vertical = bl2 ? -1.0f : 1.0f;
            this.oneOverDeltaTime = 1.0f / (this.time2 - this.time1);
            this.lut = new float[101];
            if ((n = n == 3 ? 1 : 0) != 0 || Math.abs(f) < 0.001f || Math.abs(f2) < 0.001f) {
                n = 1;
                this.arcDistance = (float)Math.hypot(f2, f);
                this.arcVelocity = this.arcDistance * this.oneOverDeltaTime;
                this.ellipseCenterX = f * this.oneOverDeltaTime;
                this.ellipseCenterY = f2 * this.oneOverDeltaTime;
                this.ellipseA = Float.NaN;
                this.ellipseB = Float.NaN;
            } else {
                this.ellipseA = f * this.vertical;
                this.ellipseB = f2 * -this.vertical;
                this.ellipseCenterX = bl2 ? this.x2 : this.x1;
                this.ellipseCenterY = bl2 ? this.y1 : this.y2;
                Arc arc = this;
                arc.buildTable$animation_core(arc.x1, this.y1, this.x2, this.y2);
                this.arcVelocity = this.arcDistance * this.oneOverDeltaTime;
            }
            this.isLinear = n;
        }

        public final float getTime1() {
            return this.time1;
        }

        public final float getTime2() {
            return this.time2;
        }

        public final float getLinearDX$animation_core() {
            return this.ellipseCenterX;
        }

        public final float getLinearDY$animation_core() {
            return this.ellipseCenterY;
        }

        public final void setPoint(float f) {
            Arc arc = this;
            f = (arc.vertical == -1.0f ? arc.time2 - f : f - arc.time1) * arc.oneOverDeltaTime;
            f = 1.5707964f * arc.lookup(f);
            this.tmpSinAngle = (float)Math.sin(f);
            this.tmpCosAngle = (float)Math.cos(f);
        }

        private final float calcAngle(float f) {
            f = (this.vertical == -1.0f ? this.time2 - f : f - this.time1) * this.oneOverDeltaTime;
            return 1.5707964f * this.lookup(f);
        }

        public final float calcX() {
            return this.ellipseCenterX + this.ellipseA * this.tmpSinAngle;
        }

        public final float calcY() {
            return this.ellipseCenterY + this.ellipseB * this.tmpCosAngle;
        }

        public final float calcDX() {
            float f = this.ellipseA * this.tmpCosAngle;
            float f2 = -this.ellipseB * this.tmpSinAngle;
            f2 = this.arcVelocity / (float)Math.hypot(f, f2);
            return f * this.vertical * f2;
        }

        public final float calcDY() {
            float f = this.ellipseA * this.tmpCosAngle;
            float f2 = -this.ellipseB * this.tmpSinAngle;
            f = this.arcVelocity / (float)Math.hypot(f, f2);
            return f2 * this.vertical * f;
        }

        public final float getLinearX(float f) {
            f = (f - this.time1) * this.oneOverDeltaTime;
            return this.x1 + f * (this.x2 - this.x1);
        }

        public final float getLinearY(float f) {
            f = (f - this.time1) * this.oneOverDeltaTime;
            return this.y1 + f * (this.y2 - this.y1);
        }

        private final float lookup(float f) {
            if (f <= 0.0f) {
                return 0.0f;
            }
            if (f >= 1.0f) {
                return 1.0f;
            }
            int n = (int)(f *= 100.0f);
            return this.lut[n] + (f -= (float)n) * (this.lut[n + 1] - this.lut[n]);
        }

        public final void buildTable$animation_core(float f, float f2, float f3, float f4) {
            float f5;
            f = f3 - f;
            f2 -= f4;
            f3 = 0.0f;
            f4 = f2;
            float f6 = 0.0f;
            float[] fArray = ArcSplineKt.access$getOurPercentCache$p();
            int n = fArray.length - 1;
            float f7 = n;
            float[] fArray2 = this.lut;
            int n2 = 1;
            if (n > 0) {
                while (true) {
                    double d2 = 90.0 * (double)n2 / (double)n;
                    float f8 = (float)(d2 * (Math.PI / 180));
                    float f9 = (float)Math.sin(f8);
                    f5 = (float)Math.cos(f8);
                    float f10 = f * f9;
                    float f11 = f2 * f5;
                    fArray[n2] = f6 += (float)Math.hypot(f10 - f3, f11 - f4);
                    f3 = f10;
                    f4 = f11;
                    if (n2 == n) break;
                    ++n2;
                }
            }
            this.arcDistance = f6;
            n2 = 1;
            if (n > 0) {
                do {
                    int n3 = ++n2;
                    fArray[n3] = fArray[n3] / f6;
                } while (n2 != n);
            }
            int n4 = fArray2.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                f5 = (float)i2 / 100.0f;
                int n5 = ArraysKt.binarySearch$default(fArray, f5, 0, 0, 6, null);
                if (n5 >= 0) {
                    fArray2[i2] = (float)n5 / f7;
                    continue;
                }
                if (n5 == -1) {
                    fArray2[i2] = 0.0f;
                    continue;
                }
                int n6 = -n5 - 2;
                int n7 = -n5 - 1;
                fArray2[i2] = f = ((float)n6 + (f5 - fArray[n6]) / (fArray[n7] - fArray[n6])) / f7;
            }
        }
    }
}

