/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.FloatAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0011\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0082\bJ \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/compose/animation/core/FloatTweenSpec;", "Landroidx/compose/animation/core/FloatAnimationSpec;", "duration", "", "delay", "easing", "Landroidx/compose/animation/core/Easing;", "<init>", "(IILandroidx/compose/animation/core/Easing;)V", "getDuration", "()I", "getDelay", "durationNanos", "", "delayNanos", "getValueFromNanos", "", "playTimeNanos", "initialValue", "targetValue", "initialVelocity", "clampPlayTimeNanos", "getDurationNanos", "getVelocityFromNanos", "animation-core"})
public final class FloatTweenSpec
implements FloatAnimationSpec {
    private final int duration;
    private final int delay;
    private final Easing easing;
    private final long durationNanos;
    private final long delayNanos;
    public static final int $stable;

    public FloatTweenSpec(int n, int n2, Easing easing) {
        Intrinsics.checkNotNullParameter((Object)easing, (String)"");
        this.duration = n;
        this.delay = n2;
        this.easing = easing;
        this.durationNanos = (long)this.duration * 1000000L;
        this.delayNanos = (long)this.delay * 1000000L;
    }

    public /* synthetic */ FloatTweenSpec(int n, int n2, Easing easing, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 300;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            easing = EasingKt.getFastOutSlowInEasing();
        }
        this(n, n2, easing);
    }

    public final int getDuration() {
        return this.duration;
    }

    public final int getDelay() {
        return this.delay;
    }

    @Override
    public final float getValueFromNanos(long l2, float f, float f2, float f3) {
        FloatTweenSpec floatTweenSpec = this;
        long l3 = l2 - floatTweenSpec.delayNanos;
        long l4 = floatTweenSpec.durationNanos;
        long l5 = l3 < 0L ? 0L : l3;
        long l6 = l5 > l4 ? l4 : l5;
        float f4 = this.duration == 0 ? 1.0f : (float)l6 / (float)this.durationNanos;
        float f5 = this.easing.transform(f4);
        return f * (1.0f - f5) + f2 * f5;
    }

    private final long clampPlayTimeNanos(long l2) {
        long l3;
        long l4 = l2 - this.delayNanos;
        long l5 = l4 < 0L ? 0L : l4;
        if (l5 > (l3 = this.durationNanos)) {
            return l3;
        }
        return l5;
    }

    @Override
    public final long getDurationNanos(float f, float f2, float f3) {
        return this.delayNanos + this.durationNanos;
    }

    @Override
    public final float getVelocityFromNanos(long l2, float f, float f2, float f3) {
        long l3;
        FloatTweenSpec floatTweenSpec = this;
        long l4 = l2 - floatTweenSpec.delayNanos;
        long l5 = l4 < 0L ? 0L : l4;
        long l6 = l5 > (l3 = floatTweenSpec.durationNanos) ? l3 : l5;
        if (l6 == 0L) {
            return f3;
        }
        float f4 = this.getValueFromNanos(l6 - 1000000L, f, f2, f3);
        float f5 = this.getValueFromNanos(l6, f, f2, f3);
        return (f5 - f4) * 1000.0f;
    }

    public FloatTweenSpec() {
        this(0, 0, null, 7, null);
    }
}

