/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.MonoSplineKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0011J \u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J \u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/compose/animation/core/MonoSpline;", "", "time", "", "y", "", "periodicBias", "", "<init>", "([F[[FF)V", "timePoints", "values", "[[F", "tangents", "slopeTemp", "makeFloatArray", "a", "", "b", "(II)[[F", "getPos", "t", "j", "", "v", "Landroidx/compose/animation/core/AnimationVector;", "index", "getSlope", "animation-core"})
public final class MonoSpline {
    private final float[] timePoints;
    private final float[][] values;
    private final float[][] tangents;
    private final float[] slopeTemp;
    public static final int $stable = 8;

    public MonoSpline(float[] fArray, float[][] fArray2, float f2) {
        float f3;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray2, (String)"");
        int n3 = fArray.length;
        int n4 = fArray2[0].length;
        this.slopeTemp = new float[n4];
        float[][] fArray3 = this.makeFloatArray(n3 - 1, n4);
        float[][] fArray4 = this.makeFloatArray(n3, n4);
        for (n2 = 0; n2 < n4; ++n2) {
            n = n3 - 1;
            for (int i2 = 0; i2 < n; ++i2) {
                f3 = fArray[i2 + 1] - fArray[i2];
                fArray3[i2][n2] = (fArray2[i2 + 1][n2] - fArray2[i2][n2]) / f3;
                fArray4[i2][n2] = i2 == 0 ? fArray3[i2][n2] : (fArray3[i2 - 1][n2] + fArray3[i2][n2]) * 0.5f;
            }
            fArray4[n][n2] = fArray3[n3 - 2][n2];
        }
        if (!Float.isNaN(f2)) {
            for (n2 = 0; n2 < n4; ++n2) {
                float f4;
                fArray3[0][n2] = f4 = fArray3[n3 - 2][n2] * (1.0f - f2) + fArray3[0][n2] * f2;
                fArray3[n3 - 2][n2] = f4;
                fArray4[n3 - 1][n2] = f4;
                fArray4[0][n2] = f4;
            }
        }
        int n5 = n3 - 1;
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n4; ++n) {
                float f5;
                if (fArray3[n2][n] == 0.0f) {
                    fArray4[n2][n] = 0.0f;
                    fArray4[n2 + 1][n] = 0.0f;
                    continue;
                }
                f3 = fArray4[n2][n] / fArray3[n2][n];
                f2 = fArray4[n2 + 1][n] / fArray3[n2][n];
                float f6 = (float)Math.hypot(f3, f2);
                if (!((double)f5 > 9.0)) continue;
                f6 = 3.0f / f6;
                fArray4[n2][n] = f6 * f3 * fArray3[n2][n];
                fArray4[n2 + 1][n] = f6 * f2 * fArray3[n2][n];
            }
        }
        this.timePoints = fArray;
        this.values = fArray2;
        this.tangents = fArray4;
    }

    private final float[][] makeFloatArray(int n, int n2) {
        int n3 = 0;
        float[][] fArrayArray = new float[n][];
        while (n3 < n) {
            int n4 = n3++;
            fArrayArray[n4] = new float[n2];
        }
        return fArrayArray;
    }

    public final float getPos(float f2, int n) {
        int n2;
        float[][] fArray = this.values;
        float[][] fArray2 = this.tangents;
        int n3 = this.timePoints.length;
        if ((f2 <= this.timePoints[0] ? 0 : (n2 = f2 >= this.timePoints[n3 - 1] ? n3 - 1 : -1)) != -1) {
            MonoSpline monoSpline = this;
            return fArray[n2][n] + (f2 - this.timePoints[n2]) * monoSpline.getSlope(monoSpline.timePoints[n2], n);
        }
        --n3;
        for (n2 = 0; n2 < n3; ++n2) {
            if (f2 == this.timePoints[n2]) {
                return fArray[n2][n];
            }
            if (!(f2 < this.timePoints[n2 + 1])) continue;
            float f3 = this.timePoints[n2 + 1] - this.timePoints[n2];
            f2 = (f2 - this.timePoints[n2]) / f3;
            float f4 = fArray[n2][n];
            float f5 = fArray[n2 + 1][n];
            float f6 = fArray2[n2][n];
            float f7 = fArray2[n2 + 1][n];
            return MonoSplineKt.hermiteInterpolate(f3, f2, f4, f5, f6, f7);
        }
        return 0.0f;
    }

    public final void getPos(float f2, AnimationVector animationVector, int n) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)animationVector, (String)"");
        int n3 = this.timePoints.length;
        int n4 = this.values[0].length;
        if ((f2 <= this.timePoints[0] ? 0 : (n2 = f2 >= this.timePoints[n3 - 1] ? n3 - 1 : -1)) != -1) {
            MonoSpline monoSpline = this;
            monoSpline.getSlope(monoSpline.timePoints[n2], this.slopeTemp);
            for (n = 0; n < n4; ++n) {
                animationVector.set$animation_core(n, this.values[n2][n] + (f2 - this.timePoints[n2]) * this.slopeTemp[n]);
            }
            return;
        }
        --n3;
        while (n < n3) {
            if (f2 == this.timePoints[n]) {
                for (n3 = 0; n3 < n4; ++n3) {
                    animationVector.set$animation_core(n3, this.values[n][n3]);
                }
                return;
            }
            if (f2 < this.timePoints[n + 1]) {
                float f3 = this.timePoints[n + 1] - this.timePoints[n];
                f2 = (f2 - this.timePoints[n]) / f3;
                for (n2 = 0; n2 < n4; ++n2) {
                    float f4 = this.values[n][n2];
                    float f5 = this.values[n + 1][n2];
                    float f6 = this.tangents[n][n2];
                    float f7 = this.tangents[n + 1][n2];
                    animationVector.set$animation_core(n2, MonoSplineKt.hermiteInterpolate(f3, f2, f4, f5, f6, f7));
                }
                return;
            }
            ++n;
        }
    }

    public static /* synthetic */ void getPos$default(MonoSpline monoSpline, float f2, AnimationVector animationVector, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        monoSpline.getPos(f2, animationVector, n);
    }

    private final void getSlope(float f2, float[] fArray) {
        int n = this.values[0].length;
        int n2 = this.timePoints.length;
        float f3 = f2;
        float f4 = this.timePoints[0];
        float f5 = this.timePoints[n2 - 1];
        f4 = f3 < f4 ? f4 : f3;
        float f6 = f2 = f4 > f5 ? f5 : f4;
        if (fArray.length < n) {
            return;
        }
        int n3 = n2 - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!(f2 <= this.timePoints[i2 + 1])) continue;
            f5 = this.timePoints[i2 + 1] - this.timePoints[i2];
            f2 = (f2 - this.timePoints[i2]) / f5;
            for (n3 = 0; n3 < n; ++n3) {
                float f7 = this.values[i2][n3];
                float f8 = this.values[i2 + 1][n3];
                float f9 = this.tangents[i2][n3];
                float f10 = this.tangents[i2 + 1][n3];
                fArray[n3] = MonoSplineKt.hermiteDifferential(f5, f2, f7, f8, f9, f10) / f5;
            }
            return;
        }
    }

    public final void getSlope(float f2, AnimationVector animationVector, int n) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)animationVector, (String)"");
        float[] fArray = this.timePoints;
        float[][] fArray2 = this.values;
        float[][] fArray3 = this.tangents;
        int n3 = fArray.length;
        int n4 = fArray2[0].length;
        if ((f2 <= fArray[0] ? 0 : (n2 = f2 >= fArray[n3 - 1] ? n3 - 1 : -1)) != -1) {
            float[] fArray4 = fArray3[n2];
            if (fArray4.length < n4) {
                return;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                animationVector.set$animation_core(n3, fArray4[n3]);
            }
            return;
        }
        --n3;
        while (n < n3) {
            if (f2 <= fArray[n + 1]) {
                float f3 = fArray[n + 1] - fArray[n];
                f2 = (f2 - fArray[n]) / f3;
                for (int i2 = 0; i2 < n4; ++i2) {
                    float f4 = fArray2[n][i2];
                    float f5 = fArray2[n + 1][i2];
                    float f6 = fArray3[n][i2];
                    float f7 = fArray3[n + 1][i2];
                    animationVector.set$animation_core(i2, MonoSplineKt.hermiteDifferential(f3, f2, f4, f5, f6, f7) / f3);
                }
                return;
            }
            ++n;
        }
    }

    public static /* synthetic */ void getSlope$default(MonoSpline monoSpline, float f2, AnimationVector animationVector, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        monoSpline.getSlope(f2, animationVector, n);
    }

    private final float getSlope(float f2, int n) {
        float[] fArray = this.timePoints;
        float[][] fArray2 = this.values;
        float[][] fArray3 = this.tangents;
        int n2 = fArray.length;
        float f3 = f2;
        float f4 = fArray[0];
        float f5 = fArray[n2 - 1];
        f4 = f3 < f4 ? f4 : f3;
        f2 = f4 > f5 ? f5 : f4;
        int n3 = n2 - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!(f2 <= fArray[i2 + 1])) continue;
            f5 = fArray2[i2][n];
            float f6 = fArray2[i2 + 1][n];
            float f7 = fArray3[i2][n];
            float f8 = fArray3[i2 + 1][n];
            float f9 = fArray[i2 + 1] - fArray[i2];
            f2 = (f2 - fArray[i2]) / f9;
            return MonoSplineKt.hermiteDifferential(f9, f2, f5, f6, f7, f8) / f9;
        }
        return 0.0f;
    }
}

