/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.Parser;
import ch.qos.logback.core.subst.Token;
import ch.qos.logback.core.subst.Tokenizer;
import ch.qos.logback.core.util.OptionHelper;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class NodeToStringTransformer {
    public static final String CIRCULAR_VARIABLE_REFERENCE_DETECTED = "Circular variable reference detected while parsing input [";
    final Node node;
    final PropertyContainer propertyContainer0;
    final PropertyContainer propertyContainer1;

    public NodeToStringTransformer(Node node, PropertyContainer propertyContainer, PropertyContainer propertyContainer2) {
        this.node = node;
        this.propertyContainer0 = propertyContainer;
        this.propertyContainer1 = propertyContainer2;
    }

    public NodeToStringTransformer(Node node, PropertyContainer propertyContainer) {
        this(node, propertyContainer, null);
    }

    public static String substituteVariable(String object, PropertyContainer propertyContainer, PropertyContainer propertyContainer2) {
        object = NodeToStringTransformer.tokenizeAndParseString((String)object);
        object = new NodeToStringTransformer((Node)object, propertyContainer, propertyContainer2);
        return ((NodeToStringTransformer)object).transform();
    }

    private static Node tokenizeAndParseString(String object) {
        object = new Tokenizer((String)object);
        object = ((Tokenizer)object).tokenize();
        object = new Parser((List<Token>)object);
        return ((Parser)object).parse();
    }

    public String transform() {
        StringBuilder stringBuilder = new StringBuilder();
        NodeToStringTransformer nodeToStringTransformer = this;
        nodeToStringTransformer.compileNode(nodeToStringTransformer.node, stringBuilder, new Stack<Node>());
        return stringBuilder.toString();
    }

    private void compileNode(Node node, StringBuilder stringBuilder, Stack<Node> stack) {
        while (node != null) {
            switch (node.type) {
                case LITERAL: {
                    this.handleLiteral(node, stringBuilder);
                    break;
                }
                case VARIABLE: {
                    this.handleVariable(node, stringBuilder, stack);
                }
            }
            node = node.next;
        }
    }

    private void handleVariable(Node object, StringBuilder stringBuilder, Stack<Node> stack) {
        if (this.haveVisitedNodeAlready((Node)object, stack)) {
            stack.push((Node)object);
            String string = this.constructRecursionErrorMessage(stack);
            throw new IllegalArgumentException(string);
        }
        stack.push((Node)object);
        CharSequence charSequence = new StringBuilder();
        Object object2 = (Node)((Node)object).payload;
        this.compileNode((Node)object2, (StringBuilder)charSequence, stack);
        charSequence = ((StringBuilder)charSequence).toString();
        object2 = this.lookupKey((String)charSequence);
        if (object2 != null) {
            object = NodeToStringTransformer.tokenizeAndParseString((String)object2);
            this.compileNode((Node)object, stringBuilder, stack);
            stack.pop();
            return;
        }
        if (((Node)object).defaultPart == null) {
            stringBuilder.append((String)charSequence + "_IS_UNDEFINED");
            stack.pop();
            return;
        }
        object = (Node)((Node)object).defaultPart;
        charSequence = new StringBuilder();
        this.compileNode((Node)object, (StringBuilder)charSequence, stack);
        stack.pop();
        object = ((StringBuilder)charSequence).toString();
        stringBuilder.append((String)object);
    }

    private String lookupKey(String string) {
        String string2 = this.propertyContainer0.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        if (this.propertyContainer1 != null && (string2 = this.propertyContainer1.getProperty(string)) != null) {
            return string2;
        }
        string2 = OptionHelper.getSystemProperty(string, null);
        if (string2 != null) {
            return string2;
        }
        string2 = OptionHelper.getEnv(string);
        if (string2 != null) {
            return string2;
        }
        return null;
    }

    private void handleLiteral(Node node, StringBuilder stringBuilder) {
        stringBuilder.append((String)node.payload);
    }

    private String variableNodeValue(Node node) {
        node = (Node)node.payload;
        if (node == null) {
            return "";
        }
        if (node.type == Node.Type.LITERAL) {
            return (String)node.payload;
        }
        if (node.type == Node.Type.VARIABLE) {
            return " ? " + this.variableNodeValue(node);
        }
        throw new IllegalStateException("unreachable code");
    }

    private String constructRecursionErrorMessage(Stack<Node> stack) {
        StringBuilder stringBuilder = new StringBuilder(CIRCULAR_VARIABLE_REFERENCE_DETECTED);
        for (Node node : stack) {
            stringBuilder.append("${").append(this.variableNodeValue(node)).append("}");
            if (stack.lastElement() == node) continue;
            stringBuilder.append(" --> ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private boolean haveVisitedNodeAlready(Node node, Stack<Node> object) {
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            Node node2 = (Node)object.next();
            if (!this.equalNodes(node, node2)) continue;
            return true;
        }
        return false;
    }

    private boolean equalNodes(Node node, Node node2) {
        if (node.type != null && !node.type.equals((Object)node2.type)) {
            return false;
        }
        if (node.payload != null && !node.payload.equals(node2.payload)) {
            return false;
        }
        return node.defaultPart == null || node.defaultPart.equals(node2.defaultPart);
    }
}

