/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.http.cookie.CookieUtil;

public abstract class CookieEncoder {
    protected final boolean strict;

    protected CookieEncoder(boolean bl) {
        this.strict = bl;
    }

    protected void validateCookie(String charSequence, String string) {
        if (this.strict) {
            int n = CookieUtil.firstInvalidCookieNameOctet(charSequence);
            if (n >= 0) {
                throw new IllegalArgumentException("Cookie name contains an invalid char: " + ((String)charSequence).charAt(n));
            }
            charSequence = CookieUtil.unwrapValue(string);
            if (charSequence == null) {
                throw new IllegalArgumentException("Cookie value wrapping quotes are not balanced: " + string);
            }
            n = CookieUtil.firstInvalidCookieValueOctet(charSequence);
            if (n >= 0) {
                throw new IllegalArgumentException("Cookie value contains an invalid char: " + charSequence.charAt(n));
            }
        }
    }
}

