/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.rtsp;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.rtsp.RtspHeaderNames;
import io.netty.handler.codec.rtsp.RtspMethods;
import io.netty.handler.codec.rtsp.RtspVersions;
import java.util.regex.Pattern;

public class RtspDecoder
extends HttpObjectDecoder {
    private static final HttpResponseStatus UNKNOWN_STATUS = new HttpResponseStatus(999, "Unknown");
    private boolean isDecodingRequest;
    private static final Pattern versionPattern = Pattern.compile("RTSP/\\d\\.\\d");
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 8192;

    public RtspDecoder() {
        this(4096, 8192, 8192);
    }

    public RtspDecoder(int n, int n2, int n3) {
        super(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3 << 1).setChunkedSupported(false));
    }

    @Deprecated
    public RtspDecoder(int n, int n2, int n3, boolean bl) {
        super(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3 << 1).setChunkedSupported(false).setValidateHeaders(bl));
    }

    public RtspDecoder(HttpDecoderConfig httpDecoderConfig) {
        super(httpDecoderConfig.clone().setMaxChunkSize(2 * httpDecoderConfig.getMaxChunkSize()).setChunkedSupported(false));
    }

    @Override
    protected HttpMessage createMessage(String[] stringArray) {
        if (versionPattern.matcher(stringArray[0]).matches()) {
            this.isDecodingRequest = false;
            return new DefaultHttpResponse(RtspVersions.valueOf(stringArray[0]), new HttpResponseStatus(Integer.parseInt(stringArray[1]), stringArray[2]), this.headersFactory);
        }
        this.isDecodingRequest = true;
        return new DefaultHttpRequest(RtspVersions.valueOf(stringArray[2]), RtspMethods.valueOf(stringArray[0]), stringArray[1], this.headersFactory);
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
        return super.isContentAlwaysEmpty(httpMessage) || !httpMessage.headers().contains((CharSequence)RtspHeaderNames.CONTENT_LENGTH);
    }

    @Override
    protected HttpMessage createInvalidMessage() {
        if (this.isDecodingRequest) {
            return new DefaultFullHttpRequest(RtspVersions.RTSP_1_0, RtspMethods.OPTIONS, "/bad-request", Unpooled.buffer((int)0), this.headersFactory, this.trailersFactory);
        }
        return new DefaultFullHttpResponse(RtspVersions.RTSP_1_0, UNKNOWN_STATUS, Unpooled.buffer((int)0), this.headersFactory, this.trailersFactory);
    }

    @Override
    protected boolean isDecodingRequest() {
        return this.isDecodingRequest;
    }
}

