/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyGoAwayFrame;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyPingFrame;
import io.netty.handler.codec.spdy.SpdyProtocolException;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdySession;
import io.netty.handler.codec.spdy.SpdySessionStatus;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.handler.codec.spdy.SpdyWindowUpdateFrame;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class SpdySessionHandler
extends ChannelDuplexHandler {
    private static final SpdyProtocolException PROTOCOL_EXCEPTION = SpdyProtocolException.newStatic(null, SpdySessionHandler.class, "handleOutboundMessage(...)");
    private static final SpdyProtocolException STREAM_CLOSED = SpdyProtocolException.newStatic("Stream closed", SpdySessionHandler.class, "removeStream(...)");
    private static final int DEFAULT_WINDOW_SIZE = 65536;
    private int initialSendWindowSize = 65536;
    private int initialReceiveWindowSize = 65536;
    private volatile int initialSessionReceiveWindowSize = 65536;
    private final SpdySession spdySession = new SpdySession(this.initialSendWindowSize, this.initialReceiveWindowSize);
    private int lastGoodStreamId;
    private static final int DEFAULT_MAX_CONCURRENT_STREAMS = Integer.MAX_VALUE;
    private int remoteConcurrentStreams = Integer.MAX_VALUE;
    private int localConcurrentStreams = Integer.MAX_VALUE;
    private final AtomicInteger pings = new AtomicInteger();
    private boolean sentGoAwayFrame;
    private boolean receivedGoAwayFrame;
    private ChannelFutureListener closeSessionFutureListener;
    private final boolean server;
    private final int minorVersion;

    public SpdySessionHandler(SpdyVersion spdyVersion, boolean bl) {
        this.minorVersion = ((SpdyVersion)((Object)ObjectUtil.checkNotNull((Object)((Object)spdyVersion), (String)"version"))).minorVersion();
        this.server = bl;
    }

    public void setSessionReceiveWindowSize(int n) {
        ObjectUtil.checkPositiveOrZero((int)n, (String)"sessionReceiveWindowSize");
        this.initialSessionReceiveWindowSize = n;
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof SpdyDataFrame) {
            int n;
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)object;
            int n2 = spdyDataFrame.streamId();
            int n3 = -1 * spdyDataFrame.content().readableBytes();
            int n4 = this.spdySession.updateReceiveWindowSize(0, n3);
            if (n4 < 0) {
                this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            if (n4 <= this.initialSessionReceiveWindowSize / 2) {
                n = this.initialSessionReceiveWindowSize - n4;
                this.spdySession.updateReceiveWindowSize(0, n);
                DefaultSpdyWindowUpdateFrame defaultSpdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(0, n);
                channelHandlerContext.writeAndFlush((Object)defaultSpdyWindowUpdateFrame);
            }
            if (!this.spdySession.isActiveStream(n2)) {
                spdyDataFrame.release();
                if (n2 <= this.lastGoodStreamId) {
                    this.issueStreamError(channelHandlerContext, n2, SpdyStreamStatus.PROTOCOL_ERROR);
                    return;
                }
                if (!this.sentGoAwayFrame) {
                    this.issueStreamError(channelHandlerContext, n2, SpdyStreamStatus.INVALID_STREAM);
                }
                return;
            }
            if (this.spdySession.isRemoteSideClosed(n2)) {
                spdyDataFrame.release();
                this.issueStreamError(channelHandlerContext, n2, SpdyStreamStatus.STREAM_ALREADY_CLOSED);
                return;
            }
            if (!this.isRemoteInitiatedId(n2) && !this.spdySession.hasReceivedReply(n2)) {
                spdyDataFrame.release();
                this.issueStreamError(channelHandlerContext, n2, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            n = this.spdySession.updateReceiveWindowSize(n2, n3);
            if (n < this.spdySession.getReceiveWindowSizeLowerBound(n2)) {
                spdyDataFrame.release();
                this.issueStreamError(channelHandlerContext, n2, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                return;
            }
            if (n < 0) {
                while (spdyDataFrame.content().readableBytes() > this.initialReceiveWindowSize) {
                    DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(n2, spdyDataFrame.content().readRetainedSlice(this.initialReceiveWindowSize));
                    channelHandlerContext.writeAndFlush((Object)defaultSpdyDataFrame);
                }
            }
            if (n <= this.initialReceiveWindowSize / 2 && !spdyDataFrame.isLast()) {
                n4 = this.initialReceiveWindowSize - n;
                this.spdySession.updateReceiveWindowSize(n2, n4);
                DefaultSpdyWindowUpdateFrame defaultSpdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(n2, n4);
                channelHandlerContext.writeAndFlush((Object)defaultSpdyWindowUpdateFrame);
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(n2, true, channelHandlerContext.newSucceededFuture());
            }
        } else if (object instanceof SpdySynStreamFrame) {
            boolean bl;
            boolean bl2;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)object;
            int n = spdySynStreamFrame.streamId();
            if (spdySynStreamFrame.isInvalid() || !this.isRemoteInitiatedId(n) || this.spdySession.isActiveStream(n)) {
                this.issueStreamError(channelHandlerContext, n, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (n <= this.lastGoodStreamId) {
                this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            byte by = spdySynStreamFrame.priority();
            if (!this.acceptStream(n, by, bl2 = spdySynStreamFrame.isLast(), bl = spdySynStreamFrame.isUnidirectional())) {
                this.issueStreamError(channelHandlerContext, n, SpdyStreamStatus.REFUSED_STREAM);
                return;
            }
        } else if (object instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)object;
            int n = spdySynReplyFrame.streamId();
            if (spdySynReplyFrame.isInvalid() || this.isRemoteInitiatedId(n) || this.spdySession.isRemoteSideClosed(n)) {
                this.issueStreamError(channelHandlerContext, n, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (this.spdySession.hasReceivedReply(n)) {
                this.issueStreamError(channelHandlerContext, n, SpdyStreamStatus.STREAM_IN_USE);
                return;
            }
            this.spdySession.receivedReply(n);
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(n, true, channelHandlerContext.newSucceededFuture());
            }
        } else if (object instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)object;
            this.removeStream(spdyRstStreamFrame.streamId(), channelHandlerContext.newSucceededFuture());
        } else if (object instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)object;
            int n = spdySettingsFrame.getValue(0);
            if (n >= 0 && n != this.minorVersion) {
                this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            int n5 = spdySettingsFrame.getValue(4);
            if (n5 >= 0) {
                this.remoteConcurrentStreams = n5;
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            int n6 = spdySettingsFrame.getValue(7);
            if (n6 >= 0) {
                this.updateInitialSendWindowSize(n6);
            }
        } else if (object instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)object;
            if (this.isRemoteInitiatedId(spdyPingFrame.id())) {
                channelHandlerContext.writeAndFlush((Object)spdyPingFrame);
                return;
            }
            if (this.pings.get() == 0) {
                return;
            }
            this.pings.getAndDecrement();
        } else if (object instanceof SpdyGoAwayFrame) {
            this.receivedGoAwayFrame = true;
        } else if (object instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)object;
            int n = spdyHeadersFrame.streamId();
            if (spdyHeadersFrame.isInvalid()) {
                this.issueStreamError(channelHandlerContext, n, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (this.spdySession.isRemoteSideClosed(n)) {
                this.issueStreamError(channelHandlerContext, n, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (spdyHeadersFrame.isLast()) {
                this.halfCloseStream(n, true, channelHandlerContext.newSucceededFuture());
            }
        } else if (object instanceof SpdyWindowUpdateFrame) {
            SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)object;
            int n = spdyWindowUpdateFrame.streamId();
            int n7 = spdyWindowUpdateFrame.deltaWindowSize();
            if (n != 0 && this.spdySession.isLocalSideClosed(n)) {
                return;
            }
            if (this.spdySession.getSendWindowSize(n) > Integer.MAX_VALUE - n7) {
                if (n == 0) {
                    this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
                    return;
                }
                this.issueStreamError(channelHandlerContext, n, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                return;
            }
            this.updateSendWindowSize(channelHandlerContext, n, n7);
        }
        channelHandlerContext.fireChannelRead(object);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        for (Integer n : this.spdySession.activeStreams().keySet()) {
            this.removeStream(n, channelHandlerContext.newSucceededFuture());
        }
        channelHandlerContext.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof SpdyProtocolException) {
            this.issueSessionError(channelHandlerContext, SpdySessionStatus.PROTOCOL_ERROR);
        }
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.sendGoAwayFrame(channelHandlerContext, channelPromise);
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof SpdyDataFrame || object instanceof SpdySynStreamFrame || object instanceof SpdySynReplyFrame || object instanceof SpdyRstStreamFrame || object instanceof SpdySettingsFrame || object instanceof SpdyPingFrame || object instanceof SpdyGoAwayFrame || object instanceof SpdyHeadersFrame || object instanceof SpdyWindowUpdateFrame) {
            this.handleOutboundMessage(channelHandlerContext, object, channelPromise);
            return;
        }
        channelHandlerContext.write(object, channelPromise);
    }

    private void handleOutboundMessage(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)object;
            int n = spdyDataFrame.streamId();
            if (this.spdySession.isLocalSideClosed(n)) {
                spdyDataFrame.release();
                channelPromise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
            int n2 = spdyDataFrame.content().readableBytes();
            int n3 = this.spdySession.getSendWindowSize(n);
            int n4 = this.spdySession.getSendWindowSize(0);
            if ((n3 = Math.min(n3, n4)) <= 0) {
                this.spdySession.putPendingWrite(n, new SpdySession.PendingWrite(spdyDataFrame, channelPromise));
                return;
            }
            if (n3 < n2) {
                this.spdySession.updateSendWindowSize(n, -1 * n3);
                this.spdySession.updateSendWindowSize(0, -1 * n3);
                DefaultSpdyDataFrame defaultSpdyDataFrame = new DefaultSpdyDataFrame(n, spdyDataFrame.content().readRetainedSlice(n3));
                this.spdySession.putPendingWrite(n, new SpdySession.PendingWrite(spdyDataFrame, channelPromise));
                object = channelHandlerContext;
                channelHandlerContext.write((Object)defaultSpdyDataFrame).addListener((GenericFutureListener)new ChannelFutureListener((ChannelHandlerContext)object){
                    final /* synthetic */ ChannelHandlerContext val$context;
                    {
                        this.val$context = channelHandlerContext;
                    }

                    public void operationComplete(ChannelFuture channelFuture) {
                        if (!channelFuture.isSuccess()) {
                            SpdySessionHandler.this.issueSessionError(this.val$context, SpdySessionStatus.INTERNAL_ERROR);
                        }
                    }
                });
                return;
            }
            this.spdySession.updateSendWindowSize(n, -1 * n2);
            this.spdySession.updateSendWindowSize(0, -1 * n2);
            final ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
            channelPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    if (!channelFuture.isSuccess()) {
                        SpdySessionHandler.this.issueSessionError(channelHandlerContext2, SpdySessionStatus.INTERNAL_ERROR);
                    }
                }
            });
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(n, false, (ChannelFuture)channelPromise);
            }
        } else if (object instanceof SpdySynStreamFrame) {
            boolean bl;
            boolean bl2;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)object;
            int n = spdySynStreamFrame.streamId();
            if (this.isRemoteInitiatedId(n)) {
                channelPromise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
            byte by = spdySynStreamFrame.priority();
            if (!this.acceptStream(n, by, bl2 = spdySynStreamFrame.isUnidirectional(), bl = spdySynStreamFrame.isLast())) {
                channelPromise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
        } else if (object instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)object;
            int n = spdySynReplyFrame.streamId();
            if (!this.isRemoteInitiatedId(n) || this.spdySession.isLocalSideClosed(n)) {
                channelPromise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(n, false, (ChannelFuture)channelPromise);
            }
        } else if (object instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)object;
            this.removeStream(spdyRstStreamFrame.streamId(), (ChannelFuture)channelPromise);
        } else if (object instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)object;
            int n = spdySettingsFrame.getValue(0);
            if (n >= 0 && n != this.minorVersion) {
                channelPromise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
            int n5 = spdySettingsFrame.getValue(4);
            if (n5 >= 0) {
                this.localConcurrentStreams = n5;
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            int n6 = spdySettingsFrame.getValue(7);
            if (n6 >= 0) {
                this.updateInitialReceiveWindowSize(n6);
            }
        } else if (object instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)object;
            if (this.isRemoteInitiatedId(spdyPingFrame.id())) {
                channelHandlerContext.fireExceptionCaught((Throwable)new IllegalArgumentException("invalid PING ID: " + spdyPingFrame.id()));
                return;
            }
            this.pings.getAndIncrement();
        } else {
            if (object instanceof SpdyGoAwayFrame) {
                channelPromise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
            if (object instanceof SpdyHeadersFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)object;
                int n = spdyHeadersFrame.streamId();
                if (this.spdySession.isLocalSideClosed(n)) {
                    channelPromise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                    return;
                }
                if (spdyHeadersFrame.isLast()) {
                    this.halfCloseStream(n, false, (ChannelFuture)channelPromise);
                }
            } else if (object instanceof SpdyWindowUpdateFrame) {
                channelPromise.setFailure((Throwable)PROTOCOL_EXCEPTION);
                return;
            }
        }
        channelHandlerContext.write(object, channelPromise);
    }

    private void issueSessionError(ChannelHandlerContext channelHandlerContext, SpdySessionStatus spdySessionStatus) {
        ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
        this.sendGoAwayFrame(channelHandlerContext, spdySessionStatus).addListener((GenericFutureListener)new ClosingChannelFutureListener(channelHandlerContext2, channelHandlerContext2.newPromise()));
    }

    private void issueStreamError(ChannelHandlerContext channelHandlerContext, int n, SpdyStreamStatus spdyStreamStatus) {
        boolean bl = !this.spdySession.isRemoteSideClosed(n);
        ChannelPromise channelPromise = channelHandlerContext.newPromise();
        this.removeStream(n, (ChannelFuture)channelPromise);
        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, spdyStreamStatus);
        channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame, channelPromise);
        if (bl) {
            channelHandlerContext.fireChannelRead((Object)defaultSpdyRstStreamFrame);
        }
    }

    private boolean isRemoteInitiatedId(int n) {
        n = SpdyCodecUtil.isServerId(n) ? 1 : 0;
        return this.server && n == 0 || !this.server && n != 0;
    }

    private void updateInitialSendWindowSize(int n) {
        int n2 = n - this.initialSendWindowSize;
        this.initialSendWindowSize = n;
        this.spdySession.updateAllSendWindowSizes(n2);
    }

    private void updateInitialReceiveWindowSize(int n) {
        int n2 = n - this.initialReceiveWindowSize;
        this.initialReceiveWindowSize = n;
        this.spdySession.updateAllReceiveWindowSizes(n2);
    }

    private boolean acceptStream(int n, byte by, boolean bl, boolean bl2) {
        int n2;
        if (this.receivedGoAwayFrame || this.sentGoAwayFrame) {
            return false;
        }
        boolean bl3 = this.isRemoteInitiatedId(n);
        int n3 = n2 = bl3 ? this.localConcurrentStreams : this.remoteConcurrentStreams;
        if (this.spdySession.numActiveStreams(bl3) >= n2) {
            return false;
        }
        this.spdySession.acceptStream(n, by, bl, bl2, this.initialSendWindowSize, this.initialReceiveWindowSize, bl3);
        if (bl3) {
            this.lastGoodStreamId = n;
        }
        return true;
    }

    private void halfCloseStream(int n, boolean bl, ChannelFuture channelFuture) {
        if (bl) {
            this.spdySession.closeRemoteSide(n, this.isRemoteInitiatedId(n));
        } else {
            this.spdySession.closeLocalSide(n, this.isRemoteInitiatedId(n));
        }
        if (this.closeSessionFutureListener != null && this.spdySession.noActiveStreams()) {
            channelFuture.addListener((GenericFutureListener)this.closeSessionFutureListener);
        }
    }

    private void removeStream(int n, ChannelFuture channelFuture) {
        this.spdySession.removeStream(n, STREAM_CLOSED, this.isRemoteInitiatedId(n));
        if (this.closeSessionFutureListener != null && this.spdySession.noActiveStreams()) {
            channelFuture.addListener((GenericFutureListener)this.closeSessionFutureListener);
        }
    }

    private void updateSendWindowSize(final ChannelHandlerContext channelHandlerContext, int n, int n2) {
        this.spdySession.updateSendWindowSize(n, n2);
        Object object;
        while ((object = this.spdySession.getPendingWrite(n)) != null) {
            SpdyDataFrame spdyDataFrame = ((SpdySession.PendingWrite)object).spdyDataFrame;
            int n3 = spdyDataFrame.content().readableBytes();
            int n4 = spdyDataFrame.streamId();
            int n5 = this.spdySession.getSendWindowSize(n4);
            int n6 = this.spdySession.getSendWindowSize(0);
            if ((n5 = Math.min(n5, n6)) <= 0) {
                return;
            }
            if (n5 < n3) {
                this.spdySession.updateSendWindowSize(n4, -1 * n5);
                this.spdySession.updateSendWindowSize(0, -1 * n5);
                object = new DefaultSpdyDataFrame(n4, spdyDataFrame.content().readRetainedSlice(n5));
                channelHandlerContext.writeAndFlush(object).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) {
                        if (!channelFuture.isSuccess()) {
                            SpdySessionHandler.this.issueSessionError(channelHandlerContext, SpdySessionStatus.INTERNAL_ERROR);
                        }
                    }
                });
                continue;
            }
            this.spdySession.removePendingWrite(n4);
            this.spdySession.updateSendWindowSize(n4, -1 * n3);
            this.spdySession.updateSendWindowSize(0, -1 * n3);
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(n4, false, (ChannelFuture)((SpdySession.PendingWrite)object).promise);
            }
            channelHandlerContext.writeAndFlush((Object)spdyDataFrame, ((SpdySession.PendingWrite)object).promise).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    if (!channelFuture.isSuccess()) {
                        SpdySessionHandler.this.issueSessionError(channelHandlerContext, SpdySessionStatus.INTERNAL_ERROR);
                    }
                }
            });
        }
        return;
    }

    private void sendGoAwayFrame(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        ChannelFuture channelFuture = this.sendGoAwayFrame(channelHandlerContext, SpdySessionStatus.OK);
        if (this.spdySession.noActiveStreams()) {
            channelFuture.addListener((GenericFutureListener)new ClosingChannelFutureListener(channelHandlerContext, channelPromise));
            return;
        }
        this.closeSessionFutureListener = new ClosingChannelFutureListener(channelHandlerContext, channelPromise);
    }

    private ChannelFuture sendGoAwayFrame(ChannelHandlerContext channelHandlerContext, SpdySessionStatus object) {
        if (!this.sentGoAwayFrame) {
            this.sentGoAwayFrame = true;
            object = new DefaultSpdyGoAwayFrame(this.lastGoodStreamId, (SpdySessionStatus)object);
            return channelHandlerContext.writeAndFlush(object);
        }
        return channelHandlerContext.newSucceededFuture();
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelPromise promise;

        ClosingChannelFutureListener(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
            this.ctx = channelHandlerContext;
            this.promise = channelPromise;
        }

        public final void operationComplete(ChannelFuture channelFuture) {
            this.ctx.close(this.promise);
        }
    }
}

