/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.xml.namespace.QName;
import org.e.a.b;
import org.e.a.b.d;
import org.e.a.e;
import org.e.a.f;
import org.e.a.i;
import org.e.c.c;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.NonzaCallback;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.ScheduledAction;
import org.jivesoftware.smack.Smack;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.SmackReactor;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.UnparseableStanza;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.filter.IQReplyFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.internal.SmackTlsContext;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Mechanisms;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.MessageOrPresence;
import org.jivesoftware.smack.packet.MessageOrPresenceBuilder;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Session;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StanzaFactory;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.StreamOpen;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.Provider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.packet.SaslNonza;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.Predicate;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.Supplier;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public abstract class AbstractXMPPConnection
implements XMPPConnection {
    private static final Logger LOGGER = Logger.getLogger(AbstractXMPPConnection.class.getName());
    protected static final SmackReactor SMACK_REACTOR = SmackReactor.getInstance();
    private static final AtomicInteger connectionCounter = new AtomicInteger(0);
    protected final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final Collection<StanzaCollector> collectors = new ConcurrentLinkedQueue<StanzaCollector>();
    private final Map<StanzaListener, ListenerWrapper> recvListeners = new LinkedHashMap<StanzaListener, ListenerWrapper>();
    private final Map<StanzaListener, ListenerWrapper> syncRecvListeners = new LinkedHashMap<StanzaListener, ListenerWrapper>();
    private final Map<StanzaListener, ListenerWrapper> asyncRecvListeners = new LinkedHashMap<StanzaListener, ListenerWrapper>();
    private final Map<StanzaListener, ListenerWrapper> sendListeners = new HashMap<StanzaListener, ListenerWrapper>();
    private final Map<StanzaListener, InterceptorWrapper> interceptors = new HashMap<StanzaListener, InterceptorWrapper>();
    private final Map<Consumer<MessageBuilder>, GenericInterceptorWrapper<MessageBuilder, Message>> messageInterceptors = new HashMap<Consumer<MessageBuilder>, GenericInterceptorWrapper<MessageBuilder, Message>>();
    private final Map<Consumer<PresenceBuilder>, GenericInterceptorWrapper<PresenceBuilder, Presence>> presenceInterceptors = new HashMap<Consumer<PresenceBuilder>, GenericInterceptorWrapper<PresenceBuilder, Presence>>();
    private XmlEnvironment incomingStreamXmlEnvironment;
    protected XmlEnvironment outgoingStreamXmlEnvironment;
    final MultiMap<QName, NonzaCallback> nonzaCallbacksMap = new MultiMap();
    protected final Lock connectionLock = new ReentrantLock();
    protected final Map<QName, FullyQualifiedElement> streamFeatures = new HashMap<QName, FullyQualifiedElement>();
    protected f user;
    protected boolean connected = false;
    protected String streamId;
    private long replyTimeout = SmackConfiguration.getDefaultReplyTimeout();
    protected final SmackDebugger debugger;
    protected Reader reader;
    protected Writer writer;
    protected SmackException currentSmackException;
    protected XMPPException currentXmppException;
    protected boolean tlsHandled;
    protected boolean lastFeaturesReceived;
    protected boolean saslFeatureReceived;
    protected boolean closingStreamReceived;
    private final SASLAuthentication saslAuthentication;
    protected final int connectionCounterValue = connectionCounter.getAndIncrement();
    protected final ConnectionConfiguration config;
    private XMPPConnection.FromMode fromMode = XMPPConnection.FromMode.OMITTED;
    protected XMPPInputOutputStream compressionHandler;
    private ParsingExceptionCallback parsingExceptionCallback = SmackConfiguration.getDefaultParsingExceptionCallback();
    private static final ExecutorService CACHED_EXECUTOR_SERVICE;
    protected static final AsyncButOrdered<AbstractXMPPConnection> ASYNC_BUT_ORDERED;
    protected String host;
    protected UInt16 port;
    protected boolean authenticated = false;
    protected long authenticatedConnectionInitiallyEstablishedTimestamp;
    protected boolean wasAuthenticated = false;
    private final Map<QName, IQRequestHandler> setIqRequestHandler = new HashMap<QName, IQRequestHandler>();
    private final Map<QName, IQRequestHandler> getIqRequestHandler = new HashMap<QName, IQRequestHandler>();
    private final StanzaFactory stanzaFactory;
    private String usedUsername;
    private String usedPassword;
    private d usedResource;
    private final Object internalMonitor = new Object();
    private b xmppServiceDomain;
    private final Object notifyConnectionErrorMonitor = new Object();
    private SmackConfiguration.UnknownIqRequestReplyMode unknownIqRequestReplyMode = SmackConfiguration.getUnknownIqRequestReplyMode();
    private long lastStanzaReceived;
    private final Queue<Runnable> deferredAsyncRunnables = new LinkedList<Runnable>();
    private int deferredAsyncRunnablesCount;
    private int deferredAsyncRunnablesCountPrevious;
    private int maxAsyncRunnables = SmackConfiguration.getDefaultConcurrencyLevelLimit();
    private int currentAsyncRunnables;

    protected AbstractXMPPConnection(ConnectionConfiguration connectionConfiguration) {
        this.saslAuthentication = new SASLAuthentication(this, connectionConfiguration);
        this.config = connectionConfiguration;
        this.buildNonzaCallback().listenFor(SaslNonza.Challenge.class, challenge -> {
            try {
                this.saslAuthentication.challengeReceived((SaslNonza.Challenge)challenge);
                return;
            }
            catch (InterruptedException | SmackException exception) {
                this.saslAuthentication.authenticationFailed(exception);
                return;
            }
        }).listenFor(SaslNonza.Success.class, success -> {
            try {
                this.saslAuthentication.authenticated((SaslNonza.Success)success);
                return;
            }
            catch (InterruptedException | SmackException.NotConnectedException | SmackException.SmackSaslException exception) {
                this.saslAuthentication.authenticationFailed(exception);
                return;
            }
        }).listenFor(SaslNonza.SASLFailure.class, sASLFailure -> this.saslAuthentication.authenticationFailed((SaslNonza.SASLFailure)sASLFailure)).install();
        Object object = connectionConfiguration.getDebuggerFactory();
        this.debugger = object != null ? object.create(this) : null;
        for (ConnectionCreationListener connectionCreationListener : XMPPConnectionRegistry.getConnectionCreationListeners()) {
            connectionCreationListener.connectionCreated(this);
        }
        object = connectionConfiguration.constructStanzaIdSource();
        this.stanzaFactory = new StanzaFactory((StanzaIdSource)object);
    }

    public ConnectionConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public b getXMPPServiceDomain() {
        if (this.xmppServiceDomain != null) {
            return this.xmppServiceDomain;
        }
        return this.config.getXMPPServiceDomain();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        UInt16 uInt16 = this.port;
        if (uInt16 == null) {
            return -1;
        }
        return uInt16.intValue();
    }

    @Override
    public abstract boolean isSecureConnection();

    protected abstract void sendStanzaInternal(Stanza var1);

    @Override
    public boolean trySendStanza(Stanza stanza) {
        try {
            this.sendStanza(stanza);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.FINER, "Thread blocked in fallback implementation of trySendStanza(Stanza) was interrupted", interruptedException);
            return false;
        }
        return true;
    }

    @Override
    public boolean trySendStanza(Stanza stanza, long l, TimeUnit timeUnit) {
        this.sendStanza(stanza);
        return true;
    }

    @Override
    public abstract void sendNonza(Nonza var1);

    @Override
    public abstract boolean isUsingCompression();

    protected void initState() {
        this.currentSmackException = null;
        this.currentXmppException = null;
        AbstractXMPPConnection abstractXMPPConnection = this;
        this.tlsHandled = false;
        abstractXMPPConnection.lastFeaturesReceived = false;
        abstractXMPPConnection.saslFeatureReceived = false;
    }

    public synchronized AbstractXMPPConnection connect() {
        this.throwAlreadyConnectedExceptionIfAppropriate();
        this.callConnectionConnectingListener();
        this.initState();
        this.closingStreamReceived = false;
        this.streamId = null;
        try {
            this.connectInternal();
            if (!this.isSecureConnection() && this.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
                throw new SmackException.SecurityRequiredByClientException();
            }
        }
        catch (IOException | InterruptedException | SmackException | XMPPException exception) {
            this.instantShutdown();
            throw exception;
        }
        assert (this.connected);
        this.callConnectionConnectedListener();
        return this;
    }

    protected abstract void connectInternal();

    public synchronized void login() {
        CharSequence charSequence = this.usedUsername != null ? this.usedUsername : this.config.getUsername();
        String string = this.usedPassword != null ? this.usedPassword : this.config.getPassword();
        d d2 = this.usedResource != null ? this.usedResource : this.config.getResource();
        this.login(charSequence, string, d2);
    }

    public synchronized void login(CharSequence charSequence, String string) {
        this.login(charSequence, string, this.config.getResource());
    }

    public synchronized void login(CharSequence charSequence, String string, d d2) {
        if (!this.config.allowNullOrEmptyUsername) {
            StringUtils.requireNotNullNorEmpty(charSequence, "Username must not be null nor empty");
        }
        this.throwNotConnectedExceptionIfAppropriate("Did you call connect() before login()?");
        this.throwAlreadyLoggedInExceptionIfAppropriate();
        this.usedUsername = charSequence != null ? charSequence.toString() : null;
        this.usedPassword = string;
        this.usedResource = d2;
        AbstractXMPPConnection abstractXMPPConnection = this;
        abstractXMPPConnection.loginInternal(abstractXMPPConnection.usedUsername, this.usedPassword, this.usedResource);
    }

    protected abstract void loginInternal(String var1, String var2, d var3);

    @Override
    public final boolean isConnected() {
        return this.connected;
    }

    @Override
    public final boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public final f getUser() {
        return this.user;
    }

    @Override
    public String getStreamId() {
        if (!this.isConnected()) {
            return null;
        }
        return this.streamId;
    }

    protected final void throwCurrentConnectionException() {
        if (this.currentSmackException != null) {
            throw this.currentSmackException;
        }
        if (this.currentXmppException != null) {
            throw this.currentXmppException;
        }
        throw new AssertionError((Object)"No current connection exception set, although throwCurrentException() was called");
    }

    protected final boolean hasCurrentConnectionException() {
        return this.currentSmackException != null || this.currentXmppException != null;
    }

    protected final void setCurrentConnectionExceptionAndNotify(Exception exception) {
        if (exception instanceof SmackException) {
            this.currentSmackException = (SmackException)exception;
        } else if (exception instanceof XMPPException) {
            this.currentXmppException = (XMPPException)exception;
        } else {
            this.currentSmackException = new SmackException.SmackWrappedException(exception);
        }
        this.notifyWaitingThreads();
    }

    protected final void notifyWaitingThreads() {
        Object object = this.internalMonitor;
        synchronized (object) {
            this.internalMonitor.notifyAll();
            return;
        }
    }

    protected final boolean waitFor(Supplier<Boolean> supplier) {
        long l = System.currentTimeMillis() + this.getReplyTimeout();
        Object object = this.internalMonitor;
        synchronized (object) {
            while (!supplier.get().booleanValue()) {
                long l2 = System.currentTimeMillis();
                if (l2 >= l) {
                    return false;
                }
                this.internalMonitor.wait(l - l2);
            }
        }
        return true;
    }

    protected final void waitForConditionOrThrowConnectionException(Supplier<Boolean> supplier, String string) {
        AbstractXMPPConnection abstractXMPPConnection = this;
        boolean bl = abstractXMPPConnection.waitFor(() -> (Boolean)supplier.get() != false || this.hasCurrentConnectionException());
        if (this.hasCurrentConnectionException()) {
            this.throwCurrentConnectionException();
        }
        if (!bl) {
            throw SmackException.NoResponseException.newWith((XMPPConnection)this, string);
        }
    }

    protected d bindResourceAndEstablishSession(d object) {
        LOGGER.finer("Waiting for last features to be received before continuing with resource binding");
        AbstractXMPPConnection abstractXMPPConnection = this;
        abstractXMPPConnection.waitForConditionOrThrowConnectionException(() -> this.lastFeaturesReceived, "last stream features received from server");
        if (!this.hasFeature("bind", "urn:ietf:params:xml:ns:xmpp-bind")) {
            throw new SmackException.ResourceBindingNotOfferedException();
        }
        object = Bind.newSet((d)object);
        object = this.createStanzaCollectorAndSend(new StanzaIdFilter((Stanza)object), (Stanza)object);
        Bind bind = (Bind)((StanzaCollector)object).nextResultOrThrow();
        this.user = bind.getJid();
        this.xmppServiceDomain = this.user.v();
        object = this.getFeature(Session.Feature.class);
        if (object != null && !((Session.Feature)object).isOptional()) {
            object = new Session();
            object = this.createStanzaCollectorAndSend(new StanzaIdFilter((Stanza)object), (Stanza)object);
            ((StanzaCollector)object).nextResultOrThrow();
        }
        return bind.getJid().d();
    }

    protected void afterSuccessfulLogin(boolean bl) {
        if (!bl) {
            this.authenticatedConnectionInitiallyEstablishedTimestamp = System.currentTimeMillis();
        }
        this.authenticated = true;
        if (this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
        this.callConnectionAuthenticatedListener(bl);
        if (this.config.isSendPresence() && !bl) {
            Presence presence = this.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.available).build();
            this.sendStanza(presence);
        }
    }

    @Override
    public final boolean isAnonymous() {
        return this.isAuthenticated() && "ANONYMOUS".equals(this.getUsedSaslMechansism());
    }

    public final String getUsedSaslMechansism() {
        return this.saslAuthentication.getNameOfLastUsedSaslMechansism();
    }

    protected Lock getConnectionLock() {
        return this.connectionLock;
    }

    protected void throwNotConnectedExceptionIfAppropriate() {
        this.throwNotConnectedExceptionIfAppropriate(null);
    }

    protected void throwNotConnectedExceptionIfAppropriate(String string) {
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException(string);
        }
    }

    protected void throwAlreadyConnectedExceptionIfAppropriate() {
        if (this.isConnected()) {
            throw new SmackException.AlreadyConnectedException();
        }
    }

    protected void throwAlreadyLoggedInExceptionIfAppropriate() {
        if (this.isAuthenticated()) {
            throw new SmackException.AlreadyLoggedInException();
        }
    }

    @Override
    public final StanzaFactory getStanzaFactory() {
        return this.stanzaFactory;
    }

    @Override
    public final void sendStanza(Stanza stanza) {
        Objects.requireNonNull(stanza, "Stanza must not be null");
        assert (stanza instanceof Message || stanza instanceof Presence || stanza instanceof IQ);
        this.throwNotConnectedExceptionIfAppropriate();
        switch (this.fromMode) {
            case OMITTED: {
                stanza.setFrom(null);
                break;
            }
            case USER: {
                stanza.setFrom((i)this.getUser());
            }
        }
        stanza = this.firePacketInterceptors(stanza);
        this.sendStanzaInternal(stanza);
    }

    protected final SASLMechanism authenticate(String object, String string, e e2, SSLSession sSLSession) {
        object = this.saslAuthentication.authenticate((String)object, string, e2, sSLSession);
        this.afterSaslAuthenticationSuccess();
        return object;
    }

    protected void afterSaslAuthenticationSuccess() {
        this.sendStreamOpen();
    }

    protected final boolean isSaslAuthenticated() {
        return this.saslAuthentication.authenticationSuccessful();
    }

    public void disconnect() {
        Presence presence = null;
        if (this.isAuthenticated()) {
            presence = this.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.unavailable).build();
        }
        try {
            this.disconnect(presence);
            return;
        }
        catch (SmackException.NotConnectedException notConnectedException) {
            LOGGER.log(Level.FINEST, "Connection is already disconnected", notConnectedException);
            return;
        }
    }

    public synchronized void disconnect(Presence presence) {
        if (presence != null) {
            try {
                this.sendStanza(presence);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.FINE, "Was interrupted while sending unavailable presence. Continuing to disconnect the connection", interruptedException);
            }
        }
        this.shutdown();
        this.callConnectionClosedListener();
    }

    protected final void notifyConnectionError(Exception exception) {
        Object object = this.notifyConnectionErrorMonitor;
        synchronized (object) {
            if (!this.isConnected()) {
                LOGGER.log(Level.INFO, "Connection was already disconnected when attempting to handle " + exception, exception);
                return;
            }
            this.setCurrentConnectionExceptionAndNotify(exception);
            this.instantShutdown();
            for (StanzaCollector stanzaCollector : this.collectors) {
                stanzaCollector.notifyConnectionError(exception);
            }
            Async.go(() -> this.callConnectionClosedOnErrorListener(exception), this + " callConnectionClosedOnErrorListener()");
            return;
        }
    }

    public abstract void instantShutdown();

    protected abstract void shutdown();

    protected final boolean waitForClosingStreamTagFromServer() {
        try {
            AbstractXMPPConnection abstractXMPPConnection = this;
            abstractXMPPConnection.waitForConditionOrThrowConnectionException(() -> this.closingStreamReceived, "closing stream tag from the server");
        }
        catch (InterruptedException | SmackException | XMPPException exception) {
            LOGGER.log(Level.INFO, "Exception while waiting for closing stream element from the server " + this, exception);
            return false;
        }
        return true;
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener == null) {
            return;
        }
        this.connectionListeners.add(connectionListener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    @Override
    public <I extends IQ> I sendIqRequestAndWaitForResponse(IQ object) {
        object = this.createStanzaCollectorAndSend((IQ)object);
        IQ iQ = (IQ)((StanzaCollector)object).nextResultOrThrow();
        object = iQ;
        object = iQ;
        return (I)iQ;
    }

    @Override
    public StanzaCollector createStanzaCollectorAndSend(IQ object) {
        IQReplyFilter iQReplyFilter = new IQReplyFilter((IQ)object, this);
        object = this.createStanzaCollectorAndSend(iQReplyFilter, (Stanza)object);
        return object;
    }

    @Override
    public StanzaCollector createStanzaCollectorAndSend(StanzaFilter object, Stanza stanza) {
        object = StanzaCollector.newConfiguration().setStanzaFilter((StanzaFilter)object).setRequest(stanza);
        object = this.createStanzaCollector((StanzaCollector.Configuration)object);
        try {
            this.sendStanza(stanza);
        }
        catch (InterruptedException | RuntimeException | SmackException.NotConnectedException exception) {
            ((StanzaCollector)object).cancel();
            throw exception;
        }
        return object;
    }

    @Override
    public StanzaCollector createStanzaCollector(StanzaFilter object) {
        object = StanzaCollector.newConfiguration().setStanzaFilter((StanzaFilter)object);
        return this.createStanzaCollector((StanzaCollector.Configuration)object);
    }

    @Override
    public StanzaCollector createStanzaCollector(StanzaCollector.Configuration object) {
        object = new StanzaCollector(this, (StanzaCollector.Configuration)object);
        this.collectors.add((StanzaCollector)object);
        return object;
    }

    @Override
    public void removeStanzaCollector(StanzaCollector stanzaCollector) {
        this.collectors.remove(stanzaCollector);
    }

    @Override
    public final void addStanzaListener(StanzaListener stanzaListener, StanzaFilter object) {
        if (stanzaListener == null) {
            throw new NullPointerException("Given stanza listener must not be null");
        }
        object = new ListenerWrapper(stanzaListener, (StanzaFilter)object);
        Map<StanzaListener, ListenerWrapper> map = this.recvListeners;
        synchronized (map) {
            this.recvListeners.put(stanzaListener, (ListenerWrapper)object);
            return;
        }
    }

    @Override
    public final boolean removeStanzaListener(StanzaListener stanzaListener) {
        Map<StanzaListener, ListenerWrapper> map = this.recvListeners;
        synchronized (map) {
            return this.recvListeners.remove(stanzaListener) != null;
        }
    }

    @Override
    public void addSyncStanzaListener(StanzaListener stanzaListener, StanzaFilter object) {
        if (stanzaListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        object = new ListenerWrapper(stanzaListener, (StanzaFilter)object);
        Map<StanzaListener, ListenerWrapper> map = this.syncRecvListeners;
        synchronized (map) {
            this.syncRecvListeners.put(stanzaListener, (ListenerWrapper)object);
            return;
        }
    }

    @Override
    public boolean removeSyncStanzaListener(StanzaListener stanzaListener) {
        Map<StanzaListener, ListenerWrapper> map = this.syncRecvListeners;
        synchronized (map) {
            return this.syncRecvListeners.remove(stanzaListener) != null;
        }
    }

    @Override
    public void addAsyncStanzaListener(StanzaListener stanzaListener, StanzaFilter object) {
        if (stanzaListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        object = new ListenerWrapper(stanzaListener, (StanzaFilter)object);
        Map<StanzaListener, ListenerWrapper> map = this.asyncRecvListeners;
        synchronized (map) {
            this.asyncRecvListeners.put(stanzaListener, (ListenerWrapper)object);
            return;
        }
    }

    @Override
    public boolean removeAsyncStanzaListener(StanzaListener stanzaListener) {
        Map<StanzaListener, ListenerWrapper> map = this.asyncRecvListeners;
        synchronized (map) {
            return this.asyncRecvListeners.remove(stanzaListener) != null;
        }
    }

    @Override
    public void addStanzaSendingListener(StanzaListener stanzaListener, StanzaFilter object) {
        if (stanzaListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        object = new ListenerWrapper(stanzaListener, (StanzaFilter)object);
        Map<StanzaListener, ListenerWrapper> map = this.sendListeners;
        synchronized (map) {
            this.sendListeners.put(stanzaListener, (ListenerWrapper)object);
            return;
        }
    }

    @Override
    public void removeStanzaSendingListener(StanzaListener stanzaListener) {
        Map<StanzaListener, ListenerWrapper> map = this.sendListeners;
        synchronized (map) {
            this.sendListeners.remove(stanzaListener);
            return;
        }
    }

    protected void firePacketSendingListeners(TopLevelStreamElement topLevelStreamElement) {
        if (this.debugger != null) {
            this.debugger.onOutgoingStreamElement(topLevelStreamElement);
        }
        if (!(topLevelStreamElement instanceof Stanza)) {
            return;
        }
        topLevelStreamElement = (Stanza)topLevelStreamElement;
        final LinkedList<StanzaListener> linkedList = new LinkedList<StanzaListener>();
        Map<StanzaListener, ListenerWrapper> map = this.sendListeners;
        synchronized (map) {
            for (ListenerWrapper listenerWrapper : this.sendListeners.values()) {
                if (!listenerWrapper.filterMatches((Stanza)topLevelStreamElement)) continue;
                linkedList.add(listenerWrapper.getListener());
            }
        }
        if (linkedList.isEmpty()) {
            return;
        }
        AbstractXMPPConnection.asyncGo(new Runnable((Stanza)topLevelStreamElement){
            final /* synthetic */ Stanza val$packet;
            {
                this.val$packet = stanza;
            }

            @Override
            public void run() {
                for (StanzaListener stanzaListener : linkedList) {
                    try {
                        stanzaListener.processStanza(this.val$packet);
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, "Sending listener threw exception", exception);
                    }
                }
            }
        });
    }

    @Override
    @Deprecated
    public void addStanzaInterceptor(StanzaListener stanzaListener, StanzaFilter object) {
        if (stanzaListener == null) {
            throw new NullPointerException("Packet interceptor is null.");
        }
        object = new InterceptorWrapper(stanzaListener, (StanzaFilter)object);
        Map<StanzaListener, InterceptorWrapper> map = this.interceptors;
        synchronized (map) {
            this.interceptors.put(stanzaListener, (InterceptorWrapper)object);
            return;
        }
    }

    @Override
    @Deprecated
    public void removeStanzaInterceptor(StanzaListener stanzaListener) {
        Map<StanzaListener, InterceptorWrapper> map = this.interceptors;
        synchronized (map) {
            this.interceptors.remove(stanzaListener);
            return;
        }
    }

    private static <MPB extends MessageOrPresenceBuilder<MP, MPB>, MP extends MessageOrPresence<MPB>> void addInterceptor(Map<Consumer<MPB>, GenericInterceptorWrapper<MPB, MP>> map, Consumer<MPB> consumer, Predicate<MP> object) {
        Objects.requireNonNull(consumer, "Interceptor must not be null");
        object = new GenericInterceptorWrapper(consumer, (Predicate)object);
        Map<Consumer<MPB>, GenericInterceptorWrapper<MPB, MP>> map2 = map;
        synchronized (map2) {
            map.put(consumer, (GenericInterceptorWrapper<MPB, MP>)object);
            return;
        }
    }

    private static <MPB extends MessageOrPresenceBuilder<MP, MPB>, MP extends MessageOrPresence<MPB>> void removeInterceptor(Map<Consumer<MPB>, GenericInterceptorWrapper<MPB, MP>> map, Consumer<MPB> consumer) {
        Map<Consumer<MPB>, GenericInterceptorWrapper<MPB, MP>> map2 = map;
        synchronized (map2) {
            map.remove(consumer);
            return;
        }
    }

    @Override
    public void addMessageInterceptor(Consumer<MessageBuilder> consumer, Predicate<Message> predicate) {
        AbstractXMPPConnection.addInterceptor(this.messageInterceptors, consumer, predicate);
    }

    @Override
    public void removeMessageInterceptor(Consumer<MessageBuilder> consumer) {
        AbstractXMPPConnection.removeInterceptor(this.messageInterceptors, consumer);
    }

    @Override
    public void addPresenceInterceptor(Consumer<PresenceBuilder> consumer, Predicate<Presence> predicate) {
        AbstractXMPPConnection.addInterceptor(this.presenceInterceptors, consumer, predicate);
    }

    @Override
    public void removePresenceInterceptor(Consumer<PresenceBuilder> consumer) {
        AbstractXMPPConnection.removeInterceptor(this.presenceInterceptors, consumer);
    }

    private static <MPB extends MessageOrPresenceBuilder<MP, MPB>, MP extends MessageOrPresence<MPB>> MP fireMessageOrPresenceInterceptors(MP object, Map<Consumer<MPB>, GenericInterceptorWrapper<MPB, MP>> iterator) {
        LinkedList linkedList = new LinkedList();
        Iterator<Object> map = iterator;
        synchronized (map) {
            for (GenericInterceptorWrapper genericInterceptorWrapper : iterator.values()) {
                if (!genericInterceptorWrapper.filterMatches((MessageOrPresence)object)) continue;
                Consumer consumer = genericInterceptorWrapper.getInterceptor();
                linkedList.add(consumer);
            }
        }
        if (linkedList.isEmpty()) {
            return (MP)object;
        }
        map = ((MessageOrPresence)object).asBuilder();
        for (Consumer consumer : linkedList) {
            consumer.accept(map);
        }
        object = ((MessageOrPresenceBuilder)((Object)map)).build();
        return (MP)object;
    }

    private Stanza firePacketInterceptors(Stanza stanza) {
        LinkedList<StanzaListener> linkedList = new LinkedList<StanzaListener>();
        Object object2 = this.interceptors;
        synchronized (object2) {
            for (InterceptorWrapper interceptorWrapper : this.interceptors.values()) {
                if (!interceptorWrapper.filterMatches(stanza)) continue;
                linkedList.add(interceptorWrapper.getInterceptor());
            }
        }
        for (StanzaListener stanzaListener : linkedList) {
            try {
                stanzaListener.processStanza(stanza);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Packet interceptor threw exception", exception);
            }
        }
        if (stanza instanceof Message) {
            Message message = (Message)stanza;
            object2 = AbstractXMPPConnection.fireMessageOrPresenceInterceptors(message, this.messageInterceptors);
        } else if (stanza instanceof Presence) {
            Presence presence = (Presence)stanza;
            object2 = AbstractXMPPConnection.fireMessageOrPresenceInterceptors(presence, this.presenceInterceptors);
        } else {
            assert (stanza instanceof IQ);
            object2 = stanza;
        }
        return object2;
    }

    protected void initDebugger() {
        if (this.reader == null || this.writer == null) {
            throw new NullPointerException("Reader or writer isn't initialized.");
        }
        if (this.debugger != null) {
            this.reader = this.debugger.newConnectionReader(this.reader);
            this.writer = this.debugger.newConnectionWriter(this.writer);
        }
    }

    @Override
    public long getReplyTimeout() {
        return this.replyTimeout;
    }

    @Override
    public void setReplyTimeout(long l) {
        if (Long.MAX_VALUE - System.currentTimeMillis() < l) {
            throw new IllegalArgumentException("Extremely long reply timeout");
        }
        this.replyTimeout = l;
    }

    public void setUnknownIqRequestReplyMode(SmackConfiguration.UnknownIqRequestReplyMode unknownIqRequestReplyMode) {
        this.unknownIqRequestReplyMode = Objects.requireNonNull(unknownIqRequestReplyMode, "Mode must not be null");
    }

    protected final NonzaCallback.Builder buildNonzaCallback() {
        return new NonzaCallback.Builder(this);
    }

    protected <SN extends Nonza, FN extends Nonza> SN sendAndWaitForResponse(Nonza nonza, Class<SN> clazz, Class<FN> clazz2) {
        NonzaCallback.Builder builder = this.buildNonzaCallback();
        nonza = NonzaCallback.sendAndWaitForResponse(builder, nonza, clazz, clazz2);
        return (SN)nonza;
    }

    private void maybeNotifyDebuggerAboutIncoming(TopLevelStreamElement topLevelStreamElement) {
        SmackDebugger smackDebugger = this.debugger;
        if (smackDebugger != null) {
            smackDebugger.onIncomingStreamElement(topLevelStreamElement);
        }
    }

    protected final void parseAndProcessNonza(XmlPullParser object) {
        List<NonzaCallback> list;
        ParserUtils.assertAtStartTag((XmlPullParser)object);
        int n = object.getDepth();
        Object object2 = object.getName();
        Object object3 = object.getNamespace();
        object2 = new QName((String)object3, (String)object2);
        object3 = ProviderManager.getNonzaProvider((QName)object2);
        if (object3 == null) {
            LOGGER.severe("Unknown nonza: " + object2);
            ParserUtils.forwardToEndTagOfDepth((XmlPullParser)object, n);
            return;
        }
        Object object4 = this.nonzaCallbacksMap;
        synchronized (object4) {
            list = this.nonzaCallbacksMap.getAll((QName)object2);
            list = CollectionUtil.newListWith(list);
        }
        if (list == null) {
            LOGGER.info("No nonza callback for " + object2);
            ParserUtils.forwardToEndTagOfDepth((XmlPullParser)object, n);
            return;
        }
        object4 = (Nonza)((Provider)object3).parse((XmlPullParser)object, this.incomingStreamXmlEnvironment);
        this.maybeNotifyDebuggerAboutIncoming((TopLevelStreamElement)object4);
        for (NonzaCallback nonzaCallback : list) {
            nonzaCallback.onNonzaReceived((Nonza)object4);
        }
    }

    protected void parseAndProcessStanza(XmlPullParser xmlPullParser) {
        Stanza stanza;
        block3: {
            ParserUtils.assertAtStartTag(xmlPullParser);
            int n = xmlPullParser.getDepth();
            stanza = null;
            try {
                stanza = PacketParserUtils.parseStanza(xmlPullParser, this.incomingStreamXmlEnvironment);
            }
            catch (IOException | IllegalArgumentException | SmackParsingException | XmlPullParserException throwable) {
                Object object = PacketParserUtils.parseContentDepth(xmlPullParser, n);
                object = new UnparseableStanza((CharSequence)object, (Exception)throwable);
                ParsingExceptionCallback parsingExceptionCallback = this.getParsingExceptionCallback();
                if (parsingExceptionCallback == null) break block3;
                parsingExceptionCallback.handleUnparsableStanza((UnparseableStanza)object);
            }
        }
        ParserUtils.assertAtEndTag(xmlPullParser);
        if (stanza != null) {
            this.processStanza(stanza);
        }
    }

    protected void processStanza(Stanza stanza) {
        assert (stanza != null);
        this.maybeNotifyDebuggerAboutIncoming(stanza);
        this.lastStanzaReceived = System.currentTimeMillis();
        this.invokeStanzaCollectorsAndNotifyRecvListeners(stanza);
    }

    protected void invokeStanzaCollectorsAndNotifyRecvListeners(Stanza object) {
        Object object2;
        if (object instanceof IQ && (object2 = (IQ)object).isRequestIQ()) {
            IQRequestHandler iQRequestHandler;
            Object object3 = object2;
            QName object4 = ((IQ)object3).getChildElementQName();
            object = ((IQ)object2).getType();
            switch (11.$SwitchMap$org$jivesoftware$smack$packet$IQ$Type[((Enum)object).ordinal()]) {
                case 1: {
                    object = this.setIqRequestHandler;
                    synchronized (object) {
                        iQRequestHandler = this.setIqRequestHandler.get(object4);
                        break;
                    }
                }
                case 2: {
                    object = this.getIqRequestHandler;
                    synchronized (object) {
                        iQRequestHandler = this.getIqRequestHandler.get(object4);
                        break;
                    }
                }
                default: {
                    throw new IllegalStateException("Should only encounter IQ type 'get' or 'set'");
                }
            }
            if (iQRequestHandler == null) {
                switch (this.unknownIqRequestReplyMode) {
                    case doNotReply: {
                        return;
                    }
                    case replyFeatureNotImplemented: {
                        object = StanzaError.Condition.feature_not_implemented;
                        break;
                    }
                    case replyServiceUnavailable: {
                        object = StanzaError.Condition.service_unavailable;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                ErrorIQ iterator2 = IQ.createErrorResponse((IQ)object2, StanzaError.getBuilder((StanzaError.Condition)((Object)object)).build());
                AbstractXMPPConnection.asyncGo(() -> {
                    try {
                        this.sendStanza(iterator2);
                        return;
                    }
                    catch (InterruptedException | SmackException.NotConnectedException exception) {
                        LOGGER.log(Level.WARNING, "Exception while sending error IQ to unkown IQ request", exception);
                        return;
                    }
                });
                return;
            }
            object = null;
            switch (iQRequestHandler.getMode()) {
                case sync: {
                    object = ASYNC_BUT_ORDERED.asExecutorFor(this);
                    break;
                }
                case async: {
                    object = this::asyncGoLimited;
                }
            }
            final IQRequestHandler iQRequestHandler2 = iQRequestHandler;
            object.execute(new Runnable((IQ)object2, (IQ)object3){
                final /* synthetic */ IQ val$iq;
                final /* synthetic */ IQ val$iqRequest;
                {
                    this.val$iq = iQ;
                    this.val$iqRequest = iQ2;
                }

                @Override
                public void run() {
                    IQ iQ = iQRequestHandler2.handleIQRequest(this.val$iq);
                    if (iQ == null) {
                        return;
                    }
                    assert (iQ.isResponseIQ());
                    iQ.setTo(this.val$iqRequest.getFrom());
                    iQ.setStanzaId(this.val$iqRequest.getStanzaId());
                    try {
                        AbstractXMPPConnection.this.sendStanza(iQ);
                        return;
                    }
                    catch (InterruptedException | SmackException.NotConnectedException exception) {
                        LOGGER.log(Level.WARNING, "Exception while sending response to IQ request", exception);
                        return;
                    }
                }
            });
            return;
        }
        object2 = new LinkedList();
        AbstractXMPPConnection.extractMatchingListeners(object, this.asyncRecvListeners, (Collection<StanzaListener>)object2);
        Object object5 = object2.iterator();
        while (object5.hasNext()) {
            final StanzaListener stanzaListener = (StanzaListener)object5.next();
            this.asyncGoLimited(new Runnable((Stanza)object){
                final /* synthetic */ Stanza val$packet;
                {
                    this.val$packet = stanza;
                }

                @Override
                public void run() {
                    try {
                        stanzaListener.processStanza(this.val$packet);
                        return;
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.SEVERE, "Exception in async packet listener", exception);
                        return;
                    }
                }
            });
        }
        for (StanzaCollector stanzaCollector : this.collectors) {
            stanzaCollector.processStanza((Stanza)object);
        }
        object2.clear();
        AbstractXMPPConnection.extractMatchingListeners(object, this.recvListeners, (Collection<StanzaListener>)object2);
        object5 = new Semaphore(1 - object2.size());
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            StanzaListener stanzaListener = (StanzaListener)iterator.next();
            this.asyncGoLimited(() -> AbstractXMPPConnection.lambda$invokeStanzaCollectorsAndNotifyRecvListeners$8(stanzaListener, (Stanza)object, (Semaphore)object5));
        }
        ((Semaphore)object5).acquireUninterruptibly();
        object2.clear();
        AbstractXMPPConnection.extractMatchingListeners(object, this.syncRecvListeners, (Collection<StanzaListener>)object2);
        ASYNC_BUT_ORDERED.performAsyncButOrdered(this, new Runnable((Collection)object2, (Stanza)object){
            final /* synthetic */ Collection val$listenersToNotify;
            final /* synthetic */ Stanza val$packet;
            {
                this.val$listenersToNotify = collection;
                this.val$packet = stanza;
            }

            @Override
            public void run() {
                Iterator iterator = this.val$listenersToNotify.iterator();
                Map map = AbstractXMPPConnection.this.syncRecvListeners;
                synchronized (map) {
                    while (iterator.hasNext()) {
                        StanzaListener stanzaListener = (StanzaListener)iterator.next();
                        if (AbstractXMPPConnection.this.syncRecvListeners.containsKey(stanzaListener)) continue;
                        iterator.remove();
                    }
                }
                for (StanzaListener stanzaListener : this.val$listenersToNotify) {
                    try {
                        stanzaListener.processStanza(this.val$packet);
                    }
                    catch (SmackException.NotConnectedException notConnectedException) {
                        LOGGER.log(Level.WARNING, "Got not connected exception, aborting", notConnectedException);
                        return;
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.SEVERE, "Exception in packet listener", exception);
                    }
                }
            }
        });
    }

    private static void extractMatchingListeners(Stanza stanza, Map<StanzaListener, ListenerWrapper> object, Collection<StanzaListener> collection) {
        Map<StanzaListener, ListenerWrapper> map = object;
        synchronized (map) {
            for (ListenerWrapper listenerWrapper : object.values()) {
                if (!listenerWrapper.filterMatches(stanza)) continue;
                collection.add(listenerWrapper.getListener());
            }
            return;
        }
    }

    protected void setWasAuthenticated() {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = this.authenticated;
        }
    }

    protected void callConnectionConnectingListener() {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.connecting(this);
        }
    }

    protected void callConnectionConnectedListener() {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.connected(this);
        }
    }

    protected void callConnectionAuthenticatedListener(boolean bl) {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            try {
                connectionListener.authenticated(this, bl);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Exception in authenticated listener", exception);
            }
        }
    }

    void callConnectionClosedListener() {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            try {
                connectionListener.connectionClosed();
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Error in listener while closing connection", exception);
            }
        }
    }

    private void callConnectionClosedOnErrorListener(Exception exception) {
        Object object;
        boolean bl = true;
        if (exception instanceof XMPPException.StreamErrorException && ((XMPPException.StreamErrorException)(object = (XMPPException.StreamErrorException)exception)).getStreamError().getCondition() == StreamError.Condition.not_authorized && this.wasAuthenticated) {
            bl = false;
            LOGGER.log(Level.FINE, "Connection closed with not-authorized stream error after it was already authenticated. The account was likely deleted/unregistered on the server");
        }
        if (bl) {
            LOGGER.log(Level.WARNING, "Connection " + this + " closed with error", exception);
        }
        for (ConnectionListener connectionListener : this.connectionListeners) {
            try {
                connectionListener.connectionClosedOnError(exception);
            }
            catch (Exception exception2) {
                LOGGER.log(Level.SEVERE, "Error in listener while closing connection", exception2);
            }
        }
    }

    @Override
    public int getConnectionCounter() {
        return this.connectionCounterValue;
    }

    @Override
    public void setFromMode(XMPPConnection.FromMode fromMode) {
        this.fromMode = fromMode;
    }

    @Override
    public XMPPConnection.FromMode getFromMode() {
        return this.fromMode;
    }

    protected final void parseFeatures(XmlPullParser xmlPullParser) {
        this.streamFeatures.clear();
        int n = xmlPullParser.getDepth();
        while (true) {
            Object object;
            if ((object = xmlPullParser.next()) == XmlPullParser.Event.START_ELEMENT && xmlPullParser.getDepth() == n + 1) {
                object = null;
                Object object2 = xmlPullParser.getName();
                String string = xmlPullParser.getNamespace();
                switch (object2) {
                    case "starttls": {
                        object = PacketParserUtils.parseStartTlsFeature(xmlPullParser);
                        break;
                    }
                    case "mechanisms": {
                        object = new Mechanisms(PacketParserUtils.parseMechanisms(xmlPullParser));
                        break;
                    }
                    case "bind": {
                        object = Bind.Feature.INSTANCE;
                        break;
                    }
                    case "session": {
                        object = PacketParserUtils.parseSessionFeature(xmlPullParser);
                        break;
                    }
                    case "compression": {
                        object = PacketParserUtils.parseCompressionFeature(xmlPullParser);
                        break;
                    }
                    default: {
                        object2 = ProviderManager.getStreamFeatureProvider((String)object2, string);
                        if (object2 == null) break;
                        object = (FullyQualifiedElement)((Provider)object2).parse(xmlPullParser, this.incomingStreamXmlEnvironment);
                    }
                }
                if (object == null) continue;
                this.addStreamFeature((FullyQualifiedElement)object);
                continue;
            }
            if (object == XmlPullParser.Event.END_ELEMENT && xmlPullParser.getDepth() == n) break;
        }
    }

    protected final void parseFeaturesAndNotify(XmlPullParser xmlPullParser) {
        this.parseFeatures(xmlPullParser);
        if (this.hasFeature("mechanisms", "urn:ietf:params:xml:ns:xmpp-sasl") && (!this.hasFeature("starttls", "urn:ietf:params:xml:ns:xmpp-tls") || this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled)) {
            AbstractXMPPConnection abstractXMPPConnection = this;
            abstractXMPPConnection.saslFeatureReceived = true;
            abstractXMPPConnection.tlsHandled = true;
            this.notifyWaitingThreads();
        }
        if (!(!this.hasFeature("bind", "urn:ietf:params:xml:ns:xmpp-bind") || this.hasFeature("compression", "http://jabber.org/protocol/compress") && this.config.isCompressionEnabled())) {
            this.lastFeaturesReceived = true;
            this.notifyWaitingThreads();
        }
        this.afterFeaturesReceived();
    }

    protected void afterFeaturesReceived() {
    }

    @Override
    public <F extends FullyQualifiedElement> F getFeature(QName qName) {
        return (F)this.streamFeatures.get(qName);
    }

    @Override
    public boolean hasFeature(QName qName) {
        return this.streamFeatures.containsKey(qName);
    }

    protected void addStreamFeature(FullyQualifiedElement fullyQualifiedElement) {
        QName qName = fullyQualifiedElement.getQName();
        this.streamFeatures.put(qName, fullyQualifiedElement);
    }

    @Override
    public SmackFuture<IQ, Exception> sendIqRequestAsync(IQ iQ) {
        return this.sendIqRequestAsync(iQ, this.getReplyTimeout());
    }

    @Override
    public SmackFuture<IQ, Exception> sendIqRequestAsync(IQ iQ, long l) {
        IQReplyFilter iQReplyFilter = new IQReplyFilter(iQ, this);
        return this.sendAsync(iQ, iQReplyFilter, l);
    }

    @Override
    public <S extends Stanza> SmackFuture<S, Exception> sendAsync(S s, StanzaFilter stanzaFilter) {
        return this.sendAsync(s, stanzaFilter, this.getReplyTimeout());
    }

    @Override
    public <S extends Stanza> SmackFuture<S, Exception> sendAsync(S object, final StanzaFilter stanzaFilter, long l) {
        Objects.requireNonNull(object, "stanza must not be null");
        Objects.requireNonNull(stanzaFilter, "replyFilter must not be null");
        final SmackFuture.InternalSmackFuture internalSmackFuture = new SmackFuture.InternalSmackFuture();
        final StanzaListener stanzaListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza stanza) {
                boolean bl = AbstractXMPPConnection.this.removeAsyncStanzaListener(this);
                if (!bl) {
                    return;
                }
                try {
                    XMPPException.XMPPErrorException.ifHasErrorThenThrow(stanza);
                    internalSmackFuture.setResult(stanza);
                    return;
                }
                catch (XMPPException.XMPPErrorException xMPPErrorException) {
                    internalSmackFuture.setException(xMPPErrorException);
                    return;
                }
            }
        };
        AbstractXMPPConnection.schedule(new Runnable(){

            @Override
            public void run() {
                boolean bl = AbstractXMPPConnection.this.removeAsyncStanzaListener(stanzaListener);
                if (!bl) {
                    return;
                }
                SmackException smackException = !AbstractXMPPConnection.this.isConnected() ? new SmackException.NotConnectedException((XMPPConnection)AbstractXMPPConnection.this, stanzaFilter) : SmackException.NoResponseException.newWith((XMPPConnection)AbstractXMPPConnection.this, stanzaFilter);
                internalSmackFuture.setException(smackException);
            }
        }, l, TimeUnit.MILLISECONDS);
        this.addAsyncStanzaListener(stanzaListener, stanzaFilter);
        object = () -> {
            try {
                this.sendStanza((Stanza)object);
                return;
            }
            catch (InterruptedException | SmackException.NotConnectedException exception) {
                internalSmackFuture.setException(exception);
                return;
            }
        };
        if (SmackConfiguration.TRUELY_ASYNC_SENDS) {
            Async.go(object);
        } else {
            object.run();
        }
        return internalSmackFuture;
    }

    @Override
    public void addOneTimeSyncCallback(final StanzaListener stanzaListener, StanzaFilter stanzaFilter) {
        stanzaListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza stanza) {
                try {
                    stanzaListener.processStanza(stanza);
                    return;
                }
                finally {
                    AbstractXMPPConnection.this.removeSyncStanzaListener(this);
                }
            }
        };
        this.addSyncStanzaListener(stanzaListener, stanzaFilter);
        AbstractXMPPConnection.schedule(new Runnable(){

            @Override
            public void run() {
                AbstractXMPPConnection.this.removeSyncStanzaListener(stanzaListener);
            }
        }, this.getReplyTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public IQRequestHandler registerIQRequestHandler(IQRequestHandler iQRequestHandler) {
        QName qName = iQRequestHandler.getQName();
        switch (iQRequestHandler.getType()) {
            case set: {
                Map<QName, IQRequestHandler> map = this.setIqRequestHandler;
                synchronized (map) {
                    return this.setIqRequestHandler.put(qName, iQRequestHandler);
                }
            }
            case get: {
                Map<QName, IQRequestHandler> map = this.getIqRequestHandler;
                synchronized (map) {
                    return this.getIqRequestHandler.put(qName, iQRequestHandler);
                }
            }
        }
        throw new IllegalArgumentException("Only IQ type of 'get' and 'set' allowed");
    }

    @Override
    public final IQRequestHandler unregisterIQRequestHandler(IQRequestHandler iQRequestHandler) {
        return this.unregisterIQRequestHandler(iQRequestHandler.getElement(), iQRequestHandler.getNamespace(), iQRequestHandler.getType());
    }

    @Override
    public IQRequestHandler unregisterIQRequestHandler(String object, String map, IQ.Type type) {
        object = new QName((String)((Object)map), (String)object);
        switch (type) {
            case set: {
                map = this.setIqRequestHandler;
                synchronized (map) {
                    return this.setIqRequestHandler.remove(object);
                }
            }
            case get: {
                map = this.getIqRequestHandler;
                synchronized (map) {
                    return this.getIqRequestHandler.remove(object);
                }
            }
        }
        throw new IllegalArgumentException("Only IQ type of 'get' and 'set' allowed");
    }

    @Override
    public long getLastStanzaReceived() {
        return this.lastStanzaReceived;
    }

    public final long getAuthenticatedConnectionInitiallyEstablishedTimestamp() {
        return this.authenticatedConnectionInitiallyEstablishedTimestamp;
    }

    public void setParsingExceptionCallback(ParsingExceptionCallback parsingExceptionCallback) {
        this.parsingExceptionCallback = parsingExceptionCallback;
    }

    public ParsingExceptionCallback getParsingExceptionCallback() {
        return this.parsingExceptionCallback;
    }

    public final String toString() {
        Object object = this.getUser();
        object = object == null ? "not-authenticated" : object.toString();
        return this.getClass().getSimpleName() + '[' + (String)object + "] (" + this.getConnectionCounter() + ')';
    }

    protected void asyncGoLimited(final Runnable runnable) {
        runnable = new Runnable(){

            @Override
            public void run() {
                runnable.run();
                Queue queue = AbstractXMPPConnection.this.deferredAsyncRunnables;
                synchronized (queue) {
                    Runnable runnable2 = (Runnable)AbstractXMPPConnection.this.deferredAsyncRunnables.poll();
                    if (runnable2 == null) {
                        AbstractXMPPConnection.this.currentAsyncRunnables--;
                    } else {
                        AbstractXMPPConnection.this.deferredAsyncRunnablesCount--;
                        AbstractXMPPConnection.asyncGo(runnable2);
                    }
                    return;
                }
            }
        };
        Queue<Runnable> queue = this.deferredAsyncRunnables;
        synchronized (queue) {
            if (this.currentAsyncRunnables < this.maxAsyncRunnables) {
                ++this.currentAsyncRunnables;
                AbstractXMPPConnection.asyncGo(runnable);
            } else {
                ++this.deferredAsyncRunnablesCount;
                this.deferredAsyncRunnables.add(runnable);
            }
            int n = this.deferredAsyncRunnablesCount;
            if (n >= 100 && this.deferredAsyncRunnablesCountPrevious < 100) {
                LOGGER.log(Level.WARNING, "High watermark of 100 simultaneous executing runnables reached");
            } else if (n >= 20 && this.deferredAsyncRunnablesCountPrevious < 20) {
                LOGGER.log(Level.INFO, "20 simultaneous executing runnables reached");
            }
            this.deferredAsyncRunnablesCountPrevious = n;
            return;
        }
    }

    public void setMaxAsyncOperations(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Max async operations must be greater than 0");
        }
        Queue<Runnable> queue = this.deferredAsyncRunnables;
        synchronized (queue) {
            this.maxAsyncRunnables = n;
            return;
        }
    }

    protected static void asyncGo(Runnable runnable) {
        CACHED_EXECUTOR_SERVICE.execute(runnable);
    }

    protected final SmackReactor getReactor() {
        return SMACK_REACTOR;
    }

    protected static ScheduledAction schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        return SMACK_REACTOR.schedule(runnable, l, timeUnit, ScheduledAction.Kind.NonBlocking);
    }

    protected void onStreamOpen(XmlPullParser object) {
        if ("jabber:client".equals(object.getNamespace(null))) {
            this.streamId = object.getAttributeValue("", "id");
            this.incomingStreamXmlEnvironment = XmlEnvironment.from(object);
            if ((object = object.getAttributeValue("", "from")) == null) {
                return;
            }
            try {
                b b2 = org.e.a.a.d.f((String)object);
                b b3 = this.config.getXMPPServiceDomain();
                if (!b3.a((CharSequence)b2)) {
                    LOGGER.warning("Domain reported by server '" + b2 + "' does not match configured domain '" + b3 + "'");
                }
                return;
            }
            catch (org.e.b.c c2) {
                LOGGER.log(Level.WARNING, "XMPP service domain '" + (String)object + "' as reported by server could not be transformed to a valid JID", c2);
            }
        }
    }

    protected void sendStreamOpen() {
        Object object = this.getXMPPServiceDomain();
        Object object2 = null;
        CharSequence charSequence = this.config.getUsername();
        if (charSequence != null) {
            object2 = c.a((CharSequence)charSequence, (b)object);
        }
        charSequence = this.getStreamId();
        object = new StreamOpen((CharSequence)object, (CharSequence)object2, (String)charSequence, this.config.getXmlLang(), StreamOpen.StreamContentNamespace.client);
        this.sendNonza((Nonza)object);
        object2 = XmlEnvironment.builder();
        ((XmlEnvironment.Builder)object2).with((StreamOpen)object);
        this.outgoingStreamXmlEnvironment = ((XmlEnvironment.Builder)object2).build();
    }

    protected final SmackTlsContext getSmackTlsContext() {
        return this.config.smackTlsContext;
    }

    private static /* synthetic */ void lambda$invokeStanzaCollectorsAndNotifyRecvListeners$8(StanzaListener stanzaListener, Stanza stanza, Semaphore semaphore) {
        try {
            stanzaListener.processStanza(stanza);
            return;
        }
        catch (SmackException.NotConnectedException notConnectedException) {
            LOGGER.log(Level.WARNING, "Got not connected exception, aborting", notConnectedException);
            return;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Exception in packet listener", exception);
            return;
        }
        finally {
            semaphore.release();
        }
    }

    static {
        Smack.ensureInitialized();
        CACHED_EXECUTOR_SERVICE = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                runnable = new Thread(runnable);
                ((Thread)runnable).setName("Smack Cached Executor");
                ((Thread)runnable).setDaemon(true);
                ((Thread)runnable).setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable throwable) {
                        LOGGER.log(Level.WARNING, thread + " encountered uncaught exception", throwable);
                    }
                });
                return runnable;
            }
        });
        ASYNC_BUT_ORDERED = new AsyncButOrdered();
    }

    private static final class GenericInterceptorWrapper<MPB extends MessageOrPresenceBuilder<MP, MPB>, MP extends MessageOrPresence<MPB>> {
        private final Consumer<MPB> stanzaInterceptor;
        private final Predicate<MP> stanzaFilter;

        private GenericInterceptorWrapper(Consumer<MPB> consumer, Predicate<MP> predicate) {
            this.stanzaInterceptor = consumer;
            this.stanzaFilter = predicate;
        }

        private boolean filterMatches(MP MP) {
            return this.stanzaFilter == null || this.stanzaFilter.test(MP);
        }

        public final Consumer<MPB> getInterceptor() {
            return this.stanzaInterceptor;
        }
    }

    @Deprecated
    protected static class InterceptorWrapper {
        private final StanzaListener packetInterceptor;
        private final StanzaFilter packetFilter;

        public InterceptorWrapper(StanzaListener stanzaListener, StanzaFilter stanzaFilter) {
            this.packetInterceptor = stanzaListener;
            this.packetFilter = stanzaFilter;
        }

        public boolean filterMatches(Stanza stanza) {
            return this.packetFilter == null || this.packetFilter.accept(stanza);
        }

        public StanzaListener getInterceptor() {
            return this.packetInterceptor;
        }
    }

    protected static class ListenerWrapper {
        private final StanzaListener packetListener;
        private final StanzaFilter packetFilter;

        public ListenerWrapper(StanzaListener stanzaListener, StanzaFilter stanzaFilter) {
            this.packetListener = stanzaListener;
            this.packetFilter = stanzaFilter;
        }

        public boolean filterMatches(Stanza stanza) {
            return this.packetFilter == null || this.packetFilter.accept(stanza);
        }

        public StanzaListener getListener() {
            return this.packetListener;
        }
    }

    protected static enum SyncPointState {
        initial,
        request_sent,
        successful;

    }
}

