/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.jivesoftware.smack.AbstractXMPPConnection;

public class AsyncButOrdered<K> {
    private final Map<K, Queue<Runnable>> pendingRunnables = new WeakHashMap<K, Queue<Runnable>>();
    private final Map<K, Handler> threadActiveMap = new HashMap<K, Handler>();
    private final Executor executor;

    public AsyncButOrdered() {
        this(null);
    }

    public AsyncButOrdered(Executor executor) {
        this.executor = executor;
    }

    private void scheduleHandler(Handler handler) {
        if (this.executor == null) {
            AbstractXMPPConnection.asyncGo(handler);
            return;
        }
        this.executor.execute(handler);
    }

    public boolean performAsyncButOrdered(K k, Runnable object) {
        Queue<Runnable> queue;
        Object object2 = this.pendingRunnables;
        synchronized (object2) {
            queue = this.pendingRunnables.get(k);
            if (queue == null) {
                queue = new ConcurrentLinkedQueue<Runnable>();
                this.pendingRunnables.put(k, queue);
            }
        }
        queue.add((Runnable)object);
        object2 = null;
        object = this.threadActiveMap;
        synchronized (object) {
            if (!this.threadActiveMap.containsKey(k)) {
                object2 = new Handler(queue, k);
                this.threadActiveMap.put(k, (Handler)object2);
            }
        }
        if (object2 != null) {
            this.scheduleHandler((Handler)object2);
            return true;
        }
        return false;
    }

    public Executor asExecutorFor(final K k) {
        return new Executor(){

            @Override
            public void execute(Runnable runnable) {
                AsyncButOrdered.this.performAsyncButOrdered(k, runnable);
            }
        };
    }

    private class Handler
    implements Runnable {
        private final Queue<Runnable> keyQueue;
        private final K key;

        Handler(Queue<Runnable> queue, K k) {
            this.keyQueue = queue;
            this.key = k;
        }

        @Override
        public void run() {
            while (true) {
                Object object;
                if ((object = this.keyQueue.poll()) != null) {
                    try {
                        object.run();
                    }
                    catch (Throwable throwable) {
                        Handler handler = new Handler(this.keyQueue, this.key);
                        Map map = AsyncButOrdered.this.threadActiveMap;
                        synchronized (map) {
                            AsyncButOrdered.this.threadActiveMap.put(this.key, handler);
                        }
                        AsyncButOrdered.this.scheduleHandler(handler);
                        throw throwable;
                    }
                }
                object = AsyncButOrdered.this.threadActiveMap;
                synchronized (object) {
                    if (this.keyQueue.isEmpty()) {
                        AsyncButOrdered.this.threadActiveMap.remove(this.key);
                        return;
                    }
                }
            }
        }
    }
}

