/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.core;

import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.sasl.core.ScramHmac;
import org.jivesoftware.smack.sasl.core.ScramMechanism;
import org.jivesoftware.smack.util.TLSUtils;

public abstract class ScramPlusMechanism
extends ScramMechanism {
    protected ScramPlusMechanism(ScramHmac scramHmac) {
        super(scramHmac);
    }

    @Override
    public String getName() {
        return super.getName() + "-PLUS";
    }

    @Override
    protected String getGs2CbindFlag() {
        return "p=tls-server-end-point";
    }

    @Override
    protected byte[] getChannelBindingData() {
        byte[] byArray;
        try {
            byArray = TLSUtils.getChannelBindingTlsServerEndPoint(this.sslSession);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException | SSLPeerUnverifiedException exception) {
            throw new SmackException.SmackSaslException(exception);
        }
        return byArray;
    }
}

