/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LazyStringBuilder
implements Appendable,
CharSequence {
    private final List<CharSequence> list = new ArrayList<CharSequence>(20);
    private String cache;

    private void invalidateCache() {
        this.cache = null;
    }

    public LazyStringBuilder append(LazyStringBuilder lazyStringBuilder) {
        this.list.addAll(lazyStringBuilder.list);
        this.invalidateCache();
        return this;
    }

    @Override
    public LazyStringBuilder append(CharSequence charSequence) {
        assert (charSequence != null);
        this.list.add(charSequence);
        this.invalidateCache();
        return this;
    }

    @Override
    public LazyStringBuilder append(CharSequence charSequence, int n, int n2) {
        charSequence = charSequence.subSequence(n, n2);
        this.list.add(charSequence);
        this.invalidateCache();
        return this;
    }

    @Override
    public LazyStringBuilder append(char c2) {
        this.list.add(Character.toString(c2));
        this.invalidateCache();
        return this;
    }

    @Override
    public int length() {
        if (this.cache != null) {
            return this.cache.length();
        }
        int n = 0;
        try {
            for (CharSequence charSequence : this.list) {
                n += charSequence.length();
            }
        }
        catch (NullPointerException nullPointerException) {
            StringBuilder stringBuilder = this.safeToStringBuilder();
            throw new RuntimeException("The following LazyStringBuilder threw a NullPointerException:  " + stringBuilder, nullPointerException);
        }
        return n;
    }

    @Override
    public char charAt(int n) {
        if (this.cache != null) {
            return this.cache.charAt(n);
        }
        for (CharSequence charSequence : this.list) {
            if (n < charSequence.length()) {
                return charSequence.charAt(n);
            }
            n -= charSequence.length();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.toString().subSequence(n, n2);
    }

    @Override
    public String toString() {
        if (this.cache == null) {
            StringBuilder stringBuilder = new StringBuilder(this.length());
            for (CharSequence charSequence : this.list) {
                stringBuilder.append(charSequence);
            }
            this.cache = stringBuilder.toString();
        }
        return this.cache;
    }

    public StringBuilder safeToStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence charSequence : this.list) {
            stringBuilder.append(charSequence);
        }
        return stringBuilder;
    }

    public List<CharSequence> getAsList() {
        if (this.cache != null) {
            return Collections.singletonList(this.cache);
        }
        return Collections.unmodifiableList(this.list);
    }
}

