/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ControlFrameLimitEncoder;
import io.netty.handler.codec.http2.Http2EmptyDataFrameConnectionDecoder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2MaxRstFrameDecoder;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2PromisedRequestVerifier;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.StreamBufferingEncoder;
import io.netty.util.internal.ObjectUtil;

public abstract class AbstractHttp2ConnectionHandlerBuilder<T extends Http2ConnectionHandler, B extends AbstractHttp2ConnectionHandlerBuilder<T, B>> {
    private static final Http2HeadersEncoder.SensitivityDetector DEFAULT_HEADER_SENSITIVITY_DETECTOR = Http2HeadersEncoder.NEVER_SENSITIVE;
    private static final int DEFAULT_MAX_RST_FRAMES_PER_CONNECTION_FOR_SERVER = 200;
    private Http2Settings initialSettings = Http2Settings.defaultSettings();
    private Http2FrameListener frameListener;
    private long gracefulShutdownTimeoutMillis = Http2CodecUtil.DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS;
    private boolean decoupleCloseAndGoAway;
    private boolean flushPreface = true;
    private Boolean isServer;
    private Integer maxReservedStreams;
    private Http2Connection connection;
    private Http2ConnectionDecoder decoder;
    private Http2ConnectionEncoder encoder;
    private Boolean validateHeaders;
    private Http2FrameLogger frameLogger;
    private Http2HeadersEncoder.SensitivityDetector headerSensitivityDetector;
    private Boolean encoderEnforceMaxConcurrentStreams;
    private Boolean encoderIgnoreMaxHeaderListSize;
    private Http2PromisedRequestVerifier promisedRequestVerifier = Http2PromisedRequestVerifier.ALWAYS_VERIFY;
    private boolean autoAckSettingsFrame = true;
    private boolean autoAckPingFrame = true;
    private int maxQueuedControlFrames = 10000;
    private int maxConsecutiveEmptyFrames = 2;
    private Integer maxRstFramesPerWindow;
    private int secondsPerWindow = 30;

    protected Http2Settings initialSettings() {
        return this.initialSettings;
    }

    protected B initialSettings(Http2Settings http2Settings) {
        this.initialSettings = (Http2Settings)((Object)ObjectUtil.checkNotNull((Object)((Object)http2Settings), (String)"settings"));
        return this.self();
    }

    protected Http2FrameListener frameListener() {
        return this.frameListener;
    }

    protected B frameListener(Http2FrameListener http2FrameListener) {
        this.frameListener = (Http2FrameListener)ObjectUtil.checkNotNull((Object)http2FrameListener, (String)"frameListener");
        return this.self();
    }

    protected long gracefulShutdownTimeoutMillis() {
        return this.gracefulShutdownTimeoutMillis;
    }

    protected B gracefulShutdownTimeoutMillis(long l) {
        if (l < -1L) {
            throw new IllegalArgumentException("gracefulShutdownTimeoutMillis: " + l + " (expected: -1 for indefinite or >= 0)");
        }
        this.gracefulShutdownTimeoutMillis = l;
        return this.self();
    }

    protected boolean isServer() {
        if (this.isServer != null) {
            return this.isServer;
        }
        return true;
    }

    protected B server(boolean bl) {
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "connection", this.connection);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "codec", this.decoder);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "codec", this.encoder);
        this.isServer = bl;
        return this.self();
    }

    protected int maxReservedStreams() {
        if (this.maxReservedStreams != null) {
            return this.maxReservedStreams;
        }
        return 100;
    }

    protected B maxReservedStreams(int n) {
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "connection", this.connection);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "codec", this.decoder);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "codec", this.encoder);
        this.maxReservedStreams = ObjectUtil.checkPositiveOrZero((int)n, (String)"maxReservedStreams");
        return this.self();
    }

    protected Http2Connection connection() {
        return this.connection;
    }

    protected B connection(Http2Connection http2Connection) {
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("connection", "maxReservedStreams", this.maxReservedStreams);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("connection", "server", this.isServer);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("connection", "codec", this.decoder);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("connection", "codec", this.encoder);
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)http2Connection, (String)"connection");
        return this.self();
    }

    protected Http2ConnectionDecoder decoder() {
        return this.decoder;
    }

    protected Http2ConnectionEncoder encoder() {
        return this.encoder;
    }

    protected B codec(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder) {
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "server", this.isServer);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "maxReservedStreams", this.maxReservedStreams);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "connection", this.connection);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "frameLogger", (Object)this.frameLogger);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "validateHeaders", this.validateHeaders);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "headerSensitivityDetector", this.headerSensitivityDetector);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "encoderEnforceMaxConcurrentStreams", this.encoderEnforceMaxConcurrentStreams);
        ObjectUtil.checkNotNull((Object)http2ConnectionDecoder, (String)"decoder");
        ObjectUtil.checkNotNull((Object)http2ConnectionEncoder, (String)"encoder");
        if (http2ConnectionDecoder.connection() != http2ConnectionEncoder.connection()) {
            throw new IllegalArgumentException("The specified encoder and decoder have different connections.");
        }
        this.decoder = http2ConnectionDecoder;
        this.encoder = http2ConnectionEncoder;
        return this.self();
    }

    protected boolean isValidateHeaders() {
        if (this.validateHeaders != null) {
            return this.validateHeaders;
        }
        return true;
    }

    protected B validateHeaders(boolean bl) {
        this.enforceNonCodecConstraints("validateHeaders");
        this.validateHeaders = bl;
        return this.self();
    }

    protected Http2FrameLogger frameLogger() {
        return this.frameLogger;
    }

    protected B frameLogger(Http2FrameLogger http2FrameLogger) {
        this.enforceNonCodecConstraints("frameLogger");
        this.frameLogger = (Http2FrameLogger)((Object)ObjectUtil.checkNotNull((Object)((Object)http2FrameLogger), (String)"frameLogger"));
        return this.self();
    }

    protected boolean encoderEnforceMaxConcurrentStreams() {
        if (this.encoderEnforceMaxConcurrentStreams != null) {
            return this.encoderEnforceMaxConcurrentStreams;
        }
        return false;
    }

    protected B encoderEnforceMaxConcurrentStreams(boolean bl) {
        this.enforceNonCodecConstraints("encoderEnforceMaxConcurrentStreams");
        this.encoderEnforceMaxConcurrentStreams = bl;
        return this.self();
    }

    protected int encoderEnforceMaxQueuedControlFrames() {
        return this.maxQueuedControlFrames;
    }

    protected B encoderEnforceMaxQueuedControlFrames(int n) {
        this.enforceNonCodecConstraints("encoderEnforceMaxQueuedControlFrames");
        this.maxQueuedControlFrames = ObjectUtil.checkPositiveOrZero((int)n, (String)"maxQueuedControlFrames");
        return this.self();
    }

    protected Http2HeadersEncoder.SensitivityDetector headerSensitivityDetector() {
        if (this.headerSensitivityDetector != null) {
            return this.headerSensitivityDetector;
        }
        return DEFAULT_HEADER_SENSITIVITY_DETECTOR;
    }

    protected B headerSensitivityDetector(Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        this.enforceNonCodecConstraints("headerSensitivityDetector");
        this.headerSensitivityDetector = (Http2HeadersEncoder.SensitivityDetector)ObjectUtil.checkNotNull((Object)sensitivityDetector, (String)"headerSensitivityDetector");
        return this.self();
    }

    protected B encoderIgnoreMaxHeaderListSize(boolean bl) {
        this.enforceNonCodecConstraints("encoderIgnoreMaxHeaderListSize");
        this.encoderIgnoreMaxHeaderListSize = bl;
        return this.self();
    }

    @Deprecated
    protected B initialHuffmanDecodeCapacity(int n) {
        return this.self();
    }

    protected B promisedRequestVerifier(Http2PromisedRequestVerifier http2PromisedRequestVerifier) {
        this.enforceNonCodecConstraints("promisedRequestVerifier");
        this.promisedRequestVerifier = (Http2PromisedRequestVerifier)ObjectUtil.checkNotNull((Object)http2PromisedRequestVerifier, (String)"promisedRequestVerifier");
        return this.self();
    }

    protected Http2PromisedRequestVerifier promisedRequestVerifier() {
        return this.promisedRequestVerifier;
    }

    protected int decoderEnforceMaxConsecutiveEmptyDataFrames() {
        return this.maxConsecutiveEmptyFrames;
    }

    protected B decoderEnforceMaxConsecutiveEmptyDataFrames(int n) {
        this.enforceNonCodecConstraints("maxConsecutiveEmptyFrames");
        this.maxConsecutiveEmptyFrames = ObjectUtil.checkPositiveOrZero((int)n, (String)"maxConsecutiveEmptyFrames");
        return this.self();
    }

    protected B decoderEnforceMaxRstFramesPerWindow(int n, int n2) {
        this.enforceNonCodecConstraints("decoderEnforceMaxRstFramesPerWindow");
        this.maxRstFramesPerWindow = ObjectUtil.checkPositiveOrZero((int)n, (String)"maxRstFramesPerWindow");
        this.secondsPerWindow = ObjectUtil.checkPositiveOrZero((int)n2, (String)"secondsPerWindow");
        return this.self();
    }

    protected B autoAckSettingsFrame(boolean bl) {
        this.enforceNonCodecConstraints("autoAckSettingsFrame");
        this.autoAckSettingsFrame = bl;
        return this.self();
    }

    protected boolean isAutoAckSettingsFrame() {
        return this.autoAckSettingsFrame;
    }

    protected B autoAckPingFrame(boolean bl) {
        this.enforceNonCodecConstraints("autoAckPingFrame");
        this.autoAckPingFrame = bl;
        return this.self();
    }

    protected boolean isAutoAckPingFrame() {
        return this.autoAckPingFrame;
    }

    protected B decoupleCloseAndGoAway(boolean bl) {
        this.decoupleCloseAndGoAway = bl;
        return this.self();
    }

    protected boolean decoupleCloseAndGoAway() {
        return this.decoupleCloseAndGoAway;
    }

    protected B flushPreface(boolean bl) {
        this.flushPreface = bl;
        return this.self();
    }

    protected boolean flushPreface() {
        return this.flushPreface;
    }

    protected T build() {
        if (this.encoder != null) {
            assert (this.decoder != null);
            AbstractHttp2ConnectionHandlerBuilder abstractHttp2ConnectionHandlerBuilder = this;
            return abstractHttp2ConnectionHandlerBuilder.buildFromCodec(abstractHttp2ConnectionHandlerBuilder.decoder, this.encoder);
        }
        Http2Connection http2Connection = this.connection;
        if (http2Connection == null) {
            http2Connection = new DefaultHttp2Connection(this.isServer(), this.maxReservedStreams());
        }
        return this.buildFromConnection(http2Connection);
    }

    private T buildFromConnection(Http2Connection object) {
        Http2FrameWriter http2FrameWriter;
        Object object2 = this.initialSettings.maxHeaderListSize();
        object2 = new DefaultHttp2FrameReader(new DefaultHttp2HeadersDecoder(this.isValidateHeaders(), object2 == null ? 8192L : (Long)object2, -1));
        DefaultHttp2FrameWriter defaultHttp2FrameWriter = http2FrameWriter = this.encoderIgnoreMaxHeaderListSize == null ? new DefaultHttp2FrameWriter(this.headerSensitivityDetector()) : new DefaultHttp2FrameWriter(this.headerSensitivityDetector(), this.encoderIgnoreMaxHeaderListSize);
        if (this.frameLogger != null) {
            object2 = new Http2InboundFrameLogger((Http2FrameReader)object2, this.frameLogger);
            http2FrameWriter = new Http2OutboundFrameLogger(http2FrameWriter, this.frameLogger);
        }
        http2FrameWriter = new DefaultHttp2ConnectionEncoder((Http2Connection)object, http2FrameWriter);
        boolean bl = this.encoderEnforceMaxConcurrentStreams();
        if (this.maxQueuedControlFrames != 0) {
            http2FrameWriter = new Http2ControlFrameLimitEncoder((Http2ConnectionEncoder)http2FrameWriter, this.maxQueuedControlFrames);
        }
        if (bl) {
            if (object.isServer()) {
                http2FrameWriter.close();
                object2.close();
                throw new IllegalArgumentException("encoderEnforceMaxConcurrentStreams: " + bl + " not supported for server");
            }
            http2FrameWriter = new StreamBufferingEncoder((Http2ConnectionEncoder)http2FrameWriter);
        }
        object = new DefaultHttp2ConnectionDecoder((Http2Connection)object, (Http2ConnectionEncoder)http2FrameWriter, (Http2FrameReader)object2, this.promisedRequestVerifier(), this.isAutoAckSettingsFrame(), this.isAutoAckPingFrame(), this.isValidateHeaders());
        return this.buildFromCodec((Http2ConnectionDecoder)object, (Http2ConnectionEncoder)http2FrameWriter);
    }

    private T buildFromCodec(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder) {
        T t;
        int n = this.decoderEnforceMaxConsecutiveEmptyDataFrames();
        if (n > 0) {
            http2ConnectionDecoder = new Http2EmptyDataFrameConnectionDecoder(http2ConnectionDecoder, n);
        }
        n = this.maxRstFramesPerWindow == null ? (this.isServer() ? 200 : 0) : this.maxRstFramesPerWindow;
        if (n > 0 && this.secondsPerWindow > 0) {
            http2ConnectionDecoder = new Http2MaxRstFrameDecoder(http2ConnectionDecoder, n, this.secondsPerWindow);
        }
        try {
            t = this.build(http2ConnectionDecoder, http2ConnectionEncoder, this.initialSettings);
        }
        catch (Throwable throwable) {
            http2ConnectionEncoder.close();
            http2ConnectionDecoder.close();
            throw new IllegalStateException("failed to build an Http2ConnectionHandler", throwable);
        }
        ((Http2ConnectionHandler)t).gracefulShutdownTimeoutMillis(this.gracefulShutdownTimeoutMillis);
        if (((Http2ConnectionHandler)t).decoder().frameListener() == null) {
            ((Http2ConnectionHandler)t).decoder().frameListener(this.frameListener);
        }
        return t;
    }

    protected abstract T build(Http2ConnectionDecoder var1, Http2ConnectionEncoder var2, Http2Settings var3);

    protected final B self() {
        return (B)this;
    }

    private void enforceNonCodecConstraints(String string) {
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint(string, "server/connection", this.decoder);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint(string, "server/connection", this.encoder);
    }

    private static void enforceConstraint(String string, String string2, Object object) {
        if (object != null) {
            throw new IllegalStateException(string + "() cannot be called because " + string2 + "() has been called already.");
        }
    }
}

