/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class DefaultHttp2Connection
implements Http2Connection {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2Connection.class);
    final IntObjectMap<Http2Stream> streamMap = new IntObjectHashMap();
    final PropertyKeyRegistry propertyKeyRegistry = new PropertyKeyRegistry();
    final ConnectionStream connectionStream = new ConnectionStream();
    final DefaultEndpoint<Http2LocalFlowController> localEndpoint;
    final DefaultEndpoint<Http2RemoteFlowController> remoteEndpoint;
    final List<Http2Connection.Listener> listeners = new ArrayList<Http2Connection.Listener>(4);
    final ActiveStreams activeStreams;
    Promise<Void> closePromise;

    public DefaultHttp2Connection(boolean bl) {
        this(bl, 100);
    }

    public DefaultHttp2Connection(boolean bl, int n) {
        DefaultHttp2Connection defaultHttp2Connection = this;
        this.activeStreams = defaultHttp2Connection.new ActiveStreams(defaultHttp2Connection.listeners);
        boolean bl2 = bl;
        this.localEndpoint = new DefaultEndpoint(bl2, bl2 ? Integer.MAX_VALUE : n);
        this.remoteEndpoint = new DefaultEndpoint(!bl, n);
        this.streamMap.put(this.connectionStream.id(), (Object)this.connectionStream);
    }

    final boolean isClosed() {
        return this.closePromise != null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Future<Void> close(Promise<Void> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addListener(Http2Connection.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Http2Connection.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isServer() {
        return this.localEndpoint.isServer();
    }

    @Override
    public Http2Stream connectionStream() {
        return this.connectionStream;
    }

    @Override
    public Http2Stream stream(int n) {
        return (Http2Stream)this.streamMap.get(n);
    }

    @Override
    public boolean streamMayHaveExisted(int n) {
        return this.remoteEndpoint.mayHaveCreatedStream(n) || this.localEndpoint.mayHaveCreatedStream(n);
    }

    @Override
    public int numActiveStreams() {
        return this.activeStreams.size();
    }

    @Override
    public Http2Stream forEachActiveStream(Http2StreamVisitor http2StreamVisitor) {
        return this.activeStreams.forEachActiveStream(http2StreamVisitor);
    }

    @Override
    public Http2Connection.Endpoint<Http2LocalFlowController> local() {
        return this.localEndpoint;
    }

    @Override
    public Http2Connection.Endpoint<Http2RemoteFlowController> remote() {
        return this.remoteEndpoint;
    }

    @Override
    public boolean goAwayReceived() {
        return ((DefaultEndpoint)this.localEndpoint).lastStreamKnownByPeer >= 0;
    }

    @Override
    public void goAwayReceived(int n, long l, ByteBuf byteBuf) {
        if (this.localEndpoint.lastStreamKnownByPeer() >= 0 && this.localEndpoint.lastStreamKnownByPeer() < n) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "lastStreamId MUST NOT increase. Current value: %d new value: %d", this.localEndpoint.lastStreamKnownByPeer(), n);
        }
        ((DefaultEndpoint)this.localEndpoint).lastStreamKnownByPeer(n);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onGoAwayReceived(n, l, byteBuf);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onGoAwayReceived.", throwable);
            }
        }
        this.closeStreamsGreaterThanLastKnownStreamId(n, this.localEndpoint);
    }

    @Override
    public boolean goAwaySent() {
        return ((DefaultEndpoint)this.remoteEndpoint).lastStreamKnownByPeer >= 0;
    }

    @Override
    public boolean goAwaySent(int n, long l, ByteBuf byteBuf) {
        if (this.remoteEndpoint.lastStreamKnownByPeer() >= 0) {
            if (n == this.remoteEndpoint.lastStreamKnownByPeer()) {
                return false;
            }
            if (n > this.remoteEndpoint.lastStreamKnownByPeer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Last stream identifier must not increase between sending multiple GOAWAY frames (was '%d', is '%d').", this.remoteEndpoint.lastStreamKnownByPeer(), n);
            }
        }
        ((DefaultEndpoint)this.remoteEndpoint).lastStreamKnownByPeer(n);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onGoAwaySent(n, l, byteBuf);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onGoAwaySent.", throwable);
            }
        }
        this.closeStreamsGreaterThanLastKnownStreamId(n, this.remoteEndpoint);
        return true;
    }

    private void closeStreamsGreaterThanLastKnownStreamId(final int n, final DefaultEndpoint<?> defaultEndpoint) {
        this.forEachActiveStream(new Http2StreamVisitor(){

            @Override
            public boolean visit(Http2Stream http2Stream) {
                if (http2Stream.id() > n && defaultEndpoint.isValidStreamId(http2Stream.id())) {
                    http2Stream.close();
                }
                return true;
            }
        });
    }

    private boolean isStreamMapEmpty() {
        return this.streamMap.size() == 1;
    }

    void removeStream(DefaultStream defaultStream, Iterator<?> iterator) {
        int n;
        if (iterator == null) {
            n = this.streamMap.remove(defaultStream.id()) != null ? 1 : 0;
        } else {
            iterator.remove();
            n = 1;
        }
        if (n != 0) {
            for (n = 0; n < this.listeners.size(); ++n) {
                try {
                    this.listeners.get(n).onStreamRemoved(defaultStream);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.error("Caught Throwable from listener onStreamRemoved.", throwable);
                }
            }
            if (this.closePromise != null && this.isStreamMapEmpty()) {
                this.closePromise.trySuccess(null);
            }
        }
    }

    static Http2Stream.State activeState(int n, Http2Stream.State state, boolean bl, boolean bl2) {
        switch (state) {
            case IDLE: {
                if (bl2) {
                    if (bl) {
                        return Http2Stream.State.HALF_CLOSED_LOCAL;
                    }
                    return Http2Stream.State.HALF_CLOSED_REMOTE;
                }
                return Http2Stream.State.OPEN;
            }
            case RESERVED_LOCAL: {
                return Http2Stream.State.HALF_CLOSED_REMOTE;
            }
            case RESERVED_REMOTE: {
                return Http2Stream.State.HALF_CLOSED_LOCAL;
            }
        }
        throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Attempting to open a stream in an invalid state: " + (Object)((Object)state), new Object[0]);
    }

    void notifyHalfClosed(Http2Stream http2Stream) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onStreamHalfClosed(http2Stream);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onStreamHalfClosed.", throwable);
            }
        }
    }

    void notifyClosed(Http2Stream http2Stream) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onStreamClosed(http2Stream);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onStreamClosed.", throwable);
            }
        }
    }

    @Override
    public Http2Connection.PropertyKey newKey() {
        return this.propertyKeyRegistry.newKey();
    }

    final DefaultPropertyKey verifyKey(Http2Connection.PropertyKey propertyKey) {
        return ((DefaultPropertyKey)ObjectUtil.checkNotNull((Object)((DefaultPropertyKey)propertyKey), (String)"key")).verifyConnection(this);
    }

    private final class PropertyKeyRegistry {
        final List<DefaultPropertyKey> keys = new ArrayList<DefaultPropertyKey>(4);

        private PropertyKeyRegistry() {
        }

        final DefaultPropertyKey newKey() {
            DefaultPropertyKey defaultPropertyKey = new DefaultPropertyKey(this.keys.size());
            this.keys.add(defaultPropertyKey);
            return defaultPropertyKey;
        }

        final int size() {
            return this.keys.size();
        }
    }

    final class DefaultPropertyKey
    implements Http2Connection.PropertyKey {
        final int index;

        DefaultPropertyKey(int n) {
            this.index = n;
        }

        final DefaultPropertyKey verifyConnection(Http2Connection http2Connection) {
            if (http2Connection != DefaultHttp2Connection.this) {
                throw new IllegalArgumentException("Using a key that was not created by this connection");
            }
            return this;
        }
    }

    private final class ActiveStreams {
        private final List<Http2Connection.Listener> listeners;
        private final Queue<Event> pendingEvents = new ArrayDeque<Event>(4);
        private final Set<Http2Stream> streams = new LinkedHashSet<Http2Stream>();
        private int pendingIterations;

        ActiveStreams(List<Http2Connection.Listener> list) {
            this.listeners = list;
        }

        public final int size() {
            return this.streams.size();
        }

        public final void activate(final DefaultStream defaultStream) {
            if (this.allowModifications()) {
                this.addToActiveStreams(defaultStream);
                return;
            }
            this.pendingEvents.add(new Event(){

                @Override
                public void process() {
                    ActiveStreams.this.addToActiveStreams(defaultStream);
                }
            });
        }

        public final void deactivate(final DefaultStream defaultStream, final Iterator<?> iterator) {
            if (this.allowModifications() || iterator != null) {
                this.removeFromActiveStreams(defaultStream, iterator);
                return;
            }
            this.pendingEvents.add(new Event(){

                @Override
                public void process() {
                    ActiveStreams.this.removeFromActiveStreams(defaultStream, iterator);
                }
            });
        }

        public final Http2Stream forEachActiveStream(Http2StreamVisitor object) {
            this.incrementPendingIterations();
            try {
                for (Http2Stream http2Stream : this.streams) {
                    if (object.visit(http2Stream)) continue;
                    object = http2Stream;
                    return object;
                }
                return null;
            }
            finally {
                this.decrementPendingIterations();
            }
        }

        final void addToActiveStreams(DefaultStream defaultStream) {
            if (this.streams.add(defaultStream)) {
                ++defaultStream.createdBy().numActiveStreams;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    try {
                        this.listeners.get(i).onStreamActive(defaultStream);
                        continue;
                    }
                    catch (Throwable throwable) {
                        logger.error("Caught Throwable from listener onStreamActive.", throwable);
                    }
                }
            }
        }

        final void removeFromActiveStreams(DefaultStream defaultStream, Iterator<?> iterator) {
            if (this.streams.remove(defaultStream)) {
                --defaultStream.createdBy().numActiveStreams;
                DefaultHttp2Connection.this.notifyClosed(defaultStream);
            }
            DefaultHttp2Connection.this.removeStream(defaultStream, iterator);
        }

        final boolean allowModifications() {
            return this.pendingIterations == 0;
        }

        final void incrementPendingIterations() {
            ++this.pendingIterations;
        }

        final void decrementPendingIterations() {
            --this.pendingIterations;
            if (this.allowModifications()) {
                Event event;
                while ((event = this.pendingEvents.poll()) != null) {
                    try {
                        event.process();
                    }
                    catch (Throwable throwable) {
                        logger.error("Caught Throwable while processing pending ActiveStreams$Event.", throwable);
                    }
                }
            }
        }
    }

    static interface Event {
        public void process();
    }

    private final class DefaultEndpoint<F extends Http2FlowController>
    implements Http2Connection.Endpoint<F> {
        private final boolean server;
        private long lastCreatedStreamIdentity = 0L;
        private int nextStreamIdToCreate;
        private int nextReservationStreamId;
        private int lastStreamKnownByPeer = -1;
        private boolean pushToAllowed;
        private F flowController;
        private int maxStreams;
        private int maxActiveStreams;
        private final int maxReservedStreams;
        int numActiveStreams;
        int numStreams;

        DefaultEndpoint(boolean bl, int n) {
            this.server = bl;
            if (bl) {
                this.nextStreamIdToCreate = 2;
                this.nextReservationStreamId = 0;
            } else {
                this.nextStreamIdToCreate = 1;
                this.nextReservationStreamId = 1;
            }
            this.pushToAllowed = !bl;
            this.maxActiveStreams = Integer.MAX_VALUE;
            this.maxReservedStreams = ObjectUtil.checkPositiveOrZero((int)n, (String)"maxReservedStreams");
            this.updateMaxStreams();
        }

        @Override
        public final int incrementAndGetNextStreamId() {
            if (this.nextReservationStreamId >= 0) {
                return this.nextReservationStreamId += 2;
            }
            return this.nextReservationStreamId;
        }

        private void incrementExpectedStreamId(int n) {
            if (n > this.nextReservationStreamId && this.nextReservationStreamId >= 0) {
                this.nextReservationStreamId = n;
            }
            this.nextStreamIdToCreate = n + 2;
            ++this.numStreams;
        }

        @Override
        public final boolean isValidStreamId(int n) {
            return n > 0 && this.server == ((n & 1) == 0);
        }

        @Override
        public final boolean mayHaveCreatedStream(int n) {
            return this.isValidStreamId(n) && n <= this.lastStreamCreated();
        }

        @Override
        public final boolean canOpenStream() {
            return this.numActiveStreams < this.maxActiveStreams;
        }

        @Override
        public final DefaultStream createStream(int n, boolean bl) {
            Object object = DefaultHttp2Connection.activeState(n, Http2Stream.State.IDLE, this.isLocal(), bl);
            this.checkNewStreamAllowed(n, (Http2Stream.State)((Object)object));
            ++this.lastCreatedStreamIdentity;
            object = new DefaultStream(this.lastCreatedStreamIdentity, n, (Http2Stream.State)((Object)object));
            this.incrementExpectedStreamId(n);
            this.addStream((DefaultStream)object);
            ((DefaultStream)object).activate();
            return object;
        }

        @Override
        public final boolean created(Http2Stream http2Stream) {
            return http2Stream instanceof DefaultStream && ((DefaultStream)http2Stream).createdBy() == this;
        }

        @Override
        public final boolean isServer() {
            return this.server;
        }

        @Override
        public final DefaultStream reservePushStream(int n, Http2Stream object) {
            if (object == null) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Parent stream missing", new Object[0]);
            }
            if (this.isLocal() ? !object.state().localSideOpen() : !object.state().remoteSideOpen()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d is not open for sending push promise", object.id());
            }
            if (!this.opposite().allowPushTo()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server push not allowed to opposite endpoint", new Object[0]);
            }
            object = this.isLocal() ? Http2Stream.State.RESERVED_LOCAL : Http2Stream.State.RESERVED_REMOTE;
            this.checkNewStreamAllowed(n, (Http2Stream.State)((Object)object));
            ++this.lastCreatedStreamIdentity;
            object = new DefaultStream(this.lastCreatedStreamIdentity, n, (Http2Stream.State)((Object)object));
            this.incrementExpectedStreamId(n);
            this.addStream((DefaultStream)object);
            return object;
        }

        private void addStream(DefaultStream defaultStream) {
            DefaultHttp2Connection.this.streamMap.put(defaultStream.id(), (Object)defaultStream);
            for (int i = 0; i < DefaultHttp2Connection.this.listeners.size(); ++i) {
                try {
                    DefaultHttp2Connection.this.listeners.get(i).onStreamAdded(defaultStream);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.error("Caught Throwable from listener onStreamAdded.", throwable);
                }
            }
        }

        @Override
        public final void allowPushTo(boolean bl) {
            if (bl && this.server) {
                throw new IllegalArgumentException("Servers do not allow push");
            }
            this.pushToAllowed = bl;
        }

        @Override
        public final boolean allowPushTo() {
            return this.pushToAllowed;
        }

        @Override
        public final int numActiveStreams() {
            return this.numActiveStreams;
        }

        @Override
        public final int maxActiveStreams() {
            return this.maxActiveStreams;
        }

        @Override
        public final void maxActiveStreams(int n) {
            this.maxActiveStreams = n;
            this.updateMaxStreams();
        }

        @Override
        public final int lastStreamCreated() {
            return Math.max(0, this.nextStreamIdToCreate - 2);
        }

        @Override
        public final int lastStreamKnownByPeer() {
            return this.lastStreamKnownByPeer;
        }

        private void lastStreamKnownByPeer(int n) {
            this.lastStreamKnownByPeer = n;
        }

        @Override
        public final F flowController() {
            return this.flowController;
        }

        @Override
        public final void flowController(F f) {
            this.flowController = (Http2FlowController)ObjectUtil.checkNotNull(f, (String)"flowController");
        }

        @Override
        public final Http2Connection.Endpoint<? extends Http2FlowController> opposite() {
            if (this.isLocal()) {
                return DefaultHttp2Connection.this.remoteEndpoint;
            }
            return DefaultHttp2Connection.this.localEndpoint;
        }

        private void updateMaxStreams() {
            this.maxStreams = (int)Math.min(Integer.MAX_VALUE, (long)this.maxActiveStreams + (long)this.maxReservedStreams);
        }

        private void checkNewStreamAllowed(int n, Http2Stream.State state) {
            assert (state != Http2Stream.State.IDLE);
            if (this.lastStreamKnownByPeer >= 0 && n > this.lastStreamKnownByPeer) {
                throw Http2Exception.streamError(n, Http2Error.REFUSED_STREAM, "Cannot create stream %d greater than Last-Stream-ID %d from GOAWAY.", n, this.lastStreamKnownByPeer);
            }
            if (!this.isValidStreamId(n)) {
                if (n < 0) {
                    throw new Http2NoMoreStreamIdsException();
                }
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Request stream %d is not correct for %s connection", n, this.server ? "server" : "client");
            }
            if (n < this.nextStreamIdToCreate) {
                throw Http2Exception.closedStreamError(Http2Error.PROTOCOL_ERROR, "Request stream %d is behind the next expected stream %d", n, this.nextStreamIdToCreate);
            }
            if (this.nextStreamIdToCreate <= 0) {
                throw new Http2Exception(Http2Error.REFUSED_STREAM, "Stream IDs are exhausted for this endpoint.", Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN);
            }
            boolean bl = state == Http2Stream.State.RESERVED_LOCAL || state == Http2Stream.State.RESERVED_REMOTE;
            if (!bl && !this.canOpenStream() || bl && this.numStreams >= this.maxStreams) {
                throw Http2Exception.streamError(n, Http2Error.REFUSED_STREAM, "Maximum active streams violated for this endpoint: " + (bl ? this.maxStreams : this.maxActiveStreams), new Object[0]);
            }
            if (DefaultHttp2Connection.this.isClosed()) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Attempted to create stream id %d after connection was closed", n);
            }
        }

        private boolean isLocal() {
            DefaultEndpoint defaultEndpoint = this;
            return defaultEndpoint == defaultEndpoint.DefaultHttp2Connection.this.localEndpoint;
        }
    }

    private final class ConnectionStream
    extends DefaultStream {
        ConnectionStream() {
            super(0L, 0, Http2Stream.State.IDLE);
        }

        @Override
        public final boolean isResetSent() {
            return false;
        }

        @Override
        final DefaultEndpoint<? extends Http2FlowController> createdBy() {
            return null;
        }

        @Override
        public final Http2Stream resetSent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream open(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream closeLocalSide() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream closeRemoteSide() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream headersSent(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isHeadersSent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream pushPromiseSent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isPushPromiseSent() {
            throw new UnsupportedOperationException();
        }
    }

    private class DefaultStream
    implements Http2Stream {
        private static final byte META_STATE_SENT_RST = 1;
        private static final byte META_STATE_SENT_HEADERS = 2;
        private static final byte META_STATE_SENT_TRAILERS = 4;
        private static final byte META_STATE_SENT_PUSHPROMISE = 8;
        private static final byte META_STATE_RECV_HEADERS = 16;
        private static final byte META_STATE_RECV_TRAILERS = 32;
        private final int id;
        private final long identity;
        private final PropertyMap properties = new PropertyMap();
        private Http2Stream.State state;
        private byte metaState;

        DefaultStream(long l, int n, Http2Stream.State state) {
            this.identity = l;
            this.id = n;
            this.state = state;
        }

        @Override
        public final int id() {
            return this.id;
        }

        @Override
        public final Http2Stream.State state() {
            return this.state;
        }

        @Override
        public boolean isResetSent() {
            return (this.metaState & 1) != 0;
        }

        @Override
        public Http2Stream resetSent() {
            this.metaState = (byte)(this.metaState | 1);
            return this;
        }

        @Override
        public Http2Stream headersSent(boolean bl) {
            if (!bl) {
                this.metaState = (byte)(this.metaState | (this.isHeadersSent() ? 4 : 2));
            }
            return this;
        }

        @Override
        public boolean isHeadersSent() {
            return (this.metaState & 2) != 0;
        }

        @Override
        public boolean isTrailersSent() {
            return (this.metaState & 4) != 0;
        }

        @Override
        public Http2Stream headersReceived(boolean bl) {
            if (!bl) {
                this.metaState = (byte)(this.metaState | (this.isHeadersReceived() ? 32 : 16));
            }
            return this;
        }

        @Override
        public boolean isHeadersReceived() {
            return (this.metaState & 0x10) != 0;
        }

        @Override
        public boolean isTrailersReceived() {
            return (this.metaState & 0x20) != 0;
        }

        @Override
        public Http2Stream pushPromiseSent() {
            this.metaState = (byte)(this.metaState | 8);
            return this;
        }

        @Override
        public boolean isPushPromiseSent() {
            return (this.metaState & 8) != 0;
        }

        @Override
        public final <V> V setProperty(Http2Connection.PropertyKey propertyKey, V v) {
            return this.properties.add(DefaultHttp2Connection.this.verifyKey(propertyKey), v);
        }

        @Override
        public final <V> V getProperty(Http2Connection.PropertyKey propertyKey) {
            return this.properties.get(DefaultHttp2Connection.this.verifyKey(propertyKey));
        }

        @Override
        public final <V> V removeProperty(Http2Connection.PropertyKey propertyKey) {
            return this.properties.remove(DefaultHttp2Connection.this.verifyKey(propertyKey));
        }

        @Override
        public Http2Stream open(boolean bl) {
            this.state = DefaultHttp2Connection.activeState(this.id, this.state, this.isLocal(), bl);
            DefaultEndpoint<? extends Http2FlowController> defaultEndpoint = this.createdBy();
            if (!defaultEndpoint.canOpenStream()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Maximum active streams violated for this endpoint: " + defaultEndpoint.maxActiveStreams(), new Object[0]);
            }
            this.activate();
            return this;
        }

        void activate() {
            if (this.state == Http2Stream.State.HALF_CLOSED_LOCAL) {
                this.headersSent(false);
            } else if (this.state == Http2Stream.State.HALF_CLOSED_REMOTE) {
                this.headersReceived(false);
            }
            DefaultHttp2Connection.this.activeStreams.activate(this);
        }

        Http2Stream close(Iterator<?> iterator) {
            if (this.state == Http2Stream.State.CLOSED) {
                return this;
            }
            this.state = Http2Stream.State.CLOSED;
            --this.createdBy().numStreams;
            DefaultHttp2Connection.this.activeStreams.deactivate(this, iterator);
            return this;
        }

        @Override
        public Http2Stream close() {
            return this.close(null);
        }

        @Override
        public Http2Stream closeLocalSide() {
            switch (this.state) {
                case OPEN: {
                    this.state = Http2Stream.State.HALF_CLOSED_LOCAL;
                    DefaultHttp2Connection.this.notifyHalfClosed(this);
                    break;
                }
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                default: {
                    this.close();
                }
            }
            return this;
        }

        @Override
        public Http2Stream closeRemoteSide() {
            switch (this.state) {
                case OPEN: {
                    this.state = Http2Stream.State.HALF_CLOSED_REMOTE;
                    DefaultHttp2Connection.this.notifyHalfClosed(this);
                    break;
                }
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    this.close();
                }
            }
            return this;
        }

        DefaultEndpoint<? extends Http2FlowController> createdBy() {
            if (DefaultHttp2Connection.this.localEndpoint.isValidStreamId(this.id)) {
                return DefaultHttp2Connection.this.localEndpoint;
            }
            return DefaultHttp2Connection.this.remoteEndpoint;
        }

        final boolean isLocal() {
            return DefaultHttp2Connection.this.localEndpoint.isValidStreamId(this.id);
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            long l = this.identity;
            if (l == 0L) {
                return System.identityHashCode(this);
            }
            long l2 = l;
            return (int)(l2 ^ l2 >>> 32);
        }

        private class PropertyMap {
            Object[] values = EmptyArrays.EMPTY_OBJECTS;

            private PropertyMap() {
            }

            <V> V add(DefaultPropertyKey defaultPropertyKey, V v) {
                this.resizeIfNecessary(defaultPropertyKey.index);
                Object object = this.values[defaultPropertyKey.index];
                this.values[defaultPropertyKey.index] = v;
                return (V)object;
            }

            <V> V get(DefaultPropertyKey defaultPropertyKey) {
                if (defaultPropertyKey.index >= this.values.length) {
                    return null;
                }
                return (V)this.values[defaultPropertyKey.index];
            }

            <V> V remove(DefaultPropertyKey defaultPropertyKey) {
                Object object = null;
                if (defaultPropertyKey.index < this.values.length) {
                    object = this.values[defaultPropertyKey.index];
                    this.values[defaultPropertyKey.index] = null;
                }
                return (V)object;
            }

            void resizeIfNecessary(int n) {
                if (n >= this.values.length) {
                    this.values = Arrays.copyOf(this.values, DefaultHttp2Connection.this.propertyKeyRegistry.size());
                }
            }
        }
    }
}

