/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;

public final class Http2DataChunkedInput
implements ChunkedInput<Http2DataFrame> {
    private final ChunkedInput<ByteBuf> input;
    private final Http2FrameStream stream;
    private boolean endStreamSent;

    public Http2DataChunkedInput(ChunkedInput<ByteBuf> chunkedInput, Http2FrameStream http2FrameStream) {
        this.input = (ChunkedInput)ObjectUtil.checkNotNull(chunkedInput, (String)"input");
        this.stream = (Http2FrameStream)ObjectUtil.checkNotNull((Object)http2FrameStream, (String)"stream");
    }

    public final boolean isEndOfInput() {
        if (this.input.isEndOfInput()) {
            return this.endStreamSent;
        }
        return false;
    }

    public final void close() {
        this.input.close();
    }

    @Deprecated
    public final Http2DataFrame readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    public final Http2DataFrame readChunk(ByteBufAllocator object) {
        if (this.endStreamSent) {
            return null;
        }
        if (this.input.isEndOfInput()) {
            this.endStreamSent = true;
            return new DefaultHttp2DataFrame(true).stream(this.stream);
        }
        if ((object = (ByteBuf)this.input.readChunk(object)) == null) {
            return null;
        }
        if ((object = new DefaultHttp2DataFrame((ByteBuf)object, this.input.isEndOfInput()).stream(this.stream)).isEndStream()) {
            this.endStreamSent = true;
        }
        return object;
    }

    public final long length() {
        return this.input.length();
    }

    public final long progress() {
        return this.input.progress();
    }
}

