/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

public final class Http2Flags {
    public static final short END_STREAM = 1;
    public static final short END_HEADERS = 4;
    public static final short ACK = 1;
    public static final short PADDED = 8;
    public static final short PRIORITY = 32;
    private short value;

    public Http2Flags() {
    }

    public Http2Flags(short s) {
        this.value = s;
    }

    public final short value() {
        return this.value;
    }

    public final boolean endOfStream() {
        return this.isFlagSet((short)1);
    }

    public final boolean endOfHeaders() {
        return this.isFlagSet((short)4);
    }

    public final boolean priorityPresent() {
        return this.isFlagSet((short)32);
    }

    public final boolean ack() {
        return this.isFlagSet((short)1);
    }

    public final boolean paddingPresent() {
        return this.isFlagSet((short)8);
    }

    public final int getNumPriorityBytes() {
        if (this.priorityPresent()) {
            return 5;
        }
        return 0;
    }

    public final int getPaddingPresenceFieldLength() {
        if (this.paddingPresent()) {
            return 1;
        }
        return 0;
    }

    public final Http2Flags endOfStream(boolean bl) {
        return this.setFlag(bl, (short)1);
    }

    public final Http2Flags endOfHeaders(boolean bl) {
        return this.setFlag(bl, (short)4);
    }

    public final Http2Flags priorityPresent(boolean bl) {
        return this.setFlag(bl, (short)32);
    }

    public final Http2Flags paddingPresent(boolean bl) {
        return this.setFlag(bl, (short)8);
    }

    public final Http2Flags ack(boolean bl) {
        return this.setFlag(bl, (short)1);
    }

    public final Http2Flags setFlag(boolean bl, short s) {
        this.value = bl ? (short)(this.value | s) : (short)(this.value & ~s);
        return this;
    }

    public final boolean isFlagSet(short s) {
        return (this.value & s) != 0;
    }

    public final int hashCode() {
        int n = 31 + this.value;
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.value == ((Http2Flags)object).value;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("value = ").append(this.value).append(" (");
        if (this.ack()) {
            stringBuilder.append("ACK,");
        }
        if (this.endOfHeaders()) {
            stringBuilder.append("END_OF_HEADERS,");
        }
        if (this.endOfStream()) {
            stringBuilder.append("END_OF_STREAM,");
        }
        if (this.priorityPresent()) {
            stringBuilder.append("PRIORITY_PRESENT,");
        }
        if (this.paddingPresent()) {
            stringBuilder.append("PADDING_PRESENT,");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

