/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public final class EmptyByteBuf
extends ByteBuf {
    static final int EMPTY_BYTE_BUF_HASH_CODE = 1;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocateDirect(0);
    private static final long EMPTY_BYTE_BUFFER_ADDRESS;
    private final ByteBufAllocator alloc;
    private final ByteOrder order;
    private final String str;
    private EmptyByteBuf swapped;

    public EmptyByteBuf(ByteBufAllocator byteBufAllocator) {
        this(byteBufAllocator, ByteOrder.BIG_ENDIAN);
    }

    private EmptyByteBuf(ByteBufAllocator byteBufAllocator, ByteOrder byteOrder) {
        this.alloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)byteBufAllocator, (String)"alloc");
        this.order = byteOrder;
        this.str = StringUtil.simpleClassName((Object)this) + (byteOrder == ByteOrder.BIG_ENDIAN ? "BE" : "LE");
    }

    @Override
    public final int capacity() {
        return 0;
    }

    @Override
    public final ByteBuf capacity(int n) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public final ByteOrder order() {
        return this.order;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    public final int maxCapacity() {
        return 0;
    }

    @Override
    public final ByteBuf order(ByteOrder byteOrder) {
        if (ObjectUtil.checkNotNull((Object)byteOrder, (String)"endianness") == ((ByteBuf)this).order()) {
            return this;
        }
        EmptyByteBuf emptyByteBuf = this.swapped;
        if (emptyByteBuf != null) {
            return emptyByteBuf;
        }
        this.swapped = emptyByteBuf = new EmptyByteBuf(((ByteBuf)this).alloc(), byteOrder);
        return emptyByteBuf;
    }

    @Override
    public final int readerIndex() {
        return 0;
    }

    @Override
    public final ByteBuf readerIndex(int n) {
        return this.checkIndex(n);
    }

    @Override
    public final int writerIndex() {
        return 0;
    }

    @Override
    public final ByteBuf writerIndex(int n) {
        return this.checkIndex(n);
    }

    @Override
    public final ByteBuf setIndex(int n, int n2) {
        this.checkIndex(n);
        this.checkIndex(n2);
        return this;
    }

    @Override
    public final int readableBytes() {
        return 0;
    }

    @Override
    public final int writableBytes() {
        return 0;
    }

    @Override
    public final int maxWritableBytes() {
        return 0;
    }

    @Override
    public final boolean isReadable() {
        return false;
    }

    @Override
    public final boolean isWritable() {
        return false;
    }

    @Override
    public final ByteBuf clear() {
        return this;
    }

    @Override
    public final ByteBuf markReaderIndex() {
        return this;
    }

    @Override
    public final ByteBuf resetReaderIndex() {
        return this;
    }

    @Override
    public final ByteBuf markWriterIndex() {
        return this;
    }

    @Override
    public final ByteBuf resetWriterIndex() {
        return this;
    }

    @Override
    public final ByteBuf discardReadBytes() {
        return this;
    }

    @Override
    public final ByteBuf discardSomeReadBytes() {
        return this;
    }

    @Override
    public final ByteBuf ensureWritable(int n) {
        ObjectUtil.checkPositiveOrZero((int)n, (String)"minWritableBytes");
        if (n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public final int ensureWritable(int n, boolean bl) {
        ObjectUtil.checkPositiveOrZero((int)n, (String)"minWritableBytes");
        if (n == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public final boolean getBoolean(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final byte getByte(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short getUnsignedByte(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short getShort(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short getShortLE(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getUnsignedShort(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getUnsignedShortLE(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getMedium(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getMediumLE(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getUnsignedMedium(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getUnsignedMediumLE(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getInt(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getIntLE(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long getUnsignedInt(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long getUnsignedIntLE(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long getLong(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long getLongLE(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final char getChar(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final float getFloat(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final double getDouble(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBuf) {
        return this.checkIndex(n, byteBuf.writableBytes());
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2) {
        return this.checkIndex(n, n2);
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        return this.checkIndex(n, n3);
    }

    @Override
    public final ByteBuf getBytes(int n, byte[] byArray) {
        return this.checkIndex(n, byArray.length);
    }

    @Override
    public final ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        return this.checkIndex(n, n3);
    }

    @Override
    public final ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        return this.checkIndex(n, byteBuffer.remaining());
    }

    @Override
    public final ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        return this.checkIndex(n, n2);
    }

    @Override
    public final int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkIndex(n, n2);
        return 0;
    }

    @Override
    public final int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        this.checkIndex(n, n2);
        return 0;
    }

    @Override
    public final CharSequence getCharSequence(int n, int n2, Charset charset) {
        this.checkIndex(n, n2);
        return null;
    }

    @Override
    public final ByteBuf setBoolean(int n, boolean bl) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setByte(int n, int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setShort(int n, int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setShortLE(int n, int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setMedium(int n, int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setMediumLE(int n, int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setInt(int n, int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setIntLE(int n, int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setLong(int n, long l) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setLongLE(int n, long l) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setChar(int n, int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setFloat(int n, float f) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setDouble(int n, double d) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBuf) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBuf, int n2) {
        return this.checkIndex(n, n2);
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        return this.checkIndex(n, n3);
    }

    @Override
    public final ByteBuf setBytes(int n, byte[] byArray) {
        return this.checkIndex(n, byArray.length);
    }

    @Override
    public final ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        return this.checkIndex(n, n3);
    }

    @Override
    public final ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        return this.checkIndex(n, byteBuffer.remaining());
    }

    @Override
    public final int setBytes(int n, InputStream inputStream, int n2) {
        this.checkIndex(n, n2);
        return 0;
    }

    @Override
    public final int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        this.checkIndex(n, n2);
        return 0;
    }

    @Override
    public final int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        this.checkIndex(n, n2);
        return 0;
    }

    @Override
    public final ByteBuf setZero(int n, int n2) {
        return this.checkIndex(n, n2);
    }

    @Override
    public final int setCharSequence(int n, CharSequence charSequence, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final boolean readBoolean() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final byte readByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short readUnsignedByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short readShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final short readShortLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readUnsignedShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readUnsignedShortLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readMedium() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readMediumLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readUnsignedMedium() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readUnsignedMediumLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readInt() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int readIntLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long readUnsignedInt() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long readUnsignedIntLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long readLong() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final long readLongLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final char readChar() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final float readFloat() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final double readDouble() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf readBytes(int n) {
        return this.checkLength(n);
    }

    @Override
    public final ByteBuf readSlice(int n) {
        return this.checkLength(n);
    }

    @Override
    public final ByteBuf readRetainedSlice(int n) {
        return this.checkLength(n);
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf) {
        return this.checkLength(byteBuf.writableBytes());
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf, int n) {
        return this.checkLength(n);
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf, int n, int n2) {
        return this.checkLength(n2);
    }

    @Override
    public final ByteBuf readBytes(byte[] byArray) {
        return this.checkLength(byArray.length);
    }

    @Override
    public final ByteBuf readBytes(byte[] byArray, int n, int n2) {
        return this.checkLength(n2);
    }

    @Override
    public final ByteBuf readBytes(ByteBuffer byteBuffer) {
        return this.checkLength(byteBuffer.remaining());
    }

    @Override
    public final ByteBuf readBytes(OutputStream outputStream, int n) {
        return this.checkLength(n);
    }

    @Override
    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n) {
        this.checkLength(n);
        return 0;
    }

    @Override
    public final int readBytes(FileChannel fileChannel, long l, int n) {
        this.checkLength(n);
        return 0;
    }

    @Override
    public final CharSequence readCharSequence(int n, Charset charset) {
        this.checkLength(n);
        return "";
    }

    @Override
    public final ByteBuf skipBytes(int n) {
        return this.checkLength(n);
    }

    @Override
    public final ByteBuf writeBoolean(boolean bl) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeByte(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeShort(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeShortLE(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeMedium(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeMediumLE(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeInt(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeIntLE(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeLong(long l) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeLongLE(long l) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeChar(int n) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeFloat(float f) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeDouble(double d) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf) {
        return this.checkLength(byteBuf.readableBytes());
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf, int n) {
        return this.checkLength(n);
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf, int n, int n2) {
        return this.checkLength(n2);
    }

    @Override
    public final ByteBuf writeBytes(byte[] byArray) {
        return this.checkLength(byArray.length);
    }

    @Override
    public final ByteBuf writeBytes(byte[] byArray, int n, int n2) {
        return this.checkLength(n2);
    }

    @Override
    public final ByteBuf writeBytes(ByteBuffer byteBuffer) {
        return this.checkLength(byteBuffer.remaining());
    }

    @Override
    public final int writeBytes(InputStream inputStream, int n) {
        this.checkLength(n);
        return 0;
    }

    @Override
    public final int writeBytes(ScatteringByteChannel scatteringByteChannel, int n) {
        this.checkLength(n);
        return 0;
    }

    @Override
    public final int writeBytes(FileChannel fileChannel, long l, int n) {
        this.checkLength(n);
        return 0;
    }

    @Override
    public final ByteBuf writeZero(int n) {
        return this.checkLength(n);
    }

    @Override
    public final int writeCharSequence(CharSequence charSequence, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int indexOf(int n, int n2, byte by) {
        this.checkIndex(n);
        this.checkIndex(n2);
        return -1;
    }

    @Override
    public final int bytesBefore(byte by) {
        return -1;
    }

    @Override
    public final int bytesBefore(int n, byte by) {
        this.checkLength(n);
        return -1;
    }

    @Override
    public final int bytesBefore(int n, int n2, byte by) {
        this.checkIndex(n, n2);
        return -1;
    }

    @Override
    public final int forEachByte(ByteProcessor byteProcessor) {
        return -1;
    }

    @Override
    public final int forEachByte(int n, int n2, ByteProcessor byteProcessor) {
        this.checkIndex(n, n2);
        return -1;
    }

    @Override
    public final int forEachByteDesc(ByteProcessor byteProcessor) {
        return -1;
    }

    @Override
    public final int forEachByteDesc(int n, int n2, ByteProcessor byteProcessor) {
        this.checkIndex(n, n2);
        return -1;
    }

    @Override
    public final ByteBuf copy() {
        return this;
    }

    @Override
    public final ByteBuf copy(int n, int n2) {
        return this.checkIndex(n, n2);
    }

    @Override
    public final ByteBuf slice() {
        return this;
    }

    @Override
    public final ByteBuf retainedSlice() {
        return this;
    }

    @Override
    public final ByteBuf slice(int n, int n2) {
        return this.checkIndex(n, n2);
    }

    @Override
    public final ByteBuf retainedSlice(int n, int n2) {
        return this.checkIndex(n, n2);
    }

    @Override
    public final ByteBuf duplicate() {
        return this;
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return this;
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    @Override
    public final ByteBuffer nioBuffer() {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    public final ByteBuffer nioBuffer(int n, int n2) {
        this.checkIndex(n, n2);
        return ((ByteBuf)this).nioBuffer();
    }

    @Override
    public final ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{EMPTY_BYTE_BUFFER};
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n, int n2) {
        this.checkIndex(n, n2);
        return ((ByteBuf)this).nioBuffers();
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n, int n2) {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final byte[] array() {
        return EmptyArrays.EMPTY_BYTES;
    }

    @Override
    public final int arrayOffset() {
        return 0;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return EMPTY_BYTE_BUFFER_ADDRESS != 0L;
    }

    @Override
    public final long memoryAddress() {
        if (((ByteBuf)this).hasMemoryAddress()) {
            return EMPTY_BYTE_BUFFER_ADDRESS;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    @Override
    public final String toString(Charset charset) {
        return "";
    }

    @Override
    public final String toString(int n, int n2, Charset charset) {
        this.checkIndex(n, n2);
        return ((ByteBuf)this).toString(charset);
    }

    @Override
    public final int hashCode() {
        return 1;
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof ByteBuf && !((ByteBuf)object).isReadable();
    }

    @Override
    public final int compareTo(ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            return -1;
        }
        return 0;
    }

    @Override
    public final String toString() {
        return this.str;
    }

    @Override
    public final boolean isReadable(int n) {
        return false;
    }

    @Override
    public final boolean isWritable(int n) {
        return false;
    }

    public final int refCnt() {
        return 1;
    }

    @Override
    public final ByteBuf retain() {
        return this;
    }

    @Override
    public final ByteBuf retain(int n) {
        return this;
    }

    @Override
    public final ByteBuf touch() {
        return this;
    }

    @Override
    public final ByteBuf touch(Object object) {
        return this;
    }

    public final boolean release() {
        return false;
    }

    public final boolean release(int n) {
        return false;
    }

    private ByteBuf checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkIndex(int n, int n2) {
        ObjectUtil.checkPositiveOrZero((int)n2, (String)"length");
        if (n != 0 || n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkLength(int n) {
        ObjectUtil.checkPositiveOrZero((int)n, (String)"length");
        if (n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    static {
        long l = 0L;
        try {
            if (PlatformDependent.hasUnsafe()) {
                l = PlatformDependent.directBufferAddress((ByteBuffer)EMPTY_BYTE_BUFFER);
            }
        }
        catch (Throwable throwable) {}
        EMPTY_BYTE_BUFFER_ADDRESS = l;
    }
}

