/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

final class LongLongHashMap {
    private static final int MASK_TEMPLATE = -2;
    private int mask;
    private long[] array;
    private int maxProbe;
    private long zeroVal;
    private final long emptyVal;

    LongLongHashMap(long l) {
        this.emptyVal = l;
        this.zeroVal = l;
        this.array = new long[32];
        this.mask = 31;
        this.computeMaskAndProbe();
    }

    public final long put(long l, long l2) {
        if (l == 0L) {
            long l3 = this.zeroVal;
            this.zeroVal = l2;
            return l3;
        }
        while (true) {
            int n = this.index(l);
            for (int i = 0; i < this.maxProbe; ++i) {
                long l4 = this.array[n];
                if (l4 == l || l4 == 0L) {
                    long l5 = l4 == 0L ? this.emptyVal : this.array[n + 1];
                    this.array[n] = l;
                    this.array[n + 1] = l2;
                    while (i < this.maxProbe) {
                        if (this.array[n = n + 2 & this.mask] == l) {
                            this.array[n] = 0L;
                            l5 = this.array[n + 1];
                            break;
                        }
                        ++i;
                    }
                    return l5;
                }
                n = n + 2 & this.mask;
            }
            this.expand();
        }
    }

    public final void remove(long l) {
        if (l == 0L) {
            this.zeroVal = this.emptyVal;
            return;
        }
        int n = this.index(l);
        for (int i = 0; i < this.maxProbe; ++i) {
            long l2 = this.array[n];
            if (l2 == l) {
                this.array[n] = 0L;
                return;
            }
            n = n + 2 & this.mask;
        }
    }

    public final long get(long l) {
        if (l == 0L) {
            return this.zeroVal;
        }
        int n = this.index(l);
        for (int i = 0; i < this.maxProbe; ++i) {
            long l2 = this.array[n];
            if (l2 == l) {
                return this.array[n + 1];
            }
            n = n + 2 & this.mask;
        }
        return this.emptyVal;
    }

    private int index(long l) {
        long l2 = l;
        l = l2 ^ l2 >>> 33;
        l *= -49064778989728563L;
        l ^= l >>> 33;
        l *= -4265267296055464877L;
        l ^= l >>> 33;
        return (int)l & this.mask;
    }

    private void expand() {
        long[] lArray = this.array;
        this.array = new long[lArray.length << 1];
        this.computeMaskAndProbe();
        for (int i = 0; i < lArray.length; i += 2) {
            long l = lArray[i];
            if (l == 0L) continue;
            long l2 = lArray[i + 1];
            this.put(l, l2);
        }
    }

    private void computeMaskAndProbe() {
        int n = this.array.length;
        this.mask = n - 1 & 0xFFFFFFFE;
        this.maxProbe = (int)Math.log(n);
    }
}

