/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolChunkList;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PoolSubpage;
import io.netty.buffer.PoolSubpageMetric;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledDirectByteBuf;
import io.netty.buffer.PooledHeapByteBuf;
import io.netty.buffer.PooledUnsafeDirectByteBuf;
import io.netty.buffer.PooledUnsafeHeapByteBuf;
import io.netty.buffer.SizeClasses;
import io.netty.util.internal.LongCounter;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

abstract class PoolArena<T>
implements PoolArenaMetric {
    private static final boolean HAS_UNSAFE = PlatformDependent.hasUnsafe();
    final PooledByteBufAllocator parent;
    final PoolSubpage<T>[] smallSubpagePools;
    private final PoolChunkList<T> q050;
    private final PoolChunkList<T> q025;
    private final PoolChunkList<T> q000;
    private final PoolChunkList<T> qInit;
    private final PoolChunkList<T> q075;
    private final PoolChunkList<T> q100;
    private final List<PoolChunkListMetric> chunkListMetrics;
    private long allocationsNormal;
    private final LongCounter allocationsSmall = PlatformDependent.newLongCounter();
    private final LongCounter allocationsHuge = PlatformDependent.newLongCounter();
    private final LongCounter activeBytesHuge = PlatformDependent.newLongCounter();
    private long deallocationsSmall;
    private long deallocationsNormal;
    private final LongCounter deallocationsHuge = PlatformDependent.newLongCounter();
    final AtomicInteger numThreadCaches = new AtomicInteger();
    private final ReentrantLock lock = new ReentrantLock();
    final SizeClasses sizeClass;

    protected PoolArena(PooledByteBufAllocator pooledByteBufAllocator, SizeClasses sizeClasses) {
        assert (sizeClasses != null);
        this.parent = pooledByteBufAllocator;
        this.sizeClass = sizeClasses;
        this.smallSubpagePools = this.newSubpagePoolArray(sizeClasses.nSubpages);
        for (int i = 0; i < this.smallSubpagePools.length; ++i) {
            this.smallSubpagePools[i] = this.newSubpagePoolHead(i);
        }
        this.q100 = new PoolChunkList(this, null, 100, Integer.MAX_VALUE, sizeClasses.chunkSize);
        PoolArena poolArena = this;
        this.q075 = new PoolChunkList<T>(poolArena, poolArena.q100, 75, 100, sizeClasses.chunkSize);
        PoolArena poolArena2 = this;
        this.q050 = new PoolChunkList<T>(poolArena2, poolArena2.q100, 50, 100, sizeClasses.chunkSize);
        PoolArena poolArena3 = this;
        this.q025 = new PoolChunkList<T>(poolArena3, poolArena3.q050, 25, 75, sizeClasses.chunkSize);
        PoolArena poolArena4 = this;
        this.q000 = new PoolChunkList<T>(poolArena4, poolArena4.q025, 1, 50, sizeClasses.chunkSize);
        PoolArena poolArena5 = this;
        this.qInit = new PoolChunkList<T>(poolArena5, poolArena5.q000, Integer.MIN_VALUE, 25, sizeClasses.chunkSize);
        this.q100.prevList(this.q075);
        this.q075.prevList(this.q050);
        this.q050.prevList(this.q025);
        this.q025.prevList(this.q000);
        this.q000.prevList(null);
        this.qInit.prevList(this.qInit);
        ArrayList<PoolChunkList<T>> arrayList = new ArrayList<PoolChunkList<T>>(6);
        arrayList.add(this.qInit);
        arrayList.add(this.q000);
        arrayList.add(this.q025);
        arrayList.add(this.q050);
        arrayList.add(this.q075);
        arrayList.add(this.q100);
        this.chunkListMetrics = Collections.unmodifiableList(arrayList);
    }

    private PoolSubpage<T> newSubpagePoolHead(int n) {
        PoolSubpage poolSubpage = new PoolSubpage(n);
        new PoolSubpage(n).prev = poolSubpage;
        poolSubpage.next = poolSubpage;
        return poolSubpage;
    }

    private PoolSubpage<T>[] newSubpagePoolArray(int n) {
        return new PoolSubpage[n];
    }

    abstract boolean isDirect();

    PooledByteBuf<T> allocate(PoolThreadCache poolThreadCache, int n, int n2) {
        PooledByteBuf<T> pooledByteBuf = this.newByteBuf(n2);
        this.allocate(poolThreadCache, pooledByteBuf, n);
        return pooledByteBuf;
    }

    private void allocate(PoolThreadCache poolThreadCache, PooledByteBuf<T> pooledByteBuf, int n) {
        int n2 = this.sizeClass.size2SizeIdx(n);
        if (n2 <= this.sizeClass.smallMaxSizeIdx) {
            this.tcacheAllocateSmall(poolThreadCache, pooledByteBuf, n, n2);
            return;
        }
        if (n2 < this.sizeClass.nSizes) {
            this.tcacheAllocateNormal(poolThreadCache, pooledByteBuf, n, n2);
            return;
        }
        int n3 = this.sizeClass.directMemoryCacheAlignment > 0 ? this.sizeClass.normalizeSize(n) : n;
        this.allocateHuge(pooledByteBuf, n3);
    }

    private void tcacheAllocateSmall(PoolThreadCache poolThreadCache, PooledByteBuf<T> pooledByteBuf, int n, int n2) {
        boolean bl;
        if (poolThreadCache.allocateSmall(this, pooledByteBuf, n, n2)) {
            return;
        }
        PoolSubpage<T> poolSubpage = this.smallSubpagePools[n2];
        poolSubpage.lock();
        try {
            PoolSubpage poolSubpage2 = poolSubpage.next;
            bl = poolSubpage2 == poolSubpage;
            if (!bl) {
                assert (poolSubpage2.doNotDestroy && poolSubpage2.elemSize == this.sizeClass.sizeIdx2size(n2)) : "doNotDestroy=" + poolSubpage2.doNotDestroy + ", elemSize=" + poolSubpage2.elemSize + ", sizeIdx=" + n2;
                long l = poolSubpage2.allocate();
                assert (l >= 0L);
                poolSubpage2.chunk.initBufWithSubpage(pooledByteBuf, null, l, n, poolThreadCache);
            }
        }
        finally {
            poolSubpage.unlock();
        }
        if (bl) {
            this.lock();
            try {
                this.allocateNormal(pooledByteBuf, n, n2, poolThreadCache);
            }
            finally {
                this.unlock();
            }
        }
        this.incSmallAllocation();
    }

    private void tcacheAllocateNormal(PoolThreadCache poolThreadCache, PooledByteBuf<T> pooledByteBuf, int n, int n2) {
        if (poolThreadCache.allocateNormal(this, pooledByteBuf, n, n2)) {
            return;
        }
        this.lock();
        try {
            this.allocateNormal(pooledByteBuf, n, n2, poolThreadCache);
            ++this.allocationsNormal;
            return;
        }
        finally {
            this.unlock();
        }
    }

    private void allocateNormal(PooledByteBuf<T> pooledByteBuf, int n, int n2, PoolThreadCache poolThreadCache) {
        assert (this.lock.isHeldByCurrentThread());
        if (this.q050.allocate(pooledByteBuf, n, n2, poolThreadCache) || this.q025.allocate(pooledByteBuf, n, n2, poolThreadCache) || this.q000.allocate(pooledByteBuf, n, n2, poolThreadCache) || this.qInit.allocate(pooledByteBuf, n, n2, poolThreadCache) || this.q075.allocate(pooledByteBuf, n, n2, poolThreadCache)) {
            return;
        }
        PoolArena poolArena = this;
        PoolChunk<T> poolChunk = poolArena.newChunk(poolArena.sizeClass.pageSize, this.sizeClass.nPSizes, this.sizeClass.pageShifts, this.sizeClass.chunkSize);
        boolean bl = poolChunk.allocate(pooledByteBuf, n, n2, poolThreadCache);
        assert (bl);
        this.qInit.add(poolChunk);
    }

    private void incSmallAllocation() {
        this.allocationsSmall.increment();
    }

    private void allocateHuge(PooledByteBuf<T> pooledByteBuf, int n) {
        PoolChunk<T> poolChunk = this.newUnpooledChunk(n);
        this.activeBytesHuge.add((long)poolChunk.chunkSize());
        pooledByteBuf.initUnpooled(poolChunk, n);
        this.allocationsHuge.increment();
    }

    void free(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l, int n, PoolThreadCache poolThreadCache) {
        poolChunk.decrementPinnedMemory(n);
        if (poolChunk.unpooled) {
            int n2 = poolChunk.chunkSize();
            this.destroyChunk(poolChunk);
            this.activeBytesHuge.add((long)(-n2));
            this.deallocationsHuge.increment();
            return;
        }
        SizeClass sizeClass = PoolArena.sizeClass(l);
        if (poolThreadCache != null && poolThreadCache.add(this, poolChunk, byteBuffer, l, n, sizeClass)) {
            return;
        }
        this.freeChunk(poolChunk, l, n, sizeClass, byteBuffer, false);
    }

    private static SizeClass sizeClass(long l) {
        if (PoolChunk.isSubpage(l)) {
            return SizeClass.Small;
        }
        return SizeClass.Normal;
    }

    void freeChunk(PoolChunk<T> poolChunk, long l, int n, SizeClass sizeClass, ByteBuffer byteBuffer, boolean bl) {
        boolean bl2;
        this.lock();
        try {
            if (!bl) {
                switch (sizeClass) {
                    case Normal: {
                        ++this.deallocationsNormal;
                        break;
                    }
                    case Small: {
                        ++this.deallocationsSmall;
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            bl2 = !poolChunk.parent.free(poolChunk, l, n, byteBuffer);
        }
        finally {
            this.unlock();
        }
        if (bl2) {
            this.destroyChunk(poolChunk);
        }
    }

    void reallocate(PooledByteBuf<T> pooledByteBuf, int n) {
        int n2;
        PoolThreadCache poolThreadCache;
        int n3;
        int n4;
        Object t;
        long l;
        ByteBuffer byteBuffer;
        PoolChunk poolChunk;
        int n5;
        assert (n >= 0 && n <= ((ByteBuf)pooledByteBuf).maxCapacity());
        PooledByteBuf<T> pooledByteBuf2 = pooledByteBuf;
        synchronized (pooledByteBuf2) {
            n5 = pooledByteBuf.length;
            if (n5 == n) {
                return;
            }
            poolChunk = pooledByteBuf.chunk;
            byteBuffer = pooledByteBuf.tmpNioBuf;
            l = pooledByteBuf.handle;
            t = pooledByteBuf.memory;
            n4 = pooledByteBuf.offset;
            n3 = pooledByteBuf.maxLength;
            poolThreadCache = pooledByteBuf.cache;
            PoolArena poolArena = this;
            poolArena.allocate(poolArena.parent.threadCache(), pooledByteBuf, n);
        }
        if (n > n5) {
            n2 = n5;
        } else {
            pooledByteBuf.trimIndicesToCapacity(n);
            n2 = n;
        }
        this.memoryCopy(t, n4, pooledByteBuf, n2);
        this.free(poolChunk, byteBuffer, l, n3, poolThreadCache);
    }

    @Override
    public int numThreadCaches() {
        return this.numThreadCaches.get();
    }

    @Override
    public int numTinySubpages() {
        return 0;
    }

    @Override
    public int numSmallSubpages() {
        return this.smallSubpagePools.length;
    }

    @Override
    public int numChunkLists() {
        return this.chunkListMetrics.size();
    }

    @Override
    public List<PoolSubpageMetric> tinySubpages() {
        return Collections.emptyList();
    }

    @Override
    public List<PoolSubpageMetric> smallSubpages() {
        return PoolArena.subPageMetricList(this.smallSubpagePools);
    }

    @Override
    public List<PoolChunkListMetric> chunkLists() {
        return this.chunkListMetrics;
    }

    private static List<PoolSubpageMetric> subPageMetricList(PoolSubpage<?>[] poolSubpageArray) {
        ArrayList<PoolSubpageMetric> arrayList = new ArrayList<PoolSubpageMetric>();
        for (PoolSubpage<?> poolSubpage : poolSubpageArray) {
            if (poolSubpage.next == poolSubpage) continue;
            PoolSubpage poolSubpage2 = poolSubpage.next;
            do {
                arrayList.add(poolSubpage2);
            } while ((poolSubpage2 = poolSubpage2.next) != poolSubpage);
        }
        return arrayList;
    }

    @Override
    public long numAllocations() {
        long l;
        this.lock();
        try {
            l = this.allocationsNormal;
        }
        finally {
            this.unlock();
        }
        return this.allocationsSmall.value() + l + this.allocationsHuge.value();
    }

    @Override
    public long numTinyAllocations() {
        return 0L;
    }

    @Override
    public long numSmallAllocations() {
        return this.allocationsSmall.value();
    }

    @Override
    public long numNormalAllocations() {
        this.lock();
        try {
            long l = this.allocationsNormal;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long numDeallocations() {
        long l;
        this.lock();
        try {
            l = this.deallocationsSmall + this.deallocationsNormal;
        }
        finally {
            this.unlock();
        }
        return l + this.deallocationsHuge.value();
    }

    @Override
    public long numTinyDeallocations() {
        return 0L;
    }

    @Override
    public long numSmallDeallocations() {
        this.lock();
        try {
            long l = this.deallocationsSmall;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long numNormalDeallocations() {
        this.lock();
        try {
            long l = this.deallocationsNormal;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long numHugeAllocations() {
        return this.allocationsHuge.value();
    }

    @Override
    public long numHugeDeallocations() {
        return this.deallocationsHuge.value();
    }

    @Override
    public long numActiveAllocations() {
        long l = this.allocationsSmall.value() + this.allocationsHuge.value() - this.deallocationsHuge.value();
        this.lock();
        try {
        }
        finally {
            this.unlock();
        }
        return Math.max(l += this.allocationsNormal - (this.deallocationsSmall + this.deallocationsNormal), 0L);
    }

    @Override
    public long numActiveTinyAllocations() {
        return 0L;
    }

    @Override
    public long numActiveSmallAllocations() {
        return Math.max(this.numSmallAllocations() - this.numSmallDeallocations(), 0L);
    }

    @Override
    public long numActiveNormalAllocations() {
        long l;
        this.lock();
        try {
            l = this.allocationsNormal - this.deallocationsNormal;
        }
        finally {
            this.unlock();
        }
        return Math.max(l, 0L);
    }

    @Override
    public long numActiveHugeAllocations() {
        return Math.max(this.numHugeAllocations() - this.numHugeDeallocations(), 0L);
    }

    @Override
    public long numActiveBytes() {
        long l = this.activeBytesHuge.value();
        this.lock();
        try {
            for (int i = 0; i < this.chunkListMetrics.size(); ++i) {
                for (PoolChunkMetric poolChunkMetric : this.chunkListMetrics.get(i)) {
                    l += (long)poolChunkMetric.chunkSize();
                }
            }
        }
        finally {
            this.unlock();
        }
        return Math.max(0L, l);
    }

    public long numPinnedBytes() {
        long l = this.activeBytesHuge.value();
        for (int i = 0; i < this.chunkListMetrics.size(); ++i) {
            for (PoolChunkMetric poolChunkMetric : this.chunkListMetrics.get(i)) {
                l += (long)((PoolChunk)poolChunkMetric).pinnedBytes();
            }
        }
        return Math.max(0L, l);
    }

    protected abstract PoolChunk<T> newChunk(int var1, int var2, int var3, int var4);

    protected abstract PoolChunk<T> newUnpooledChunk(int var1);

    protected abstract PooledByteBuf<T> newByteBuf(int var1);

    protected abstract void memoryCopy(T var1, int var2, PooledByteBuf<T> var3, int var4);

    protected abstract void destroyChunk(PoolChunk<T> var1);

    public String toString() {
        this.lock();
        try {
            CharSequence charSequence = new StringBuilder("Chunk(s) at 0~25%:").append(StringUtil.NEWLINE).append(this.qInit).append(StringUtil.NEWLINE).append("Chunk(s) at 0~50%:").append(StringUtil.NEWLINE).append(this.q000).append(StringUtil.NEWLINE).append("Chunk(s) at 25~75%:").append(StringUtil.NEWLINE).append(this.q025).append(StringUtil.NEWLINE).append("Chunk(s) at 50~100%:").append(StringUtil.NEWLINE).append(this.q050).append(StringUtil.NEWLINE).append("Chunk(s) at 75~100%:").append(StringUtil.NEWLINE).append(this.q075).append(StringUtil.NEWLINE).append("Chunk(s) at 100%:").append(StringUtil.NEWLINE).append(this.q100).append(StringUtil.NEWLINE).append("small subpages:");
            PoolArena.appendPoolSubPages(charSequence, this.smallSubpagePools);
            charSequence.append(StringUtil.NEWLINE);
            charSequence = charSequence.toString();
            return charSequence;
        }
        finally {
            this.unlock();
        }
    }

    private static void appendPoolSubPages(StringBuilder stringBuilder, PoolSubpage<?>[] poolSubpageArray) {
        for (int i = 0; i < poolSubpageArray.length; ++i) {
            PoolSubpage<?> poolSubpage = poolSubpageArray[i];
            if (poolSubpage.next == poolSubpage || poolSubpage.next == null) continue;
            stringBuilder.append(StringUtil.NEWLINE).append(i).append(": ");
            PoolSubpage poolSubpage2 = poolSubpage.next;
            while (poolSubpage2 != null) {
                stringBuilder.append(poolSubpage2);
                poolSubpage2 = poolSubpage2.next;
                if (poolSubpage2 != poolSubpage) continue;
            }
        }
    }

    protected final void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            PoolArena.destroyPoolSubPages(this.smallSubpagePools);
            this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
            throw throwable;
        }
        PoolArena.destroyPoolSubPages(this.smallSubpagePools);
        this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
    }

    private static void destroyPoolSubPages(PoolSubpage<?>[] poolSubpageArray) {
        for (PoolSubpage<?> poolSubpage : poolSubpageArray) {
            poolSubpage.destroy();
        }
    }

    private void destroyPoolChunkLists(PoolChunkList<T> ... poolChunkListArray) {
        for (PoolChunkList<T> poolChunkList : poolChunkListArray) {
            poolChunkList.destroy(this);
        }
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    @Override
    public int sizeIdx2size(int n) {
        return this.sizeClass.sizeIdx2size(n);
    }

    @Override
    public int sizeIdx2sizeCompute(int n) {
        return this.sizeClass.sizeIdx2sizeCompute(n);
    }

    @Override
    public long pageIdx2size(int n) {
        return this.sizeClass.pageIdx2size(n);
    }

    @Override
    public long pageIdx2sizeCompute(int n) {
        return this.sizeClass.pageIdx2sizeCompute(n);
    }

    @Override
    public int size2SizeIdx(int n) {
        return this.sizeClass.size2SizeIdx(n);
    }

    @Override
    public int pages2pageIdx(int n) {
        return this.sizeClass.pages2pageIdx(n);
    }

    @Override
    public int pages2pageIdxFloor(int n) {
        return this.sizeClass.pages2pageIdxFloor(n);
    }

    @Override
    public int normalizeSize(int n) {
        return this.sizeClass.normalizeSize(n);
    }

    static final class DirectArena
    extends PoolArena<ByteBuffer> {
        DirectArena(PooledByteBufAllocator pooledByteBufAllocator, SizeClasses sizeClasses) {
            super(pooledByteBufAllocator, sizeClasses);
        }

        @Override
        final boolean isDirect() {
            return true;
        }

        @Override
        protected final PoolChunk<ByteBuffer> newChunk(int n, int n2, int n3, int n4) {
            if (this.sizeClass.directMemoryCacheAlignment == 0) {
                ByteBuffer byteBuffer;
                ByteBuffer byteBuffer2 = byteBuffer = DirectArena.allocateDirect(n4);
                return new PoolChunk<ByteBuffer>(this, byteBuffer2, byteBuffer2, n, n3, n4, n2);
            }
            ByteBuffer byteBuffer = DirectArena.allocateDirect(n4 + this.sizeClass.directMemoryCacheAlignment);
            ByteBuffer byteBuffer3 = PlatformDependent.alignDirectBuffer((ByteBuffer)byteBuffer, (int)this.sizeClass.directMemoryCacheAlignment);
            return new PoolChunk<ByteBuffer>(this, byteBuffer, byteBuffer3, n, n3, n4, n2);
        }

        @Override
        protected final PoolChunk<ByteBuffer> newUnpooledChunk(int n) {
            if (this.sizeClass.directMemoryCacheAlignment == 0) {
                ByteBuffer byteBuffer;
                ByteBuffer byteBuffer2 = byteBuffer = DirectArena.allocateDirect(n);
                return new PoolChunk<ByteBuffer>(this, byteBuffer2, byteBuffer2, n);
            }
            ByteBuffer byteBuffer = DirectArena.allocateDirect(n + this.sizeClass.directMemoryCacheAlignment);
            ByteBuffer byteBuffer3 = PlatformDependent.alignDirectBuffer((ByteBuffer)byteBuffer, (int)this.sizeClass.directMemoryCacheAlignment);
            return new PoolChunk<ByteBuffer>(this, byteBuffer, byteBuffer3, n);
        }

        private static ByteBuffer allocateDirect(int n) {
            if (PlatformDependent.useDirectBufferNoCleaner()) {
                return PlatformDependent.allocateDirectNoCleaner((int)n);
            }
            return ByteBuffer.allocateDirect(n);
        }

        @Override
        protected final void destroyChunk(PoolChunk<ByteBuffer> poolChunk) {
            if (PlatformDependent.useDirectBufferNoCleaner()) {
                PlatformDependent.freeDirectNoCleaner((ByteBuffer)((ByteBuffer)poolChunk.base));
                return;
            }
            PlatformDependent.freeDirectBuffer((ByteBuffer)((ByteBuffer)poolChunk.base));
        }

        @Override
        protected final PooledByteBuf<ByteBuffer> newByteBuf(int n) {
            if (HAS_UNSAFE) {
                return PooledUnsafeDirectByteBuf.newInstance(n);
            }
            return PooledDirectByteBuf.newInstance(n);
        }

        @Override
        protected final void memoryCopy(ByteBuffer byteBuffer, int n, PooledByteBuf<ByteBuffer> pooledByteBuf, int n2) {
            if (n2 == 0) {
                return;
            }
            if (HAS_UNSAFE) {
                PlatformDependent.copyMemory((long)(PlatformDependent.directBufferAddress((ByteBuffer)byteBuffer) + (long)n), (long)(PlatformDependent.directBufferAddress((ByteBuffer)((ByteBuffer)pooledByteBuf.memory)) + (long)pooledByteBuf.offset), (long)n2);
                return;
            }
            byteBuffer = byteBuffer.duplicate();
            ByteBuffer byteBuffer2 = pooledByteBuf.internalNioBuffer();
            byteBuffer.position(n).limit(n + n2);
            byteBuffer2.position(pooledByteBuf.offset);
            byteBuffer2.put(byteBuffer);
        }
    }

    static final class HeapArena
    extends PoolArena<byte[]> {
        private final AtomicReference<PoolChunk<byte[]>> lastDestroyedChunk = new AtomicReference();

        HeapArena(PooledByteBufAllocator pooledByteBufAllocator, SizeClasses sizeClasses) {
            super(pooledByteBufAllocator, sizeClasses);
        }

        private static byte[] newByteArray(int n) {
            return PlatformDependent.allocateUninitializedArray((int)n);
        }

        @Override
        final boolean isDirect() {
            return false;
        }

        @Override
        protected final PoolChunk<byte[]> newChunk(int n, int n2, int n3, int n4) {
            PoolChunk poolChunk = this.lastDestroyedChunk.getAndSet(null);
            if (poolChunk != null) {
                assert (poolChunk.chunkSize == n4 && poolChunk.pageSize == n && poolChunk.maxPageIdx == n2 && poolChunk.pageShifts == n3);
                return poolChunk;
            }
            return new PoolChunk<byte[]>(this, null, HeapArena.newByteArray(n4), n, n3, n4, n2);
        }

        @Override
        protected final PoolChunk<byte[]> newUnpooledChunk(int n) {
            return new PoolChunk<byte[]>(this, null, HeapArena.newByteArray(n), n);
        }

        @Override
        protected final void destroyChunk(PoolChunk<byte[]> poolChunk) {
            if (!poolChunk.unpooled && this.lastDestroyedChunk.get() == null) {
                this.lastDestroyedChunk.set(poolChunk);
            }
        }

        @Override
        protected final PooledByteBuf<byte[]> newByteBuf(int n) {
            if (HAS_UNSAFE) {
                return PooledUnsafeHeapByteBuf.newUnsafeInstance(n);
            }
            return PooledHeapByteBuf.newInstance(n);
        }

        @Override
        protected final void memoryCopy(byte[] byArray, int n, PooledByteBuf<byte[]> pooledByteBuf, int n2) {
            if (n2 == 0) {
                return;
            }
            System.arraycopy(byArray, n, pooledByteBuf.memory, pooledByteBuf.offset, n2);
        }
    }

    static enum SizeClass {
        Small,
        Normal;

    }
}

