/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.Cache;
import androidx.compose.ui.text.ExpireAfterAccessCache;
import androidx.compose.ui.text.font.DefaultFontFamily;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.font.LoadedFontFamily;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.FontLoadResult;
import androidx.compose.ui.text.platform.PlatformFont;
import androidx.compose.ui.text.platform.PlatformFont_skikoKt;
import androidx.compose.ui.text.platform.SkiaBackedTypeface;
import androidx.compose.ui.text.platform.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.platform.SystemFont;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.FontMgrWithFallback;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.paragraph.FontCollection;
import org.jetbrains.skia.paragraph.TypefaceFontProviderWithFallback;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J+\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\fH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/compose/ui/text/platform/FontCache;", "", "<init>", "()V", "fonts", "Lorg/jetbrains/skia/paragraph/FontCollection;", "getFonts$ui_text", "()Lorg/jetbrains/skia/paragraph/FontCollection;", "fontProvider", "Lorg/jetbrains/skia/paragraph/TypefaceFontProviderWithFallback;", "registered", "", "", "typefacesCache", "Landroidx/compose/ui/text/Cache;", "Lorg/jetbrains/skia/Typeface;", "load", "Landroidx/compose/ui/text/platform/FontLoadResult;", "font", "Landroidx/compose/ui/text/platform/PlatformFont;", "load$ui_text", "loadPlatformTypes", "fontFamily", "Landroidx/compose/ui/text/font/FontFamily;", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "loadPlatformTypes-RetOiIg$ui_text", "(Landroidx/compose/ui/text/font/FontFamily;Landroidx/compose/ui/text/font/FontWeight;I)Landroidx/compose/ui/text/platform/FontLoadResult;", "ensureRegistered", "", "typeface", "key", "", "ui-text"})
public final class FontCache {
    private final FontCollection fonts = new FontCollection();
    private final TypefaceFontProviderWithFallback fontProvider = new TypefaceFontProviderWithFallback();
    private final Set<String> registered = new HashSet();
    private final Cache<String, Typeface> typefacesCache = new ExpireAfterAccessCache(60000000000L, null, 2, null);
    public static final int $stable = 8;

    public FontCache() {
        this.fonts.setDefaultFontManager((FontMgr)new FontMgrWithFallback(this.fontProvider));
        this.fonts.setAssetFontManager((FontMgr)this.fontProvider);
    }

    public final FontCollection getFonts$ui_text() {
        return this.fonts;
    }

    public final FontLoadResult load$ui_text(PlatformFont platformFont) {
        Intrinsics.checkNotNullParameter((Object)platformFont, (String)"");
        Typeface typeface2 = this.typefacesCache.get(platformFont.getCacheKey$ui_text(), (Function1<String, Typeface>)((Function1)arg_0 -> FontCache.load$lambda$0(platformFont, arg_0)));
        this.ensureRegistered(typeface2, platformFont.getCacheKey$ui_text());
        return new FontLoadResult(typeface2, CollectionsKt.listOf((Object)platformFont.getCacheKey$ui_text()));
    }

    public final FontLoadResult loadPlatformTypes-RetOiIg$ui_text(FontFamily object, FontWeight fontWeight, int n) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"");
        object = this.ensureRegistered((FontFamily)object);
        fontWeight = SkiaParagraph_skikoKt.toSkFontStyle-nzbMABs(n).withWeight(fontWeight.getWeight());
        Collection collection = (Collection)object;
        Collection collection2 = collection;
        collection2 = collection;
        return new FontLoadResult((Typeface)ArraysKt.first((Object[])this.fonts.findTypefaces(collection.toArray(new String[0]), (org.jetbrains.skia.FontStyle)fontWeight)), (List<String>)object);
    }

    public static /* synthetic */ FontLoadResult loadPlatformTypes-RetOiIg$ui_text$default(FontCache fontCache, FontFamily fontFamily, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return fontCache.loadPlatformTypes-RetOiIg$ui_text(fontFamily, fontWeight, n);
    }

    private final void ensureRegistered(Typeface typeface2, String string) {
        if (!this.registered.contains(string)) {
            this.fontProvider.registerTypeface(typeface2, string);
            this.registered.add(string);
        }
    }

    private final List<String> ensureRegistered(FontFamily fontFamily) {
        Object object = fontFamily;
        if (object instanceof FontListFontFamily) {
            object = ((FontListFontFamily)fontFamily).getFonts();
            ArrayList arrayList = new ArrayList(object.size());
            int n = ((Collection)object).size();
            for (int k = 0; k < n; ++k) {
                Object e = object.get(k);
                Object object2 = e;
                object2 = e;
                object2 = (Font)e;
                String string = object2 instanceof SystemFont ? ((PlatformFont)((SystemFont)object2)).getIdentity() : null;
                if (string == null) continue;
                object2 = string;
                ((Collection)arrayList).add(object2);
            }
            object = arrayList;
            if (object.size() == ((FontListFontFamily)fontFamily).getFonts().size()) {
                return object;
            }
            throw new IllegalArgumentException("Don't load FontListFontFamily through ensureRegistered: " + fontFamily);
        }
        if (object instanceof LoadedFontFamily) {
            androidx.compose.ui.text.font.Typeface typeface2 = ((LoadedFontFamily)fontFamily).getTypeface();
            Intrinsics.checkNotNull((Object)typeface2);
            object = (SkiaBackedTypeface)typeface2;
            this.ensureRegistered(((SkiaBackedTypeface)object).getNativeTypeface(), ((SkiaBackedTypeface)object).getAlias());
            return CollectionsKt.listOf((Object)((SkiaBackedTypeface)object).getAlias());
        }
        if (object instanceof GenericFontFamily) {
            return PlatformFont_skikoKt.getAliases((GenericFontFamily)fontFamily);
        }
        if (object instanceof DefaultFontFamily) {
            return PlatformFont_skikoKt.getAliases(FontFamily.Companion.getSansSerif());
        }
        throw new IllegalArgumentException("Unknown font family type: " + fontFamily);
    }

    private static final Typeface load$lambda$0(PlatformFont platformFont, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return DesktopFont_desktopKt.loadTypeface(platformFont);
    }
}

