/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.statements.api.ExposedBlob;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/BlobColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedBlob;", "useObjectIdentifier", "", "(Z)V", "getUseObjectIdentifier", "()Z", "nonNullValueToString", "", "value", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "setParameter", "", "stmt", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "", "sqlType", "valueFromDB", "exposed-core"})
public final class BlobColumnType
extends ColumnType<ExposedBlob> {
    private final boolean useObjectIdentifier;

    public BlobColumnType(boolean bl) {
        super(false, 1, null);
        this.useObjectIdentifier = bl;
    }

    public /* synthetic */ BlobColumnType(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getUseObjectIdentifier() {
        return this.useObjectIdentifier;
    }

    @Override
    public final String sqlType() {
        if (this.useObjectIdentifier && DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect) {
            return "oid";
        }
        if (this.useObjectIdentifier) {
            throw new IllegalStateException("Storing BLOBs using OID columns is only supported by PostgreSQL".toString());
        }
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().blobType();
    }

    @Override
    public final ExposedBlob valueFromDB(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Object object2 = object;
        if (object2 instanceof ExposedBlob) {
            return (ExposedBlob)object;
        }
        if (object2 instanceof InputStream) {
            return new ExposedBlob((InputStream)object);
        }
        if (object2 instanceof byte[]) {
            return new ExposedBlob((byte[])object);
        }
        if (object2 instanceof Blob) {
            InputStream inputStream = ((Blob)object).getBinaryStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"");
            return new ExposedBlob(inputStream);
        }
        throw new IllegalStateException(("Unexpected value of type Blob: " + object + " of " + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName()).toString());
    }

    @Override
    public final String nonNullValueToString(ExposedBlob exposedBlob) {
        Intrinsics.checkNotNullParameter((Object)exposedBlob, (String)"");
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().hexToDb(exposedBlob.hexString());
    }

    @Override
    public final ExposedBlob readObject(ResultSet object, int n) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (DatabaseDialectKt.getCurrentDialect() instanceof SQLServerDialect) {
            byte[] byArray = object.getBytes(n);
            if (byArray != null) {
                object = byArray;
                return new ExposedBlob((byte[])object);
            }
            return null;
        }
        if (DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect && this.useObjectIdentifier) {
            Object object2 = object.getBlob(n);
            if (object2 != null && (object2 = object2.getBinaryStream()) != null) {
                object = object2;
                return new ExposedBlob((InputStream)object);
            }
            return null;
        }
        InputStream inputStream = object.getBinaryStream(n);
        if (inputStream != null) {
            object = inputStream;
            return new ExposedBlob((InputStream)object);
        }
        return null;
    }

    @Override
    public final void setParameter(PreparedStatementApi preparedStatementApi, int n, Object object) {
        Intrinsics.checkNotNullParameter((Object)preparedStatementApi, (String)"");
        Object object2 = object instanceof ExposedBlob ? (ExposedBlob)object : null;
        if (object2 == null || (object2 = ((ExposedBlob)object2).getInputStream()) == null) {
            object2 = object = object;
        }
        if (object2 instanceof InputStream) {
            preparedStatementApi.setInputStream(n, (InputStream)object, this.useObjectIdentifier);
            return;
        }
        Object object3 = object;
        if (object3 == null ? true : object3 instanceof Op.NULL) {
            preparedStatementApi.setNull(n, this);
            return;
        }
        super.setParameter(preparedStatementApi, n, object);
    }

    public BlobColumnType() {
        this(false, 1, null);
    }
}

