/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.exceptions.ExposedSQLException;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ&\u0010\u0010\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00120\u00110\u0011H&J\u0015\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00060\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001aJ\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u001d\u001a\u00020\nH&J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u001b\u0010 \u001a\u0004\u0018\u00018\u0000*\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H&\u00a2\u0006\u0002\u0010!R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/sql/statements/Statement;", "T", "", "type", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "targets", "", "Lorg/jetbrains/exposed/sql/Table;", "(Lorg/jetbrains/exposed/sql/statements/StatementType;Ljava/util/List;)V", "isAlwaysBatch", "", "()Z", "getTargets", "()Ljava/util/List;", "getType", "()Lorg/jetbrains/exposed/sql/statements/StatementType;", "arguments", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "execute", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Object;", "executeIn", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "executeIn$exposed_core", "prepareSQL", "", "prepared", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "sql", "executeInternal", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Object;", "exposed-core"})
public abstract class Statement<T> {
    private final StatementType type;
    private final List<Table> targets;
    private final boolean isAlwaysBatch;

    public Statement(StatementType statementType, List<? extends Table> list) {
        Intrinsics.checkNotNullParameter((Object)((Object)statementType), (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.type = statementType;
        this.targets = list;
    }

    public final StatementType getType() {
        return this.type;
    }

    public final List<Table> getTargets() {
        return this.targets;
    }

    public abstract T executeInternal(PreparedStatementApi var1, Transaction var2);

    public abstract String prepareSQL(Transaction var1, boolean var2);

    public static /* synthetic */ String prepareSQL$default(Statement statement, Transaction transaction2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareSQL");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return statement.prepareSQL(transaction2, bl);
    }

    public abstract Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments();

    public PreparedStatementApi prepared(Transaction transaction2, String string) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return transaction2.getConnection().prepareStatement(string, false);
    }

    public boolean isAlwaysBatch() {
        return this.isAlwaysBatch;
    }

    public final T execute(Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        if (transaction2.getBlockStatementExecution$exposed_core()) {
            transaction2.setExplainStatement$exposed_core(this);
            return null;
        }
        return transaction2.exec(this);
    }

    public final Pair<T, List<StatementContext>> executeIn$exposed_core(Transaction transaction2) {
        List list;
        Iterator iterator2;
        Object object;
        Iterator iterator3;
        Iterator iterator4;
        Iterator iterator5;
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        Object object2 = this.arguments();
        if (CollectionsKt.any(object2)) {
            iterator5 = object2;
            iterator4 = iterator5;
            iterator3 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterator5, (int)10));
            object = iterator4.iterator();
            while (object.hasNext()) {
                Iterable<Pair<IColumnType<?>, Object>> iterable = object.next();
                iterator2 = iterable;
                iterator4 = iterator3;
                object2 = new StatementContext(this, (Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>>)((Object)iterator2));
                iterator5 = Transaction.Companion.getGlobalInterceptors$exposed_core();
                iterator5 = iterator5.iterator();
                while (iterator5.hasNext()) {
                    iterator2 = iterator5.next();
                    iterator2 = (GlobalStatementInterceptor)((Object)iterator2);
                    iterator2.beforeExecution(transaction2, (StatementContext)object2);
                }
                iterator5 = transaction2.getInterceptors$exposed_core();
                iterator5 = iterator5.iterator();
                while (iterator5.hasNext()) {
                    iterator2 = iterator5.next();
                    iterator2 = (StatementInterceptor)((Object)iterator2);
                    iterator2.beforeExecution(transaction2, (StatementContext)object2);
                }
                iterator4.add((Object)object2);
            }
            list = (List)((Object)iterator3);
        } else {
            iterator5 = new StatementContext(this, CollectionsKt.emptyList());
            iterator2 = (Iterable<Pair<IColumnType<?>, Object>>)Transaction.Companion.getGlobalInterceptors$exposed_core();
            iterator3 = iterator2.iterator();
            while (iterator3.hasNext()) {
                iterator4 = iterator3.next();
                object = (GlobalStatementInterceptor)((Object)iterator4);
                object.beforeExecution(transaction2, (StatementContext)((Object)iterator5));
            }
            iterator2 = transaction2.getInterceptors$exposed_core();
            iterator3 = iterator2.iterator();
            while (iterator3.hasNext()) {
                iterator4 = iterator3.next();
                object = (StatementInterceptor)((Object)iterator4);
                object.beforeExecution(transaction2, (StatementContext)((Object)iterator5));
            }
            list = CollectionsKt.listOf((Object)iterator5);
        }
        object2 = list;
        try {
            iterator2 = this.prepared(transaction2, Statement.prepareSQL$default(this, transaction2, false, 2, null));
            iterator4 = iterator2;
            iterator2.setTimeout(transaction2.getQueryTimeout());
        }
        catch (SQLException sQLException) {
            throw new ExposedSQLException(sQLException, (List<StatementContext>)object2, transaction2);
        }
        iterator5 = iterator2;
        iterator2 = (Iterable)object2;
        int n = 0;
        iterator4 = iterator2.iterator();
        while (iterator4.hasNext()) {
            int n2;
            object = iterator4.next();
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            iterator2 = (StatementContext)object;
            iterator5.fillParameters(((StatementContext)((Object)iterator2)).getArgs());
            if (object2.size() <= 1 && !this.isAlwaysBatch()) continue;
            iterator5.addBatch();
        }
        if (!transaction2.getDb().getSupportsMultipleResultSets()) {
            transaction2.closeExecutedStatements();
        }
        transaction2.setCurrentStatement((PreparedStatementApi)((Object)iterator5));
        iterator2 = transaction2.getInterceptors$exposed_core();
        Iterator iterator6 = iterator2.iterator();
        while (iterator6.hasNext()) {
            iterator4 = iterator6.next();
            object = (StatementInterceptor)((Object)iterator4);
            object.afterStatementPrepared(transaction2, (PreparedStatementApi)((Object)iterator5));
        }
        try {
            iterator4 = this.executeInternal((PreparedStatementApi)((Object)iterator5), transaction2);
        }
        catch (SQLException sQLException) {
            throw new ExposedSQLException(sQLException, (List<StatementContext>)object2, transaction2);
        }
        iterator2 = iterator4;
        transaction2.setCurrentStatement(null);
        transaction2.getExecutedStatements$exposed_core().add((PreparedStatementApi)((Object)iterator5));
        iterator4 = Transaction.Companion.getGlobalInterceptors$exposed_core();
        iterator4 = iterator4.iterator();
        while (iterator4.hasNext()) {
            object = iterator4.next();
            GlobalStatementInterceptor globalStatementInterceptor = (GlobalStatementInterceptor)object;
            globalStatementInterceptor.afterExecution(transaction2, (List<StatementContext>)object2, (PreparedStatementApi)((Object)iterator5));
        }
        iterator4 = transaction2.getInterceptors$exposed_core();
        iterator4 = iterator4.iterator();
        while (iterator4.hasNext()) {
            object = iterator4.next();
            StatementInterceptor statementInterceptor = (StatementInterceptor)object;
            statementInterceptor.afterExecution(transaction2, (List<StatementContext>)object2, (PreparedStatementApi)((Object)iterator5));
        }
        return TuplesKt.to(iterator2, (Object)object2);
    }
}

