/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0004H\u0016J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0006H\u0016\u00a8\u0006&"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "length", "", "booleanFromStringToBoolean", "", "value", "booleanToStatementString", "bool", "booleanType", "byteType", "dateTimeType", "hexToDb", "hexString", "integerAutoincType", "integerType", "jsonType", "largeTextType", "longAutoincType", "longType", "mediumTextType", "textType", "timeType", "ubyteType", "uintegerAutoincType", "uintegerType", "ulongAutoincType", "ulongType", "ushortType", "uuidToDB", "", "Ljava/util/UUID;", "uuidType", "varcharType", "colLength", "exposed-core"})
public final class OracleDataTypeProvider
extends DataTypeProvider {
    public static final OracleDataTypeProvider INSTANCE = new OracleDataTypeProvider();

    private OracleDataTypeProvider() {
    }

    @Override
    public final String byteType() {
        return "SMALLINT";
    }

    @Override
    public final String ubyteType() {
        return "NUMBER(4)";
    }

    @Override
    public final String ushortType() {
        return "NUMBER(6)";
    }

    @Override
    public final String integerType() {
        return "NUMBER(12)";
    }

    @Override
    public final String integerAutoincType() {
        return "NUMBER(12)";
    }

    @Override
    public final String uintegerType() {
        return "NUMBER(13)";
    }

    @Override
    public final String uintegerAutoincType() {
        return "NUMBER(13)";
    }

    @Override
    public final String longType() {
        return "NUMBER(19)";
    }

    @Override
    public final String longAutoincType() {
        return "NUMBER(19)";
    }

    @Override
    public final String ulongType() {
        return "NUMBER(20)";
    }

    @Override
    public final String ulongAutoincType() {
        return "NUMBER(20)";
    }

    @Override
    public final String varcharType(int n) {
        return "VARCHAR2(" + n + " CHAR)";
    }

    @Override
    public final String textType() {
        return "CLOB";
    }

    @Override
    public final String mediumTextType() {
        return ((DataTypeProvider)this).textType();
    }

    @Override
    public final String largeTextType() {
        return ((DataTypeProvider)this).textType();
    }

    @Override
    public final String timeType() {
        return ((DataTypeProvider)this).dateTimeType();
    }

    @Override
    public final String binaryType() {
        SQLLogKt.getExposedLogger().error("Binary type is unsupported for Oracle. Please use blob column type instead.");
        throw new IllegalStateException("Binary type is unsupported for Oracle. Please use blob column type instead.".toString());
    }

    @Override
    public final String binaryType(int n) {
        if (n < 2000) {
            return "RAW (" + n + ')';
        }
        return ((DataTypeProvider)this).binaryType();
    }

    @Override
    public final String uuidType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if ((h2Dialect != null ? h2Dialect.getH2Mode() : null) == H2Dialect.H2CompatibilityMode.Oracle) {
            return "UUID";
        }
        return "RAW(16)";
    }

    @Override
    public final Object uuidToDB(UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if ((h2Dialect != null ? h2Dialect.getH2Mode() : null) == H2Dialect.H2CompatibilityMode.Oracle) {
            return ((DataTypeProvider)H2DataTypeProvider.INSTANCE).uuidToDB(uUID);
        }
        return super.uuidToDB(uUID);
    }

    @Override
    public final String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    public final String booleanType() {
        return "CHAR(1)";
    }

    @Override
    public final String booleanToStatementString(boolean bl) {
        if (bl) {
            return "1";
        }
        return "0";
    }

    @Override
    public final boolean booleanFromStringToBoolean(String string) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            bl = Long.parseLong(string) != 0L;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                bl = StringsKt.toBooleanStrict((String)string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(("Unexpected value of type Boolean: " + string).toString());
            }
        }
        return bl;
    }

    @Override
    public final String jsonType() {
        return "VARCHAR2(4000)";
    }

    @Override
    public final String hexToDb(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "HEXTORAW('" + string + "')";
    }
}

