/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatTreeUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FlatTreeCollapsedIcon
extends FlatAbstractIcon {
    private final boolean chevron = FlatUIUtils.isChevron(UIManager.getString("Component.arrowType"));
    private Path2D path;

    public FlatTreeCollapsedIcon() {
        this(UIManager.getColor("Tree.icon.collapsedColor"));
    }

    FlatTreeCollapsedIcon(Color color) {
        super(11, 11, color);
    }

    @Override
    protected void paintIcon(Component object, Graphics2D graphics2D) {
        this.setStyleColorFromTreeUI((Component)object, graphics2D);
        this.rotate((Component)object, graphics2D);
        object = FlatTreeCollapsedIcon.getStyleFromTreeUI((Component)object, flatTreeUI -> flatTreeUI.iconArrowType);
        boolean bl = object != null ? FlatUIUtils.isChevron((String)object) : this.chevron;
        if (bl) {
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 0));
            if (this.path == null) {
                this.path = FlatUIUtils.createPath(false, 3.5, 1.5, 7.5, 5.5, 3.5, 9.5);
            }
            graphics2D.draw(this.path);
            return;
        }
        if (this.path == null) {
            this.path = FlatUIUtils.createPath(2.0, 1.0, 2.0, 10.0, 10.0, 5.5);
        }
        graphics2D.fill(this.path);
    }

    void setStyleColorFromTreeUI(Component component, Graphics2D graphics2D) {
        FlatTreeCollapsedIcon.setStyleColorFromTreeUI(component, graphics2D, flatTreeUI -> flatTreeUI.iconCollapsedColor);
    }

    void rotate(Component component, Graphics2D graphics2D) {
        if (!component.getComponentOrientation().isLeftToRight()) {
            graphics2D.rotate(Math.toRadians(180.0), (double)this.width / 2.0, (double)this.height / 2.0);
        }
    }

    static <T> T getStyleFromTreeUI(Component object, Function<FlatTreeUI, T> function) {
        if ((object = object instanceof JTree ? (JTree)object : (JTree)SwingUtilities.getAncestorOfClass(JTree.class, (Component)object)) != null && (object = ((JTree)object).getUI()) instanceof FlatTreeUI) {
            return function.apply((FlatTreeUI)object);
        }
        return null;
    }

    static void setStyleColorFromTreeUI(Component serializable, Graphics2D graphics2D, Function<FlatTreeUI, Color> function) {
        if ((serializable = FlatTreeCollapsedIcon.getStyleFromTreeUI(serializable, function)) != null) {
            graphics2D.setColor((Color)serializable);
        }
    }
}

