/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;

public class FlatArrowButton
extends BasicArrowButton
implements UIResource {
    public static final int DEFAULT_ARROW_WIDTH = 9;
    protected boolean chevron;
    protected Color foreground;
    protected Color disabledForeground;
    protected Color hoverForeground;
    protected Color hoverBackground;
    protected Color pressedForeground;
    protected Color pressedBackground;
    private int arrowWidth;
    private float arrowThickness;
    private float xOffset;
    private float yOffset;
    private boolean roundBorderAutoXOffset;
    private boolean hover;
    private boolean pressed;

    public FlatArrowButton(int n, String string, Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        Color color7 = Color.WHITE;
        Color color8 = Color.WHITE;
        super(n, color7, color7, color8, color8);
        this.arrowWidth = 9;
        this.arrowThickness = 1.0f;
        this.xOffset = 0.0f;
        this.yOffset = 0.0f;
        this.roundBorderAutoXOffset = true;
        this.updateStyle(string, color, color2, color3, color4, color5, color6);
        this.setOpaque(false);
        this.setBorder(null);
        if (color3 != null || color4 != null || color5 != null || color6 != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    FlatArrowButton.this.hover = true;
                    FlatArrowButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    FlatArrowButton.this.hover = false;
                    FlatArrowButton.this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        FlatArrowButton.this.pressed = true;
                        FlatArrowButton.this.repaint();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        FlatArrowButton.this.pressed = false;
                        FlatArrowButton.this.repaint();
                    }
                }
            });
        }
    }

    public void updateStyle(String string, Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        this.chevron = FlatUIUtils.isChevron(string);
        this.foreground = color;
        this.disabledForeground = color2;
        this.hoverForeground = color3;
        this.hoverBackground = color4;
        this.pressedForeground = color5;
        this.pressedBackground = color6;
    }

    public int getArrowWidth() {
        return this.arrowWidth;
    }

    public void setArrowWidth(int n) {
        this.arrowWidth = n;
    }

    public float getArrowThickness() {
        return this.arrowThickness;
    }

    public void setArrowThickness(float f) {
        this.arrowThickness = f;
    }

    protected boolean isHover() {
        return this.hover;
    }

    protected boolean isPressed() {
        return this.pressed;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(float f) {
        this.xOffset = f;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(float f) {
        this.yOffset = f;
    }

    public boolean isRoundBorderAutoXOffset() {
        return this.roundBorderAutoXOffset;
    }

    public void setRoundBorderAutoXOffset(boolean bl) {
        this.roundBorderAutoXOffset = bl;
    }

    protected Color deriveBackground(Color color) {
        return color;
    }

    protected Color deriveForeground(Color color) {
        return FlatUIUtils.deriveColor(color, this.foreground);
    }

    protected Color getArrowColor() {
        if (this.isEnabled()) {
            if (this.pressedForeground != null && this.isPressed()) {
                return this.pressedForeground;
            }
            if (this.hoverForeground != null && this.isHover()) {
                return this.hoverForeground;
            }
            return this.foreground;
        }
        return this.disabledForeground;
    }

    @Override
    public Dimension getPreferredSize() {
        return UIScale.scale(super.getPreferredSize());
    }

    @Override
    public Dimension getMinimumSize() {
        return UIScale.scale(super.getMinimumSize());
    }

    @Override
    public void paint(Graphics graphics) {
        Color color;
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
        if (this.isEnabled() && (this.pressedBackground != null && this.isPressed() ? this.pressedBackground : (color = this.hoverBackground != null && this.isHover() ? this.hoverBackground : null)) != null) {
            graphics.setColor(this.deriveBackground(color));
            this.paintBackground((Graphics2D)graphics);
        }
        FlatArrowButton flatArrowButton = this;
        graphics.setColor(flatArrowButton.deriveForeground(flatArrowButton.getArrowColor()));
        this.paintArrow((Graphics2D)graphics);
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    protected void paintBackground(Graphics2D graphics2D) {
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected void paintArrow(Graphics2D graphics2D) {
        int n = 0;
        if (this.isRoundBorderAutoXOffset()) {
            Container container = this.getParent();
            boolean bl = this.direction == 1 || this.direction == 5;
            if (bl && container instanceof JComponent && FlatUIUtils.hasRoundBorder((JComponent)container)) {
                n = 0 - UIScale.scale(container.getComponentOrientation().isLeftToRight() ? 1 : -1);
            }
        }
        FlatUIUtils.paintArrow(graphics2D, n, 0, this.getWidth(), this.getHeight(), this.getDirection(), this.chevron, this.getArrowWidth(), this.getArrowThickness(), this.getXOffset(), this.getYOffset());
    }
}

