/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatListUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FlatListCellBorder
extends FlatLineBorder {
    protected boolean showCellFocusIndicator = UIManager.getBoolean("List.showCellFocusIndicator");
    private Component c;

    protected FlatListCellBorder() {
        super(UIManager.getInsets("List.cellMargins"), UIManager.getColor("List.cellFocusColor"));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2 = FlatListCellBorder.getStyleFromListUI(component, flatListUI -> flatListUI.cellMargins);
        if (insets2 != null) {
            return FlatListCellBorder.scaleInsets(component, insets, insets2.top, insets2.left, insets2.bottom, insets2.right);
        }
        return super.getBorderInsets(component, insets);
    }

    @Override
    public Color getLineColor() {
        Color color;
        if (this.c != null && (color = FlatListCellBorder.getStyleFromListUI(this.c, flatListUI -> flatListUI.cellFocusColor)) != null) {
            return color;
        }
        return super.getLineColor();
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.c = component;
        super.paintBorder(component, graphics, n, n2, n3, n4);
        this.c = null;
    }

    static <T> T getStyleFromListUI(Component object, Function<FlatListUI, T> function) {
        if ((object = (JList)SwingUtilities.getAncestorOfClass(JList.class, (Component)object)) != null && (object = ((JList)object).getUI()) instanceof FlatListUI) {
            return function.apply((FlatListUI)object);
        }
        return null;
    }

    public static class Selected
    extends FlatListCellBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Boolean bl = Selected.getStyleFromListUI(component, flatListUI -> flatListUI.showCellFocusIndicator);
            boolean bl2 = bl != null ? bl : this.showCellFocusIndicator;
            if (!bl2) {
                return;
            }
            JList jList = (JList)SwingUtilities.getAncestorOfClass(JList.class, component);
            if (jList != null && jList.getMinSelectionIndex() == jList.getMaxSelectionIndex()) {
                return;
            }
            super.paintBorder(component, graphics, n, n2, n3, n4);
        }
    }

    public static class Focused
    extends FlatListCellBorder {
    }

    public static class Default
    extends FlatListCellBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }
    }
}

