/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.plaf.UIResource;
import javax.swing.text.StyleContext;

public class FontUtils {
    private static Map<String, Runnable> loadersMap;

    public static Font getCompositeFont(String object, int n, int n2) {
        FontUtils.loadFontFamily((String)object);
        object = StyleContext.getDefaultStyleContext().getFont((String)object, n, n2);
        if (object instanceof UIResource) {
            Object object2 = object;
            object = ((Font)object2).deriveFont(((Font)object2).getStyle());
        }
        return object;
    }

    public static void registerFontFamilyLoader(String string, Runnable runnable) {
        if (loadersMap == null) {
            loadersMap = new HashMap<String, Runnable>();
        }
        loadersMap.put(string, runnable);
    }

    public static void loadFontFamily(String object) {
        if (!FontUtils.hasLoaders()) {
            return;
        }
        if ((object = loadersMap.remove(object)) != null) {
            object.run();
        }
        if (loadersMap.isEmpty()) {
            loadersMap = null;
        }
    }

    public static boolean installFont(URL uRL) {
        boolean bl;
        block8: {
            InputStream inputStream = uRL.openStream();
            try {
                Font font = Font.createFont(0, inputStream);
                bl = GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FontFormatException | IOException exception) {
                    LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to install font " + uRL, exception);
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    public static String[] getAvailableFontFamilyNames() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (!FontUtils.hasLoaders()) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + loadersMap.size());
        for (String string : stringArray) {
            arrayList.add(string);
        }
        for (String string : loadersMap.keySet()) {
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    public static Font[] getAllFonts() {
        if (FontUtils.hasLoaders()) {
            String[] stringArray = loadersMap.keySet().toArray(new String[loadersMap.size()]);
            String[] stringArray2 = stringArray;
            stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray2[i];
                FontUtils.loadFontFamily(string);
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    }

    private static boolean hasLoaders() {
        return loadersMap != null && !loadersMap.isEmpty();
    }
}

