/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class UIScale {
    private static final boolean DEBUG = false;
    private static PropertyChangeSupport changeSupport;
    private static Boolean jreHiDPI;
    private static float scaleFactor;
    private static boolean initialized;

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (changeSupport == null) {
            changeSupport = new PropertyChangeSupport(UIScale.class);
        }
        changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (changeSupport == null) {
            return;
        }
        changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public static boolean isSystemScalingEnabled() {
        if (jreHiDPI != null) {
            return jreHiDPI;
        }
        jreHiDPI = Boolean.FALSE;
        if (SystemInfo.isJava_9_orLater) {
            jreHiDPI = Boolean.TRUE;
        } else if (SystemInfo.isJetBrainsJVM) {
            try {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GenericDeclaration genericDeclaration = Class.forName("sun.java2d.SunGraphicsEnvironment");
                if (genericDeclaration.isInstance(graphicsEnvironment)) {
                    genericDeclaration = genericDeclaration.getDeclaredMethod("isUIScaleOn", new Class[0]);
                    jreHiDPI = (Boolean)((Method)genericDeclaration).invoke(graphicsEnvironment, new Object[0]);
                }
            }
            catch (Throwable throwable) {}
        }
        return jreHiDPI;
    }

    public static double getSystemScaleFactor(Graphics2D graphics2D) {
        if (UIScale.isSystemScalingEnabled()) {
            return UIScale.getSystemScaleFactor(graphics2D.getDeviceConfiguration());
        }
        return 1.0;
    }

    public static double getSystemScaleFactor(GraphicsConfiguration graphicsConfiguration) {
        if (UIScale.isSystemScalingEnabled() && graphicsConfiguration != null) {
            return graphicsConfiguration.getDefaultTransform().getScaleX();
        }
        return 1.0;
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (!UIScale.isUserScalingEnabled()) {
            return;
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                switch (propertyChangeEvent.getPropertyName()) {
                    case "lookAndFeel": {
                        if (propertyChangeEvent.getNewValue() instanceof LookAndFeel) {
                            UIManager.getLookAndFeelDefaults().addPropertyChangeListener(this);
                        }
                        UIScale.updateScaleFactor();
                        return;
                    }
                    case "defaultFont": 
                    case "Label.font": {
                        UIScale.updateScaleFactor();
                    }
                }
            }
        };
        UIManager.addPropertyChangeListener(propertyChangeListener);
        UIManager.getDefaults().addPropertyChangeListener(propertyChangeListener);
        UIManager.getLookAndFeelDefaults().addPropertyChangeListener(propertyChangeListener);
        UIScale.updateScaleFactor();
    }

    private static void updateScaleFactor() {
        float f;
        if (!UIScale.isUserScalingEnabled()) {
            return;
        }
        float f2 = UIScale.getCustomScaleFactor();
        if (f > 0.0f) {
            UIScale.setUserScaleFactor(f2, false);
            return;
        }
        Font font = UIManager.getFont("defaultFont");
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        UIScale.setUserScaleFactor(UIScale.computeFontScaleFactor(font), true);
    }

    public static float computeFontScaleFactor(Font font) {
        Font font2;
        if (SystemInfo.isWindows && font instanceof UIResource && ((font2 = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) == null || font2.getSize() == font.getSize())) {
            if (UIScale.isSystemScalingEnabled()) {
                return 1.0f;
            }
            font2 = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.defaultGUI.font");
            return UIScale.computeScaleFactor(font2 != null ? font2 : font);
        }
        return UIScale.computeScaleFactor(font);
    }

    private static float computeScaleFactor(Font font) {
        float f;
        block3: {
            float f2;
            block4: {
                block5: {
                    block2: {
                        f = 12.0f;
                        if (!SystemInfo.isWindows) break block2;
                        if (!"Tahoma".equals(font.getFamily())) break block3;
                        f2 = 11.0f;
                        break block4;
                    }
                    if (!SystemInfo.isMacOS) break block5;
                    f2 = 13.0f;
                    break block4;
                }
                if (!SystemInfo.isLinux) break block3;
                f2 = SystemInfo.isKDE ? 13.0f : 15.0f;
            }
            f = f2;
        }
        return (float)font.getSize() / f;
    }

    private static boolean isUserScalingEnabled() {
        return FlatSystemProperties.getBoolean("flatlaf.uiScale.enabled", true);
    }

    public static FontUIResource applyCustomScaleFactor(FontUIResource fontUIResource) {
        float f;
        if (!UIScale.isUserScalingEnabled()) {
            return fontUIResource;
        }
        float f2 = UIScale.getCustomScaleFactor();
        if (f <= 0.0f) {
            return fontUIResource;
        }
        float f3 = UIScale.computeScaleFactor(fontUIResource);
        if (f2 == f3) {
            return fontUIResource;
        }
        int n = Math.max(Math.round((float)fontUIResource.getSize() / f3 * f2), 1);
        return new FontUIResource(fontUIResource.deriveFont((float)n));
    }

    private static float getCustomScaleFactor() {
        return UIScale.parseScaleFactor(System.getProperty("flatlaf.uiScale"));
    }

    private static float parseScaleFactor(String string) {
        if (string == null) {
            return -1.0f;
        }
        float f = 1.0f;
        if (string.endsWith("x")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.endsWith("dpi")) {
            f = 96.0f;
            string = string.substring(0, string.length() - 3);
        } else if (string.endsWith("%")) {
            f = 100.0f;
            string = string.substring(0, string.length() - 1);
        }
        try {
            float f2;
            float f3 = Float.parseFloat(string);
            if (f2 > 0.0f) {
                return f3 / f;
            }
            return -1.0f;
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0f;
        }
    }

    public static float getUserScaleFactor() {
        UIScale.initialize();
        return scaleFactor;
    }

    private static void setUserScaleFactor(float f, boolean bl) {
        if (bl) {
            if (f < 1.0f) {
                f = FlatSystemProperties.getBoolean("flatlaf.uiScale.allowScaleDown", false) ? (float)Math.round(f * 10.0f) / 10.0f : 1.0f;
            } else if (f > 1.0f) {
                f = (float)Math.round(f * 4.0f) / 4.0f;
            }
        }
        f = Math.max(f, 0.1f);
        float f2 = scaleFactor;
        scaleFactor = f;
        if (changeSupport != null) {
            changeSupport.firePropertyChange("userScaleFactor", Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public static float scale(float f) {
        UIScale.initialize();
        if (scaleFactor == 1.0f) {
            return f;
        }
        return f * scaleFactor;
    }

    public static int scale(int n) {
        UIScale.initialize();
        if (scaleFactor == 1.0f) {
            return n;
        }
        return Math.round((float)n * scaleFactor);
    }

    public static int scale2(int n) {
        UIScale.initialize();
        if (scaleFactor == 1.0f) {
            return n;
        }
        return (int)((float)n * scaleFactor);
    }

    public static float unscale(float f) {
        UIScale.initialize();
        if (scaleFactor == 1.0f) {
            return f;
        }
        return f / scaleFactor;
    }

    public static int unscale(int n) {
        UIScale.initialize();
        if (scaleFactor == 1.0f) {
            return n;
        }
        return Math.round((float)n / scaleFactor);
    }

    public static void scaleGraphics(Graphics2D graphics2D) {
        UIScale.initialize();
        if (scaleFactor != 1.0f) {
            graphics2D.scale(scaleFactor, scaleFactor);
        }
    }

    public static Dimension scale(Dimension dimension) {
        UIScale.initialize();
        if (dimension == null || scaleFactor == 1.0f) {
            return dimension;
        }
        if (dimension instanceof UIResource) {
            return new DimensionUIResource(UIScale.scale(dimension.width), UIScale.scale(dimension.height));
        }
        return new Dimension(UIScale.scale(dimension.width), UIScale.scale(dimension.height));
    }

    public static Insets scale(Insets insets) {
        UIScale.initialize();
        if (insets == null || scaleFactor == 1.0f) {
            return insets;
        }
        if (insets instanceof UIResource) {
            return new InsetsUIResource(UIScale.scale(insets.top), UIScale.scale(insets.left), UIScale.scale(insets.bottom), UIScale.scale(insets.right));
        }
        return new Insets(UIScale.scale(insets.top), UIScale.scale(insets.left), UIScale.scale(insets.bottom), UIScale.scale(insets.right));
    }

    static {
        scaleFactor = 1.0f;
    }
}

