/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractCoalescingBufferQueue;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.util.internal.ObjectUtil;

public final class CoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final Channel channel;

    public CoalescingBufferQueue(Channel channel) {
        this(channel, 4);
    }

    public CoalescingBufferQueue(Channel channel, int n) {
        this(channel, n, false);
    }

    public CoalescingBufferQueue(Channel channel, int n, boolean bl) {
        super(bl ? channel : null, n);
        this.channel = (Channel)ObjectUtil.checkNotNull((Object)channel, (String)"channel");
    }

    public final ByteBuf remove(int n, ChannelPromise channelPromise) {
        CoalescingBufferQueue coalescingBufferQueue = this;
        return coalescingBufferQueue.remove(coalescingBufferQueue.channel.alloc(), n, channelPromise);
    }

    public final void releaseAndFailAll(Throwable throwable) {
        CoalescingBufferQueue coalescingBufferQueue = this;
        coalescingBufferQueue.releaseAndFailAll(coalescingBufferQueue.channel, throwable);
    }

    @Override
    protected final ByteBuf compose(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (byteBuf instanceof CompositeByteBuf) {
            byteBufAllocator = (CompositeByteBuf)byteBuf;
            byteBufAllocator.addComponent(true, byteBuf2);
            return byteBufAllocator;
        }
        return this.composeIntoComposite(byteBufAllocator, byteBuf, byteBuf2);
    }

    @Override
    protected final ByteBuf removeEmptyValue() {
        return Unpooled.EMPTY_BUFFER;
    }
}

