/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

final class EmbeddedEventLoop
extends AbstractScheduledEventExecutor
implements EventLoop {
    private long startTime = EmbeddedEventLoop.initialNanoTime();
    private long frozenTimestamp;
    private boolean timeFrozen;
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>(2);

    EmbeddedEventLoop() {
    }

    @Override
    public final EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public final EventLoop next() {
        return (EventLoop)super.next();
    }

    public final void execute(Runnable runnable) {
        this.tasks.add((Runnable)ObjectUtil.checkNotNull((Object)runnable, (String)"command"));
    }

    final void runTasks() {
        Runnable runnable;
        while ((runnable = this.tasks.poll()) != null) {
            runnable.run();
        }
    }

    final boolean hasPendingNormalTasks() {
        return !this.tasks.isEmpty();
    }

    final long runScheduledTasks() {
        long l = this.getCurrentTimeNanos();
        Runnable runnable;
        while ((runnable = this.pollScheduledTask(l)) != null) {
            runnable.run();
        }
        return this.nextScheduledTaskNano();
    }

    final long nextScheduledTask() {
        return this.nextScheduledTaskNano();
    }

    protected final long getCurrentTimeNanos() {
        if (this.timeFrozen) {
            return this.frozenTimestamp;
        }
        return System.nanoTime() - this.startTime;
    }

    final void advanceTimeBy(long l) {
        if (this.timeFrozen) {
            this.frozenTimestamp += l;
            return;
        }
        this.startTime -= l;
    }

    final void freezeTime() {
        if (!this.timeFrozen) {
            this.frozenTimestamp = this.getCurrentTimeNanos();
            this.timeFrozen = true;
        }
    }

    final void unfreezeTime() {
        if (this.timeFrozen) {
            this.startTime = System.nanoTime() - this.frozenTimestamp;
            this.timeFrozen = false;
        }
    }

    protected final void cancelScheduledTasks() {
        super.cancelScheduledTasks();
    }

    public final Future<?> shutdownGracefully(long l, long l2, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    public final Future<?> terminationFuture() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void shutdown() {
        throw new UnsupportedOperationException();
    }

    public final boolean isShuttingDown() {
        return false;
    }

    public final boolean isShutdown() {
        return false;
    }

    public final boolean isTerminated() {
        return false;
    }

    public final boolean awaitTermination(long l, TimeUnit timeUnit) {
        return false;
    }

    @Override
    public final ChannelFuture register(Channel channel) {
        return this.register(new DefaultChannelPromise(channel, (EventExecutor)this));
    }

    @Override
    public final ChannelFuture register(ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)channelPromise, (String)"promise");
        channelPromise.channel().unsafe().register(this, channelPromise);
        return channelPromise;
    }

    @Override
    @Deprecated
    public final ChannelFuture register(Channel channel, ChannelPromise channelPromise) {
        channel.unsafe().register(this, channelPromise);
        return channelPromise;
    }

    public final boolean inEventLoop() {
        return true;
    }

    public final boolean inEventLoop(Thread thread) {
        return true;
    }
}

