/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.SelectStrategyFactory;
import io.netty.channel.nio.NioEventLoop;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public class NioEventLoopGroup
extends MultithreadEventLoopGroup {
    public NioEventLoopGroup() {
        this(0);
    }

    public NioEventLoopGroup(int n) {
        this(n, (Executor)null);
    }

    public NioEventLoopGroup(ThreadFactory threadFactory) {
        this(0, threadFactory, SelectorProvider.provider());
    }

    public NioEventLoopGroup(int n, ThreadFactory threadFactory) {
        this(n, threadFactory, SelectorProvider.provider());
    }

    public NioEventLoopGroup(int n, Executor executor) {
        this(n, executor, SelectorProvider.provider());
    }

    public NioEventLoopGroup(int n, ThreadFactory threadFactory, SelectorProvider selectorProvider) {
        this(n, threadFactory, selectorProvider, DefaultSelectStrategyFactory.INSTANCE);
    }

    public NioEventLoopGroup(int n, ThreadFactory threadFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(n, threadFactory, selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject());
    }

    public NioEventLoopGroup(int n, Executor executor, SelectorProvider selectorProvider) {
        this(n, executor, selectorProvider, DefaultSelectStrategyFactory.INSTANCE);
    }

    public NioEventLoopGroup(int n, Executor executor, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(n, executor, selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject());
    }

    public NioEventLoopGroup(int n, Executor executor, EventExecutorChooserFactory eventExecutorChooserFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(n, executor, eventExecutorChooserFactory, new Object[]{selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject()});
    }

    public NioEventLoopGroup(int n, Executor executor, EventExecutorChooserFactory eventExecutorChooserFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, executor, eventExecutorChooserFactory, new Object[]{selectorProvider, selectStrategyFactory, rejectedExecutionHandler});
    }

    public NioEventLoopGroup(int n, Executor executor, EventExecutorChooserFactory eventExecutorChooserFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        super(n, executor, eventExecutorChooserFactory, new Object[]{selectorProvider, selectStrategyFactory, rejectedExecutionHandler, eventLoopTaskQueueFactory});
    }

    public NioEventLoopGroup(int n, Executor executor, EventExecutorChooserFactory eventExecutorChooserFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory eventLoopTaskQueueFactory, EventLoopTaskQueueFactory eventLoopTaskQueueFactory2) {
        super(n, executor, eventExecutorChooserFactory, new Object[]{selectorProvider, selectStrategyFactory, rejectedExecutionHandler, eventLoopTaskQueueFactory, eventLoopTaskQueueFactory2});
    }

    public void setIoRatio(int n) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EventExecutor eventExecutor = (EventExecutor)iterator.next();
            ((NioEventLoop)eventExecutor).setIoRatio(n);
        }
    }

    public void rebuildSelectors() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EventExecutor eventExecutor = (EventExecutor)iterator.next();
            ((NioEventLoop)eventExecutor).rebuildSelector();
        }
    }

    @Override
    protected EventLoop newChild(Executor executor, Object ... objectArray) {
        SelectorProvider selectorProvider = (SelectorProvider)objectArray[0];
        SelectStrategyFactory selectStrategyFactory = (SelectStrategyFactory)objectArray[1];
        RejectedExecutionHandler rejectedExecutionHandler = (RejectedExecutionHandler)objectArray[2];
        EventLoopTaskQueueFactory eventLoopTaskQueueFactory = null;
        EventLoopTaskQueueFactory eventLoopTaskQueueFactory2 = null;
        int n = objectArray.length;
        if (n > 3) {
            eventLoopTaskQueueFactory = (EventLoopTaskQueueFactory)objectArray[3];
        }
        if (n > 4) {
            eventLoopTaskQueueFactory2 = (EventLoopTaskQueueFactory)objectArray[4];
        }
        return new NioEventLoop(this, executor, selectorProvider, selectStrategyFactory.newSelectStrategy(), rejectedExecutionHandler, eventLoopTaskQueueFactory, eventLoopTaskQueueFactory2);
    }
}

