/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoop;
import io.netty.channel.oio.OioByteStreamChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.oio.DefaultOioSocketChannelConfig;
import io.netty.channel.socket.oio.OioSocketChannelConfig;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;

@Deprecated
public class OioSocketChannel
extends OioByteStreamChannel
implements SocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OioSocketChannel.class);
    private final Socket socket;
    private final OioSocketChannelConfig config;

    public OioSocketChannel() {
        this(new Socket());
    }

    public OioSocketChannel(Socket socket) {
        this(null, socket);
    }

    public OioSocketChannel(Channel channel, Socket socket) {
        super(channel);
        this.socket = socket;
        this.config = new DefaultOioSocketChannelConfig(this, socket);
        try {
            try {
                if (socket.isConnected()) {
                    this.activate(socket.getInputStream(), socket.getOutputStream());
                }
                socket.setSoTimeout(1000);
                return;
            }
            catch (Exception exception) {
                throw new ChannelException("failed to initialize a socket", exception);
            }
        }
        catch (Throwable throwable) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close a socket.", (Throwable)iOException);
            }
            throw throwable;
        }
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public OioSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public boolean isActive() {
        return !this.socket.isClosed() && this.socket.isConnected();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown() || !((OioByteStreamChannel)this).isActive();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown() || !((OioByteStreamChannel)this).isActive();
    }

    @Override
    public boolean isShutdown() {
        return this.socket.isInputShutdown() && this.socket.isOutputShutdown() || !((OioByteStreamChannel)this).isActive();
    }

    @Override
    protected final void doShutdownOutput() {
        this.shutdownOutput0();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        OioSocketChannel oioSocketChannel = this;
        return oioSocketChannel.shutdownOutput(oioSocketChannel.newPromise());
    }

    @Override
    public ChannelFuture shutdownInput() {
        OioSocketChannel oioSocketChannel = this;
        return oioSocketChannel.shutdownInput(oioSocketChannel.newPromise());
    }

    @Override
    public ChannelFuture shutdown() {
        OioSocketChannel oioSocketChannel = this;
        return oioSocketChannel.shutdown(oioSocketChannel.newPromise());
    }

    @Override
    protected int doReadBytes(ByteBuf byteBuf) {
        if (this.socket.isClosed()) {
            return -1;
        }
        try {
            return super.doReadBytes(byteBuf);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return 0;
        }
    }

    @Override
    public ChannelFuture shutdownOutput(final ChannelPromise channelPromise) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.shutdownOutput0(channelPromise);
        } else {
            eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    OioSocketChannel.this.shutdownOutput0(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void shutdownOutput0(ChannelPromise channelPromise) {
        try {
            this.shutdownOutput0();
            channelPromise.setSuccess();
            return;
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return;
        }
    }

    private void shutdownOutput0() {
        this.socket.shutdownOutput();
    }

    @Override
    public ChannelFuture shutdownInput(final ChannelPromise channelPromise) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.shutdownInput0(channelPromise);
        } else {
            eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    OioSocketChannel.this.shutdownInput0(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.socket.shutdownInput();
            channelPromise.setSuccess();
            return;
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return;
        }
    }

    @Override
    public ChannelFuture shutdown(final ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.shutdownOutput();
        if (channelFuture.isDone()) {
            this.shutdownOutputDone(channelFuture, channelPromise);
        } else {
            channelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    OioSocketChannel.this.shutdownOutputDone(channelFuture, channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void shutdownOutputDone(final ChannelFuture channelFuture, final ChannelPromise channelPromise) {
        ChannelFuture channelFuture2 = this.shutdownInput();
        if (channelFuture2.isDone()) {
            OioSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
            return;
        }
        channelFuture2.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture2) {
                OioSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
            }
        });
    }

    private static void shutdownDone(ChannelFuture object, ChannelFuture object2, ChannelPromise channelPromise) {
        object = object.cause();
        object2 = object2.cause();
        if (object != null) {
            if (object2 != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", (Throwable)object2);
            }
            channelPromise.setFailure((Throwable)object);
            return;
        }
        if (object2 != null) {
            channelPromise.setFailure((Throwable)object2);
            return;
        }
        channelPromise.setSuccess();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        SocketUtils.bind((Socket)this.socket, (SocketAddress)socketAddress);
    }

    @Override
    protected void doConnect(SocketAddress serializable, SocketAddress socketAddress) {
        if (socketAddress != null) {
            SocketUtils.bind((Socket)this.socket, (SocketAddress)socketAddress);
        }
        int n = this.config().getConnectTimeoutMillis();
        try {
            try {
                SocketUtils.connect((Socket)this.socket, (SocketAddress)serializable, (int)n);
                OioSocketChannel oioSocketChannel = this;
                oioSocketChannel.activate(oioSocketChannel.socket.getInputStream(), this.socket.getOutputStream());
                return;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                serializable = new ConnectTimeoutException("connection timed out after " + n + " ms: " + serializable);
                ((Throwable)serializable).setStackTrace(socketTimeoutException.getStackTrace());
                throw serializable;
            }
        }
        catch (Throwable throwable) {
            this.doClose();
            throw throwable;
        }
    }

    @Override
    protected void doDisconnect() {
        this.doClose();
    }

    @Override
    protected void doClose() {
        this.socket.close();
    }

    protected boolean checkInputShutdown() {
        if (this.isInputShutdown()) {
            try {
                Thread.sleep(this.config().getSoTimeout());
            }
            catch (Throwable throwable) {}
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    protected void setReadPending(boolean bl) {
        super.setReadPending(bl);
    }

    final void clearReadPending0() {
        this.clearReadPending();
    }
}

