/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultHttpObject;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.internal.ObjectUtil;

public abstract class DefaultHttpMessage
extends DefaultHttpObject
implements HttpMessage {
    private static final int HASH_CODE_PRIME = 31;
    private HttpVersion version;
    private final HttpHeaders headers;

    protected DefaultHttpMessage(HttpVersion httpVersion) {
        this(httpVersion, DefaultHttpHeadersFactory.headersFactory());
    }

    @Deprecated
    protected DefaultHttpMessage(HttpVersion httpVersion, boolean bl, boolean bl2) {
        this(httpVersion, DefaultHttpHeadersFactory.headersFactory().withValidation(bl).withCombiningHeaders(bl2));
    }

    protected DefaultHttpMessage(HttpVersion httpVersion, HttpHeadersFactory httpHeadersFactory) {
        this(httpVersion, httpHeadersFactory.newHeaders());
    }

    protected DefaultHttpMessage(HttpVersion httpVersion, HttpHeaders httpHeaders) {
        this.version = (HttpVersion)ObjectUtil.checkNotNull((Object)httpVersion, (String)"version");
        this.headers = (HttpHeaders)ObjectUtil.checkNotNull((Object)httpHeaders, (String)"headers");
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    @Deprecated
    public HttpVersion getProtocolVersion() {
        return this.protocolVersion();
    }

    @Override
    public HttpVersion protocolVersion() {
        return this.version;
    }

    @Override
    public int hashCode() {
        int n = 31 + this.headers.hashCode();
        n = n * 31 + this.version.hashCode();
        n = n * 31 + super.hashCode();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttpMessage)) {
            return false;
        }
        DefaultHttpMessage defaultHttpMessage = (DefaultHttpMessage)object;
        return this.headers().equals(defaultHttpMessage.headers()) && this.protocolVersion().equals(defaultHttpMessage.protocolVersion()) && super.equals(object);
    }

    @Override
    public HttpMessage setProtocolVersion(HttpVersion httpVersion) {
        this.version = (HttpVersion)ObjectUtil.checkNotNull((Object)httpVersion, (String)"version");
        return this;
    }
}

