/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ReadOnlyHttpHeaders
extends HttpHeaders {
    private final CharSequence[] nameValuePairs;

    public ReadOnlyHttpHeaders(boolean bl, CharSequence ... charSequenceArray) {
        if ((charSequenceArray.length & 1) != 0) {
            throw ReadOnlyHttpHeaders.newInvalidArraySizeException();
        }
        if (bl) {
            ReadOnlyHttpHeaders.validateHeaders(charSequenceArray);
        }
        this.nameValuePairs = charSequenceArray;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("nameValuePairs must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(CharSequence ... charSequenceArray) {
        for (int i = 0; i < charSequenceArray.length; i += 2) {
            DefaultHttpHeadersFactory.headersFactory().getNameValidator().validateName((Object)charSequenceArray[i]);
        }
    }

    private CharSequence get0(CharSequence charSequence) {
        int n = AsciiString.hashCode((CharSequence)charSequence);
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            CharSequence charSequence2 = this.nameValuePairs[i];
            if (AsciiString.hashCode((CharSequence)charSequence2) != n || !AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence2, (CharSequence)charSequence)) continue;
            return this.nameValuePairs[i + 1];
        }
        return null;
    }

    @Override
    public final String get(String charSequence) {
        if ((charSequence = this.get0(charSequence)) == null) {
            return null;
        }
        return charSequence.toString();
    }

    @Override
    public final Integer getInt(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) == null) {
            return null;
        }
        return CharSequenceValueConverter.INSTANCE.convertToInt(charSequence);
    }

    @Override
    public final int getInt(CharSequence charSequence, int n) {
        if ((charSequence = this.get0(charSequence)) == null) {
            return n;
        }
        return CharSequenceValueConverter.INSTANCE.convertToInt(charSequence);
    }

    @Override
    public final Short getShort(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) == null) {
            return null;
        }
        return CharSequenceValueConverter.INSTANCE.convertToShort(charSequence);
    }

    @Override
    public final short getShort(CharSequence charSequence, short s) {
        if ((charSequence = this.get0(charSequence)) == null) {
            return s;
        }
        return CharSequenceValueConverter.INSTANCE.convertToShort(charSequence);
    }

    @Override
    public final Long getTimeMillis(CharSequence charSequence) {
        if ((charSequence = this.get0(charSequence)) == null) {
            return null;
        }
        return CharSequenceValueConverter.INSTANCE.convertToTimeMillis(charSequence);
    }

    @Override
    public final long getTimeMillis(CharSequence charSequence, long l) {
        if ((charSequence = this.get0(charSequence)) == null) {
            return l;
        }
        return CharSequenceValueConverter.INSTANCE.convertToTimeMillis(charSequence);
    }

    @Override
    public final List<String> getAll(String string) {
        if (((HttpHeaders)this).isEmpty()) {
            return Collections.emptyList();
        }
        int n = AsciiString.hashCode((CharSequence)string);
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            CharSequence charSequence = this.nameValuePairs[i];
            if (AsciiString.hashCode((CharSequence)charSequence) != n || !AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence, (CharSequence)string)) continue;
            arrayList.add(this.nameValuePairs[i + 1].toString());
        }
        return arrayList;
    }

    @Override
    public final List<Map.Entry<String, String>> entries() {
        if (((HttpHeaders)this).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(((HttpHeaders)this).size());
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            arrayList.add(new AbstractMap.SimpleImmutableEntry<String, String>(this.nameValuePairs[i].toString(), this.nameValuePairs[i + 1].toString()));
        }
        return arrayList;
    }

    @Override
    public final boolean contains(String string) {
        return this.get0(string) != null;
    }

    @Override
    public final boolean contains(String string, String string2, boolean bl) {
        return ((HttpHeaders)this).containsValue(string, string2, bl);
    }

    @Override
    public final boolean containsValue(CharSequence charSequence, CharSequence charSequence2, boolean n) {
        if (n != 0) {
            for (n = 0; n < this.nameValuePairs.length; n += 2) {
                if (!AsciiString.contentEqualsIgnoreCase((CharSequence)this.nameValuePairs[n], (CharSequence)charSequence) || !AsciiString.contentEqualsIgnoreCase((CharSequence)this.nameValuePairs[n + 1], (CharSequence)charSequence2)) continue;
                return true;
            }
        } else {
            for (n = 0; n < this.nameValuePairs.length; n += 2) {
                if (!AsciiString.contentEqualsIgnoreCase((CharSequence)this.nameValuePairs[n], (CharSequence)charSequence) || !AsciiString.contentEquals((CharSequence)this.nameValuePairs[n + 1], (CharSequence)charSequence2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final Iterator<String> valueStringIterator(CharSequence charSequence) {
        return new ReadOnlyStringValueIterator(charSequence);
    }

    public final Iterator<CharSequence> valueCharSequenceIterator(CharSequence charSequence) {
        return new ReadOnlyValueIterator(charSequence);
    }

    @Override
    public final Iterator<Map.Entry<String, String>> iterator() {
        return new ReadOnlyStringIterator();
    }

    @Override
    public final Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new ReadOnlyIterator();
    }

    @Override
    public final boolean isEmpty() {
        return this.nameValuePairs.length == 0;
    }

    @Override
    public final int size() {
        return this.nameValuePairs.length >>> 1;
    }

    @Override
    public final Set<String> names() {
        if (((HttpHeaders)this).isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(((HttpHeaders)this).size());
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            linkedHashSet.add(this.nameValuePairs[i].toString());
        }
        return linkedHashSet;
    }

    @Override
    public final HttpHeaders add(String string, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders add(String string, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders addInt(CharSequence charSequence, int n) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders addShort(CharSequence charSequence, short s) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders set(String string, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders set(String string, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders setInt(CharSequence charSequence, int n) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders setShort(CharSequence charSequence, short s) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders remove(String string) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders clear() {
        throw new UnsupportedOperationException("read only");
    }

    private final class ReadOnlyValueIterator
    implements Iterator<CharSequence> {
        private final CharSequence name;
        private final int nameHash;
        private int nextNameIndex;

        ReadOnlyValueIterator(CharSequence charSequence) {
            this.name = charSequence;
            this.nameHash = AsciiString.hashCode((CharSequence)charSequence);
            this.nextNameIndex = this.findNextValue();
        }

        @Override
        public final boolean hasNext() {
            return this.nextNameIndex != -1;
        }

        @Override
        public final CharSequence next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            CharSequence charSequence = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex + 1];
            this.nextNameIndex = this.findNextValue();
            return charSequence;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        private int findNextValue() {
            for (int i = this.nextNameIndex; i < ReadOnlyHttpHeaders.this.nameValuePairs.length; i += 2) {
                CharSequence charSequence = ReadOnlyHttpHeaders.this.nameValuePairs[i];
                if (this.nameHash != AsciiString.hashCode((CharSequence)charSequence) || !AsciiString.contentEqualsIgnoreCase((CharSequence)this.name, (CharSequence)charSequence)) continue;
                return i;
            }
            return -1;
        }
    }

    private final class ReadOnlyStringValueIterator
    implements Iterator<String> {
        private final CharSequence name;
        private final int nameHash;
        private int nextNameIndex;

        ReadOnlyStringValueIterator(CharSequence charSequence) {
            this.name = charSequence;
            this.nameHash = AsciiString.hashCode((CharSequence)charSequence);
            this.nextNameIndex = this.findNextValue();
        }

        @Override
        public final boolean hasNext() {
            return this.nextNameIndex != -1;
        }

        @Override
        public final String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex + 1].toString();
            this.nextNameIndex = this.findNextValue();
            return string;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        private int findNextValue() {
            for (int i = this.nextNameIndex; i < ReadOnlyHttpHeaders.this.nameValuePairs.length; i += 2) {
                CharSequence charSequence = ReadOnlyHttpHeaders.this.nameValuePairs[i];
                if (this.nameHash != AsciiString.hashCode((CharSequence)charSequence) || !AsciiString.contentEqualsIgnoreCase((CharSequence)this.name, (CharSequence)charSequence)) continue;
                return i;
            }
            return -1;
        }
    }

    private final class ReadOnlyStringIterator
    implements Iterator<Map.Entry<String, String>>,
    Map.Entry<String, String> {
        private String key;
        private String value;
        private int nextNameIndex;

        private ReadOnlyStringIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.nextNameIndex != ReadOnlyHttpHeaders.this.nameValuePairs.length;
        }

        @Override
        public final Map.Entry<String, String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.key = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex].toString();
            this.value = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex + 1].toString();
            this.nextNameIndex += 2;
            return this;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public final String getKey() {
            return this.key;
        }

        @Override
        public final String getValue() {
            return this.value;
        }

        @Override
        public final String setValue(String string) {
            throw new UnsupportedOperationException("read only");
        }

        public final String toString() {
            return this.key + '=' + this.value;
        }
    }

    private final class ReadOnlyIterator
    implements Iterator<Map.Entry<CharSequence, CharSequence>>,
    Map.Entry<CharSequence, CharSequence> {
        private CharSequence key;
        private CharSequence value;
        private int nextNameIndex;

        private ReadOnlyIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.nextNameIndex != ReadOnlyHttpHeaders.this.nameValuePairs.length;
        }

        @Override
        public final Map.Entry<CharSequence, CharSequence> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.key = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex];
            this.value = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex + 1];
            this.nextNameIndex += 2;
            return this;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public final CharSequence getKey() {
            return this.key;
        }

        @Override
        public final CharSequence getValue() {
            return this.value;
        }

        @Override
        public final CharSequence setValue(CharSequence charSequence) {
            throw new UnsupportedOperationException("read only");
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }
    }
}

