/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.internal.ObjectUtil;
import java.net.URI;

public final class WebSocketClientProtocolConfig {
    static final boolean DEFAULT_PERFORM_MASKING = true;
    static final boolean DEFAULT_ALLOW_MASK_MISMATCH = false;
    static final boolean DEFAULT_HANDLE_CLOSE_FRAMES = true;
    static final boolean DEFAULT_DROP_PONG_FRAMES = true;
    static final boolean DEFAULT_GENERATE_ORIGIN_HEADER = true;
    static final boolean DEFAULT_WITH_UTF8_VALIDATOR = true;
    private final URI webSocketUri;
    private final String subprotocol;
    private final WebSocketVersion version;
    private final boolean allowExtensions;
    private final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;
    private final boolean performMasking;
    private final boolean allowMaskMismatch;
    private final boolean handleCloseFrames;
    private final WebSocketCloseStatus sendCloseFrame;
    private final boolean dropPongFrames;
    private final long handshakeTimeoutMillis;
    private final long forceCloseTimeoutMillis;
    private final boolean absoluteUpgradeUrl;
    private final boolean generateOriginHeader;
    private final boolean withUTF8Validator;

    private WebSocketClientProtocolConfig(URI uRI, String string, WebSocketVersion webSocketVersion, boolean bl, HttpHeaders httpHeaders, int n, boolean bl2, boolean bl3, boolean bl4, WebSocketCloseStatus webSocketCloseStatus, boolean bl5, long l, long l2, boolean bl6, boolean bl7, boolean bl8) {
        this.webSocketUri = uRI;
        this.subprotocol = string;
        this.version = webSocketVersion;
        this.allowExtensions = bl;
        this.customHeaders = httpHeaders;
        this.maxFramePayloadLength = n;
        this.performMasking = bl2;
        this.allowMaskMismatch = bl3;
        this.forceCloseTimeoutMillis = l2;
        this.handleCloseFrames = bl4;
        this.sendCloseFrame = webSocketCloseStatus;
        this.dropPongFrames = bl5;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositive((long)l, (String)"handshakeTimeoutMillis");
        this.absoluteUpgradeUrl = bl6;
        this.generateOriginHeader = bl7;
        this.withUTF8Validator = bl8;
    }

    public final URI webSocketUri() {
        return this.webSocketUri;
    }

    public final String subprotocol() {
        return this.subprotocol;
    }

    public final WebSocketVersion version() {
        return this.version;
    }

    public final boolean allowExtensions() {
        return this.allowExtensions;
    }

    public final HttpHeaders customHeaders() {
        return this.customHeaders;
    }

    public final int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public final boolean performMasking() {
        return this.performMasking;
    }

    public final boolean allowMaskMismatch() {
        return this.allowMaskMismatch;
    }

    public final boolean handleCloseFrames() {
        return this.handleCloseFrames;
    }

    public final WebSocketCloseStatus sendCloseFrame() {
        return this.sendCloseFrame;
    }

    public final boolean dropPongFrames() {
        return this.dropPongFrames;
    }

    public final long handshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public final long forceCloseTimeoutMillis() {
        return this.forceCloseTimeoutMillis;
    }

    public final boolean absoluteUpgradeUrl() {
        return this.absoluteUpgradeUrl;
    }

    public final boolean generateOriginHeader() {
        return this.generateOriginHeader;
    }

    public final boolean withUTF8Validator() {
        return this.withUTF8Validator;
    }

    public final String toString() {
        return "WebSocketClientProtocolConfig {webSocketUri=" + this.webSocketUri + ", subprotocol=" + this.subprotocol + ", version=" + (Object)((Object)this.version) + ", allowExtensions=" + this.allowExtensions + ", customHeaders=" + this.customHeaders + ", maxFramePayloadLength=" + this.maxFramePayloadLength + ", performMasking=" + this.performMasking + ", allowMaskMismatch=" + this.allowMaskMismatch + ", handleCloseFrames=" + this.handleCloseFrames + ", sendCloseFrame=" + this.sendCloseFrame + ", dropPongFrames=" + this.dropPongFrames + ", handshakeTimeoutMillis=" + this.handshakeTimeoutMillis + ", forceCloseTimeoutMillis=" + this.forceCloseTimeoutMillis + ", absoluteUpgradeUrl=" + this.absoluteUpgradeUrl + ", generateOriginHeader=" + this.generateOriginHeader + "}";
    }

    public final Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder(URI.create("https://localhost/"), null, WebSocketVersion.V13, false, EmptyHttpHeaders.INSTANCE, 65536, true, false, true, WebSocketCloseStatus.NORMAL_CLOSURE, true, 10000L, -1L, false, true, true);
    }

    public static final class Builder {
        private URI webSocketUri;
        private String subprotocol;
        private WebSocketVersion version;
        private boolean allowExtensions;
        private HttpHeaders customHeaders;
        private int maxFramePayloadLength;
        private boolean performMasking;
        private boolean allowMaskMismatch;
        private boolean handleCloseFrames;
        private WebSocketCloseStatus sendCloseFrame;
        private boolean dropPongFrames;
        private long handshakeTimeoutMillis;
        private long forceCloseTimeoutMillis;
        private boolean absoluteUpgradeUrl;
        private boolean generateOriginHeader;
        private boolean withUTF8Validator;

        private Builder(WebSocketClientProtocolConfig webSocketClientProtocolConfig) {
            this(((WebSocketClientProtocolConfig)ObjectUtil.checkNotNull((Object)webSocketClientProtocolConfig, (String)"clientConfig")).webSocketUri(), webSocketClientProtocolConfig.subprotocol(), webSocketClientProtocolConfig.version(), webSocketClientProtocolConfig.allowExtensions(), webSocketClientProtocolConfig.customHeaders(), webSocketClientProtocolConfig.maxFramePayloadLength(), webSocketClientProtocolConfig.performMasking(), webSocketClientProtocolConfig.allowMaskMismatch(), webSocketClientProtocolConfig.handleCloseFrames(), webSocketClientProtocolConfig.sendCloseFrame(), webSocketClientProtocolConfig.dropPongFrames(), webSocketClientProtocolConfig.handshakeTimeoutMillis(), webSocketClientProtocolConfig.forceCloseTimeoutMillis(), webSocketClientProtocolConfig.absoluteUpgradeUrl(), webSocketClientProtocolConfig.generateOriginHeader(), webSocketClientProtocolConfig.withUTF8Validator());
        }

        private Builder(URI uRI, String string, WebSocketVersion webSocketVersion, boolean bl, HttpHeaders httpHeaders, int n, boolean bl2, boolean bl3, boolean bl4, WebSocketCloseStatus webSocketCloseStatus, boolean bl5, long l, long l2, boolean bl6, boolean bl7, boolean bl8) {
            this.webSocketUri = uRI;
            this.subprotocol = string;
            this.version = webSocketVersion;
            this.allowExtensions = bl;
            this.customHeaders = httpHeaders;
            this.maxFramePayloadLength = n;
            this.performMasking = bl2;
            this.allowMaskMismatch = bl3;
            this.handleCloseFrames = bl4;
            this.sendCloseFrame = webSocketCloseStatus;
            this.dropPongFrames = bl5;
            this.handshakeTimeoutMillis = l;
            this.forceCloseTimeoutMillis = l2;
            this.absoluteUpgradeUrl = bl6;
            this.generateOriginHeader = bl7;
            this.withUTF8Validator = bl8;
        }

        public final Builder webSocketUri(String string) {
            return this.webSocketUri(URI.create(string));
        }

        public final Builder webSocketUri(URI uRI) {
            this.webSocketUri = uRI;
            return this;
        }

        public final Builder subprotocol(String string) {
            this.subprotocol = string;
            return this;
        }

        public final Builder version(WebSocketVersion webSocketVersion) {
            this.version = webSocketVersion;
            return this;
        }

        public final Builder allowExtensions(boolean bl) {
            this.allowExtensions = bl;
            return this;
        }

        public final Builder customHeaders(HttpHeaders httpHeaders) {
            this.customHeaders = httpHeaders;
            return this;
        }

        public final Builder maxFramePayloadLength(int n) {
            this.maxFramePayloadLength = n;
            return this;
        }

        public final Builder performMasking(boolean bl) {
            this.performMasking = bl;
            return this;
        }

        public final Builder allowMaskMismatch(boolean bl) {
            this.allowMaskMismatch = bl;
            return this;
        }

        public final Builder handleCloseFrames(boolean bl) {
            this.handleCloseFrames = bl;
            return this;
        }

        public final Builder sendCloseFrame(WebSocketCloseStatus webSocketCloseStatus) {
            this.sendCloseFrame = webSocketCloseStatus;
            return this;
        }

        public final Builder dropPongFrames(boolean bl) {
            this.dropPongFrames = bl;
            return this;
        }

        public final Builder handshakeTimeoutMillis(long l) {
            this.handshakeTimeoutMillis = l;
            return this;
        }

        public final Builder forceCloseTimeoutMillis(long l) {
            this.forceCloseTimeoutMillis = l;
            return this;
        }

        public final Builder absoluteUpgradeUrl(boolean bl) {
            this.absoluteUpgradeUrl = bl;
            return this;
        }

        public final Builder generateOriginHeader(boolean bl) {
            this.generateOriginHeader = bl;
            return this;
        }

        public final Builder withUTF8Validator(boolean bl) {
            this.withUTF8Validator = bl;
            return this;
        }

        public final WebSocketClientProtocolConfig build() {
            return new WebSocketClientProtocolConfig(this.webSocketUri, this.subprotocol, this.version, this.allowExtensions, this.customHeaders, this.maxFramePayloadLength, this.performMasking, this.allowMaskMismatch, this.handleCloseFrames, this.sendCloseFrame, this.dropPongFrames, this.handshakeTimeoutMillis, this.forceCloseTimeoutMillis, this.absoluteUpgradeUrl, this.generateOriginHeader, this.withUTF8Validator);
        }
    }
}

